/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdhb;
import com.google.android.gms.internal.zzdhh;
import com.google.android.gms.internal.zzdhk;
import com.google.android.gms.internal.zzdho;
import com.google.android.gms.internal.zzdht;
import com.google.android.gms.internal.zzdjn;
import com.google.android.gms.internal.zzdjo;
import com.google.android.gms.internal.zzdjp;
import com.google.android.gms.internal.zzeuk;
import com.google.android.gms.internal.zzevz;
import com.google.android.gms.internal.zzewl;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

public final class zzdiq
implements zzdhk<zzdho> {
    zzdiq() {
    }

    private final zzdho zzaa(zzeuk zzeuk2) throws GeneralSecurityException {
        try {
            zzdjn zzdjn2;
            zzdhh.zza zza2;
            zzdhh.zza zza3;
            zzdhh.zza zza4 = zza3 = zzdhh.zza.zzn(zzeuk2);
            zzdhh.zza zza5 = zza3;
            if (!(zza3 instanceof zzdhh.zza)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdhh.zza zza6 = zza2 = zza5;
            zzdjp.zzq(zza2.getVersion(), 0);
            if (zza6.zzbkf().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdiq.zzc(zza6.zzblr());
            zzdhb zzdhb2 = zza2.zzblr().zzblx();
            byte[] byArray = zza2.zzbkf().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zza2.zzblr().zzbly();
            switch (zzdhb2) {
                case zzlcp: {
                    zzdjn2 = new zzdjn("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzlcr: {
                    zzdjn2 = new zzdjn("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzlcs: {
                    zzdjn2 = new zzdjn("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdjn2;
        }
        catch (zzevz zzevz2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzevz2);
        }
    }

    @Override
    public final zzewl zzr(zzeuk zzeuk2) throws GeneralSecurityException {
        try {
            zzdhh.zzb zzb2 = zzdhh.zzb.zzp(zzeuk2);
            return this.zzb((zzewl)zzb2);
        }
        catch (zzevz zzevz2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzevz2);
        }
    }

    @Override
    public final zzewl zzb(zzewl zzewl2) throws GeneralSecurityException {
        zzdhh.zzb zzb2;
        if (!(zzewl2 instanceof zzdhh.zzb)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdhh.zzb zzb3 = zzb2 = (zzdhh.zzb)zzewl2;
        if (zzb2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdiq.zzc(zzb3.zzblr());
        return zzdhh.zza.zzbls().zzfk(0).zzb(zzb2.zzblr()).zzo(zzeuk.zzaz((byte[])zzdjo.zzft(zzb2.getKeySize()))).zzcuf();
    }

    @Override
    public final zzdht.zzb zzs(zzeuk zzeuk2) throws GeneralSecurityException {
        zzdhh.zza zza2 = (zzdhh.zza)this.zzr(zzeuk2);
        return (zzdht.zzb)zzdht.zzb.zzbmr().zzoh("type.googleapis.com/google.crypto.tink.HmacKey").zzw(zza2.toByteString()).zzb(zzdht.zzb.zzb.zzlep).zzcuf();
    }

    @Override
    public final String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacKey";
    }

    private static void zzc(zzdhh.zzc zzc2) throws GeneralSecurityException {
        if (zzc2.zzbly() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzc2.zzblx()) {
            case zzlcp: {
                if (zzc2.zzbly() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlcr: {
                if (zzc2.zzbly() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlcs: {
                if (zzc2.zzbly() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzewl zzewl2) throws GeneralSecurityException {
        zzdhh.zza zza2;
        zzewl zzewl3 = zzewl2;
        if (!(zzewl3 instanceof zzdhh.zza)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdhh.zza zza3 = zza2 = (zzdhh.zza)zzewl3;
        zzdjp.zzq(zza2.getVersion(), 0);
        if (zza3.zzbkf().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdiq.zzc(zza3.zzblr());
        zzdhb zzdhb2 = zza2.zzblr().zzblx();
        byte[] byArray = zza2.zzbkf().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zza2.zzblr().zzbly();
        switch (zzdhb2) {
            case zzlcp: {
                return new zzdjn("HMACSHA1", secretKeySpec, n);
            }
            case zzlcr: {
                return new zzdjn("HMACSHA256", secretKeySpec, n);
            }
            case zzlcs: {
                return new zzdjn("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zzq(zzeuk zzeuk2) throws GeneralSecurityException {
        return this.zzaa(zzeuk2);
    }
}

