/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdjd;
import com.google.android.gms.internal.zzdje;
import com.google.android.gms.internal.zzdjf;
import com.google.android.gms.internal.zzdjg;
import com.google.android.gms.internal.zzdjh;
import com.google.android.gms.internal.zzdji;
import com.google.android.gms.internal.zzdjj;
import com.google.android.gms.internal.zzdjk;
import com.google.android.gms.internal.zzdjp;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;

public class zzdjc<T_WRAPPER extends zzdjd<T_ENGINE>, T_ENGINE> {
    private static final Logger logger = Logger.getLogger(zzdjc.class.getName());
    private static final List<Provider> zzlhf;
    public static final zzdjc<zzdje, Cipher> zzlhg;
    public static final zzdjc<zzdji, Mac> zzlhh;
    private static zzdjc<zzdjk, Signature> zzlhi;
    private static zzdjc<zzdjj, MessageDigest> zzlhj;
    public static final zzdjc<zzdjf, KeyAgreement> zzlhk;
    public static final zzdjc<zzdjh, KeyPairGenerator> zzlhl;
    private static zzdjc<zzdjg, KeyFactory> zzlhm;
    private T_WRAPPER zzlhn;
    private List<Provider> zzlho;
    private boolean zzlhp;

    private zzdjc(T_WRAPPER T_WRAPPER) {
        this.zzlhn = T_WRAPPER;
        this.zzlho = zzlhf;
        this.zzlhp = true;
    }

    public final T_ENGINE zzoj(String string2) throws GeneralSecurityException {
        for (Provider provider : this.zzlho) {
            if (!this.zza(string2, provider)) continue;
            return (T_ENGINE)this.zzlhn.zzb(string2, provider);
        }
        if (this.zzlhp) {
            return (T_ENGINE)this.zzlhn.zzb(string2, null);
        }
        throw new GeneralSecurityException("No good Provider found.");
    }

    private final boolean zza(String string2, Provider provider) {
        try {
            this.zzlhn.zzb(string2, provider);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        if (zzdjp.isAndroid()) {
            String[] stringArray = new String[]{"GmsCore_OpenSSL", "AndroidOpenSSL"};
            ArrayList<Provider> arrayList = new ArrayList<Provider>();
            String[] stringArray2 = stringArray;
            for (int i = 0; i < 2; ++i) {
                String string2 = stringArray2[i];
                Provider provider = Security.getProvider(string2);
                if (provider != null) {
                    arrayList.add(provider);
                    continue;
                }
                logger.logp(Level.INFO, "com.google.crypto.tink.subtle.EngineFactory", "toProviderList", String.format("Provider %s not available", string2));
            }
            zzlhf = arrayList;
        } else {
            zzlhf = new ArrayList<Provider>();
        }
        zzlhg = new zzdjc(new zzdje());
        zzlhh = new zzdjc(new zzdji());
        zzlhi = new zzdjc(new zzdjk());
        zzlhj = new zzdjc(new zzdjj());
        zzlhk = new zzdjc(new zzdjf());
        zzlhl = new zzdjc(new zzdjh());
        zzlhm = new zzdjc(new zzdjg());
    }
}

