/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzfy;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzzn
@TargetApi(value=14)
public final class zzfw
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzawf;
    private final Context mApplicationContext;
    private Application zzawg;
    private final WindowManager zzauy;
    private final PowerManager zzauz;
    private final KeyguardManager zzava;
    @Nullable
    private BroadcastReceiver zzavi;
    private WeakReference<ViewTreeObserver> zzawh;
    private WeakReference<View> zzawi;
    private zzgb zzawj;
    private zzaiy zzaue = new zzaiy(zzawf);
    private boolean zzavh = false;
    private int zzawk = -1;
    private HashSet<zzga> zzawl = new HashSet();
    private DisplayMetrics zzawm;

    public zzfw(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzauy = (WindowManager)context.getSystemService("window");
        this.zzauz = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzava = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzawg = (Application)this.mApplicationContext;
            this.zzawj = new zzgb((Application)this.mApplicationContext, this);
        }
        this.zzawm = context.getResources().getDisplayMetrics();
        View view2 = view;
        zzfw zzfw2 = this;
        View view3 = zzfw2.zzawi != null ? (View)zzfw2.zzawi.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfw2);
            zzfw2.zze(view3);
        }
        zzfw2.zzawi = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbv.zzec().isAttachedToWindow(view2)) {
                zzfw2.zzd(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfw2);
        }
    }

    public final void zza(zzga zzga2) {
        this.zzawl.add(zzga2);
        this.zzk(3);
    }

    public final void zzb(zzga zzga2) {
        this.zzawl.remove(zzga2);
    }

    private final void zzgb() {
        zzbv.zzea();
        zzahg.zzdca.post((Runnable)new zzfx(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzawk = -1;
        this.zzd(view);
        this.zzk(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzawk = -1;
        this.zzk(3);
        this.zzgb();
        this.zze(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzawi == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzawi.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzawk = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzk(3);
        this.zzgb();
    }

    public final void onGlobalLayout() {
        this.zzk(2);
        this.zzgb();
    }

    public final void onScrollChanged() {
        this.zzk(1);
    }

    public final void zzgc() {
        this.zzk(4);
    }

    private final void zzk(int n) {
        boolean bl;
        if (this.zzawl.size() == 0) {
            return;
        }
        if (this.zzawi == null) {
            return;
        }
        View view = (View)this.zzawi.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        new Rect().right = this.zzauy.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzauy.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzafy.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzawk != -1 ? this.zzawk : n2;
        boolean bl6 = bl = !bl3 && zzbv.zzea().zza(view, this.zzauz, this.zzava) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzaue.tryAcquire() && bl == this.zzavh) {
            return;
        }
        if (!bl && !this.zzavh && n == 1) {
            return;
        }
        zzfz zzfz2 = new zzfz(zzbv.zzeg().elapsedRealtime(), this.zzauz.isScreenOn(), view != null ? zzbv.zzec().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzawm.density, bl);
        Iterator<zzga> iterator = this.zzawl.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzfz2);
        }
        this.zzavh = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzl(rect.left), this.zzl(rect.top), this.zzl(rect.right), this.zzl(rect.bottom));
    }

    private final int zzl(int n) {
        float f = this.zzawm.density;
        return (int)((float)n / f);
    }

    private final void zzd(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzawh = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzfw zzfw2 = this;
        if (zzfw2.zzavi == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzfw2.zzavi = new zzfy(zzfw2);
            zzfw2.mApplicationContext.registerReceiver(zzfw2.zzavi, intentFilter);
        }
        if (this.zzawg != null) {
            try {
                this.zzawg.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzawj);
                return;
            }
            catch (Exception exception) {
                zzafy.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzawh != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzawh.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzawh = null;
            }
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzfw zzfw2 = this;
        if (zzfw2.zzavi != null) {
            try {
                zzfw2.mApplicationContext.unregisterReceiver(zzfw2.zzavi);
            }
            catch (IllegalStateException illegalStateException) {
                zzafy.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbv.zzee().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzfw2.zzavi = null;
        }
        if (this.zzawg != null) {
            try {
                this.zzawg.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzawj);
                return;
            }
            catch (Exception exception) {
                zzafy.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzfw zzfw2, int n) {
        zzfw2.zzk(3);
    }

    static {
        zzmd<Long> zzmd2 = zzmn.zzbkq;
        zzawf = zzbv.zzen().zzd(zzmd2);
    }
}

