/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaez;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public class zzob
implements zznx {
    private final Object mLock = new Object();
    private final zzny zzbsm;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbsp;
    @Nullable
    private zzyg zzaqq;
    @Nullable
    private final zznz zzbsq;
    private final zzcs zzbsr;
    @Nullable
    private final zzajl zzaos;
    boolean zzbss;
    @Nullable
    private String zzbst;
    @Nullable
    private zzaez zzaph;
    private WeakReference<View> zzbsu = null;

    public zzob(Context context, zzny zzny2, @Nullable zzyg zzyg2, zzcs zzcs2, @Nullable JSONObject jSONObject, @Nullable zznz zznz2, @Nullable zzajl zzajl2, @Nullable String string) {
        this.mContext = context;
        this.zzbsm = zzny2;
        this.zzaqq = zzyg2;
        this.zzbsr = zzcs2;
        this.zzbsp = jSONObject;
        this.zzbsq = zznz2;
        this.zzaos = zzajl2;
        this.zzbst = string;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zznm zznm2 = this.zzbsq.zzjm();
        if (zznm2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zznm2.zzjg()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zznn zznn2 = new zznn(this.mContext, zznm2, layoutParams);
        zznn2.setOnClickListener(onClickListener);
        zzmd<String> zzmd2 = zzmn.zzbmx;
        zznn2.setContentDescription(zzbv.zzen().zzd(zzmd2));
        return zznn2;
    }

    @Override
    public boolean zzjt() {
        zznm zznm2 = this.zzbsq.zzjm();
        return zznm2 != null && zznm2.zzjh();
    }

    private final boolean zzap(String string) {
        JSONObject jSONObject = this.zzbsp == null ? null : this.zzbsp.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string, false);
    }

    @Override
    public final void zza(View view, String string, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzi(view2);
        JSONObject jSONObject3 = zzob.zzj(view2);
        JSONObject jSONObject4 = null;
        try {
            JSONObject jSONObject5 = zzbv.zzea().zza(bundle, null);
            jSONObject4 = new JSONObject();
            jSONObject4.put("click_point", (Object)jSONObject5);
            jSONObject4.put("asset_id", (Object)string);
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Error occured while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, string, jSONObject4, null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbp.zzfy((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), bundle, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzbsq.zzjl())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzbsq.zzjl())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzafy.zzca((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzap("click_reporting")) {
            zzafy.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbv.zzea().zza(bundle, null);
        this.zza(null, null, null, null, string, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String string, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbp.zzfy((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbsp);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("click_signal", (Object)jSONObject4);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("asset_id", (Object)string);
            jSONObject7.put("template", (Object)this.zzbsq.zzjl());
            jSONObject7.put("has_custom_click_handler", this.zzbsm.zzq(this.zzbsq.getCustomTemplateId()) != null);
            jSONObject6.put("has_custom_click_handler", this.zzbsm.zzq(this.zzbsq.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject8 = this.zzbsp.optJSONObject("tracking_urls_and_actions");
                if (jSONObject8 == null) {
                    jSONObject8 = new JSONObject();
                }
                String string2 = jSONObject8.optString("click_string");
                String string3 = this.zzbsr.zzac().zza(this.mContext, string2, view);
                jSONObject7.put("click_signals", (Object)string3);
            }
            catch (Exception exception) {
                zzafy.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject6.put("click", (Object)jSONObject7);
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            jSONObject6.put("ads_id", (Object)this.zzbst);
            this.zzaqq.zza(new zzoc(this, jSONObject6));
            return;
        }
        catch (JSONException jSONException) {
            zzafy.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzbsr.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzafy.zzca((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzap("touch_reporting")) {
            zzafy.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbsr.zzac().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbss) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zza(view, map);
            return;
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzi(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzob.zzj(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzap("impression_reporting")) {
            zzafy.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbv.zzea().zza(bundle, null);
        return this.zza(null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4) {
        zzbp.zzfy((String)"recordImpression must be called on the main UI thread.");
        this.zzbss = true;
        try {
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzbsp);
            jSONObject5.put("ads_id", (Object)this.zzbst);
            if (jSONObject2 != null) {
                jSONObject5.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject5.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject5.put("provided_signals", (Object)jSONObject4);
            }
            this.zzaqq.zza(new zzod(this, jSONObject5));
            this.zzaqq.zza(new zzoe(this.zzbsm, this.zzbst));
        }
        catch (JSONException jSONException) {
            zzafy.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbsm.zza(this);
        this.zzbsm.zzbu();
        return true;
    }

    @Override
    public final View zzjz() {
        if (this.zzbsu != null) {
            return (View)this.zzbsu.get();
        }
        return null;
    }

    @Override
    public final void zzg(View view) {
        this.zzbsu = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        zzmd<Boolean> zzmd2 = zzmn.zzbmv;
        if (!zzbv.zzen().zzd(zzmd2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzmd<Boolean> zzmd2 = zzmn.zzbmu;
        if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzakl zzjw() throws zzakx {
        if (this.zzbsp == null || this.zzbsp.optJSONObject("overlay") == null) {
            return null;
        }
        Object object = this;
        zzajl zzajl2 = ((zzob)object).zzaos;
        zzcs zzcs2 = ((zzob)object).zzbsr;
        zziu zziu2 = zziu.zzh((Context)((zzob)object).mContext);
        Context context = ((zzob)object).mContext;
        zzakl zzakl2 = zzbv.zzeb().zza(context, zziu2, false, false, zzcs2, zzajl2, null, null, null, zzhz.zzhf());
        if (zzakl2 == null) {
            throw null;
        }
        ((View)zzakl2).setVisibility(8);
        object = new zzof(zzakl2);
        this.zzaqq.zza(new zzol((zzof)object));
        return zzakl2;
    }

    public final void zze(Map<String, WeakReference<View>> map) {
        if (this.zzbsq.zzjn() != null) {
            if ("2".equals(this.zzbsq.zzjl())) {
                zzbv.zzee().zzb(this.mContext, this.zzbsm.getAdUnitId(), this.zzbsq.zzjl(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzbsq.zzjl())) {
                zzbv.zzee().zzb(this.mContext, this.zzbsm.getAdUnitId(), this.zzbsq.zzjl(), map.containsKey("1009"));
            }
        }
    }

    public final boolean zzb(View view, zznv zznv2) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzbsq.zzjn();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbsm.zza(zznv2);
            return true;
        }
        return false;
    }

    @Override
    public final void zza(View view, zznv zznv2) {
        Object object;
        zzov zzov2;
        if (this.zzb(view, zznv2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzbsq instanceof zzoa)) {
            return;
        }
        zzoa zzoa2 = (zzoa)this.zzbsq;
        if (zzoa2.getImages() != null && zzoa2.getImages().size() > 0 && (zzov2 = (object = zzoa2.getImages().get(0)) instanceof IBinder ? zzow.zzk((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzov2.zzji();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzx((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzob)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzafy.zzcr((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zzjy() {
        this.zzbsm.zzcn();
    }

    @Override
    public void zzjx() {
        this.zzaqq.zzli();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzh(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzr(int n) {
        zzjh.zzhu();
        return zzajf.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzr(rect.right - rect.left));
        jSONObject.put("height", this.zzr(rect.bottom - rect.top));
        jSONObject.put("x", this.zzr(rect.left));
        jSONObject.put("y", this.zzr(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzi(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzob.zzh(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzr(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzr(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzr(nArray[0]));
            jSONObject3.put("y", this.zzr(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzr(nArray[0]));
                jSONObject2.put("y", this.zzr(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzafy.zzcr((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzj(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzea();
            int n = zzahg.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzob.zzh(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzob.zzh(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzr(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzr(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzr(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzr(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzr(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzr(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzafy.zzcr((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzaez zzka() {
        if (zzbv.zzez().zzs(this.mContext)) {
            if (this.zzaph == null) {
                this.zzaph = new zzaez(this.mContext, this.zzbsm.getAdUnitId());
            }
            return this.zzaph;
        }
        return null;
    }
}

