/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzzn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzzn
public final class zzrz
implements zzrg {
    private boolean zzbwd;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzjh.zzhu();
                n2 = zzajf.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzafy.zzcr((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public final void zza(zzakl zzakl2, Map<String, String> map) {
        Object object;
        Object object2;
        String string2 = map.get("action");
        if (string2 == null) {
            zzafy.zzcr((String)"Action missing from video GMSG.");
            return;
        }
        if (zzafy.zzad((int)3)) {
            object2 = new JSONObject(map);
            object2.remove("google.afma.Notify_dt");
            object = object2.toString();
            zzafy.zzca((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object).toString());
        }
        if ("background".equals(string2)) {
            object2 = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object2)) {
                zzafy.zzcr((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object2);
                zzakl2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzafy.zzcr((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object2 = map.get("mimeTypes");
            if (object2 == null) {
                zzafy.zzcr((String)"No MIME types specified for decoder properties inspection.");
                zzaa.zza(zzakl2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzafy.zzcr((String)"Video decoder properties available on API versions >= 16.");
                zzaa.zza(zzakl2, "deficientApiVersion");
                return;
            }
            object = new HashMap();
            for (String string3 : ((String)object2).split(",")) {
                object.put(string3, zzajd.zzco(string3.trim()));
            }
            zzaa.zzc(zzakl2, (Map<String, List<Map<String, Object>>>)object);
            return;
        }
        object2 = zzakl2.zzsm();
        if (object2 == null) {
            zzafy.zzcr((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzakl2.getContext();
            int n2 = zzrz.zza(context, map, "x", 0);
            int n3 = zzrz.zza(context, map, "y", 0);
            int n4 = zzrz.zza(context, map, "w", -1);
            int n5 = zzrz.zza(context, map, "h", -1);
            zzmd<Boolean> zzmd2 = zzmn.zzbmy;
            if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
                n4 = Math.min(n4, zzakl2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzakl2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzakk)object2).zzrx() == null) {
                zzaq zzaq2 = new zzaq(map.get("flags"));
                ((zzakk)object2).zza(n2, n3, n4, n5, n, bl3, zzaq2);
                zzaa zzaa2 = ((zzakk)object2).zzrx();
                if (zzaa2 != null) {
                    zzrz.zza(zzaa2, map);
                }
                return;
            }
            ((zzakk)object2).zze(n2, n3, n4, n5);
            return;
        }
        zzaa zzaa3 = ((zzakk)object2).zzrx();
        if (zzaa3 == null) {
            zzaa.zzg(zzakl2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzakl2.getContext();
            int n = zzrz.zza(context, map, "x", 0);
            int n6 = zzrz.zza(context, map, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzaa3.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = map.get("time");
            if (string4 == null) {
                zzafy.zzcr((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzaa3.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzafy.zzcr((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzaa3.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzaa3.zzne();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzrz.zza(zzaa3, map);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean(map.get("muted"))) {
                zzaa3.zznf();
                return;
            }
            zzaa3.zzng();
            return;
        }
        if ("pause".equals(string2)) {
            zzaa3.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzaa3.play();
            return;
        }
        if ("show".equals(string2)) {
            zzaa3.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzaa3.zzbp(map.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzakl2.getContext();
            int n = zzrz.zza(context, map, "dx", 0);
            int n7 = zzrz.zza(context, map, "dy", 0);
            zzaa3.zza(n, n7);
            if (!this.zzbwd) {
                zzakl2.zzsc().zzmw();
                this.zzbwd = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = map.get("volume");
            if (string6 == null) {
                zzafy.zzcr((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzaa3.zzb(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzafy.zzcr((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzaa3.zznh();
            return;
        }
        String string8 = String.valueOf(string2);
        zzafy.zzcr((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }

    private static void zza(zzaa zzaa2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzafy.zzcr((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }
}

