/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzud;
import com.google.android.gms.internal.zzue;
import com.google.android.gms.internal.zzug;
import com.google.android.gms.internal.zzui;
import com.google.android.gms.internal.zzuj;
import com.google.android.gms.internal.zzuk;
import com.google.android.gms.internal.zzul;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzvc;
import com.google.android.gms.internal.zzvn;
import com.google.android.gms.internal.zzwh;
import com.google.android.gms.internal.zzzn;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzuh
implements zzul {
    private final String zzcbo;
    private final zzut zzamq;
    private final long zzcbp;
    private final zzue zzcbq;
    private final zzud zzcbr;
    private zziq zzaqz;
    private final zziu zzarf;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzajl zzaos;
    private final boolean zzauq;
    private final zzom zzaoo;
    private final List<String> zzaop;
    private final List<String> zzcbs;
    private final List<String> zzcbt;
    private final boolean zzcbu;
    private zzuw zzcbv;
    private int zzcbw = -2;
    private zzvc zzcbx;

    public zzuh(Context context, String string, zzut zzut2, zzue zzue2, zzud zzud2, zziq zziq2, zziu zziu2, zzajl zzajl2, boolean bl, boolean bl2, zzom zzom2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzamq = zzut2;
        this.zzcbr = zzud2;
        this.zzcbo = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzlo() : string;
        this.zzcbq = zzue2;
        this.zzcbp = zzue2.zzcav != -1L ? zzue2.zzcav : 10000L;
        this.zzaqz = zziq2;
        this.zzarf = zziu2;
        this.zzaos = zzajl2;
        this.zzauq = bl;
        this.zzcbu = bl2;
        this.zzaoo = zzom2;
        this.zzaop = list;
        this.zzcbs = list2;
        this.zzcbt = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzcbv != null) {
                    this.zzcbv.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzafy.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzcbw = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzlo() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzcbr.zzcag)) {
                if (this.zzamq.zzbh(this.zzcbr.zzcag)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzt(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbw = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzvc zzvc2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbw = 0;
            this.zzcbx = zzvc2;
            this.mLock.notify();
            return;
        }
    }

    private static zzuw zza(MediationAdapter mediationAdapter) {
        return new zzvn(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzuk zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzug zzug2 = new zzug();
            zzahg.zzdca.post((Runnable)new zzui(this, zzug2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzcbp;
            zzuh zzuh2 = this;
            while (zzuh2.zzcbw == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzuh zzuh3 = zzuh2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzafy.zzcq((String)"Timed out waiting for adapter.");
                    zzuh3.zzcbw = 3;
                    continue;
                }
                try {
                    zzuh3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzuh3.zzcbw = 5;
                }
            }
            long l14 = zzbv.zzeg().elapsedRealtime() - l3;
            return new zzuk(this.zzcbr, this.zzcbv, this.zzcbo, zzug2, this.zzcbw, this.zzlp(), l14);
        }
    }

    private final zzvc zzlp() {
        if (this.zzcbw != 0 || !this.zzlr()) {
            return null;
        }
        try {
            if (this.zzu(4) && this.zzcbx != null && this.zzcbx.zzlt() != 0) {
                return this.zzcbx;
            }
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzls();
        return new zzuj(n);
    }

    private final zzuw zzlq() {
        String string = String.valueOf(this.zzcbo);
        zzafy.zzcq((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzauq && !this.zzcbr.zzln()) {
            zzmd<Boolean> zzmd2 = zzmn.zzblf;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbo)) {
                return zzuh.zza((MediationAdapter)new AdMobAdapter());
            }
            zzmd2 = zzmn.zzblg;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzcbo)) {
                return zzuh.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzcbo)) {
                return new zzvn((MediationAdapter)new zzwh());
            }
        }
        try {
            return this.zzamq.zzbg(this.zzcbo);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzcbo);
            zzafy.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzug zzug2) {
        String string = this.zzbe(this.zzcbr.zzcal);
        try {
            if (this.zzaos.zzdey < 4100000) {
                if (this.zzarf.zzbcx) {
                    this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzaqz, string, (zzuz)zzug2);
                    return;
                }
                this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzarf, this.zzaqz, string, (zzuz)zzug2);
                return;
            }
            if (this.zzauq || this.zzcbr.zzln()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzaop);
                if (this.zzcbs != null) {
                    for (String string2 : this.zzcbs) {
                        String string3 = ":false";
                        if (this.zzcbt != null && this.zzcbt.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzaqz, string, this.zzcbr.zzcac, (zzuz)zzug2, this.zzaoo, arrayList);
                return;
            }
            if (this.zzarf.zzbcx) {
                this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzaqz, string, this.zzcbr.zzcac, (zzuz)zzug2);
                return;
            }
            if (this.zzcbu) {
                if (this.zzcbr.zzcao != null) {
                    this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzaqz, string, this.zzcbr.zzcac, (zzuz)zzug2, new zzom(zzuh.zzbf(this.zzcbr.zzcas)), this.zzcbr.zzcar);
                    return;
                }
                this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzarf, this.zzaqz, string, this.zzcbr.zzcac, (zzuz)zzug2);
                return;
            }
            this.zzcbv.zza(zzn.zzw((Object)this.mContext), this.zzarf, this.zzaqz, string, this.zzcbr.zzcac, (zzuz)zzug2);
            return;
        }
        catch (RemoteException remoteException) {
            zzafy.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzt(5);
            return;
        }
    }

    private final boolean zzu(int n) {
        Bundle bundle;
        try {
            bundle = this.zzauq ? this.zzcbv.zzly() : (this.zzarf.zzbcx ? this.zzcbv.getInterstitialAdapterInfo() : this.zzcbv.zzlx());
        }
        catch (RemoteException remoteException) {
            zzafy.zzcr((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzlr() {
        return this.zzcbq.zzcbf != -1;
    }

    private final String zzbe(String string) {
        if (string == null || !this.zzlr() || this.zzu(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafy.zzcr((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzls() {
        JSONObject jSONObject;
        if (this.zzcbr.zzcal == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzcbr.zzcal);
        }
        catch (JSONException jSONException) {
            zzafy.zzcr((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbo)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzu(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbf(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzafy.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzuh zzuh2) {
        return zzuh2.mLock;
    }

    static /* synthetic */ int zzb(zzuh zzuh2) {
        return zzuh2.zzcbw;
    }

    static /* synthetic */ zzuw zza(zzuh zzuh2, zzuw zzuw2) {
        zzuh2.zzcbv = zzuw2;
        return zzuh2.zzcbv;
    }

    static /* synthetic */ zzuw zzc(zzuh zzuh2) {
        return zzuh2.zzlq();
    }

    static /* synthetic */ zzuw zzd(zzuh zzuh2) {
        return zzuh2.zzcbv;
    }

    static /* synthetic */ boolean zze(zzuh zzuh2) {
        return zzuh2.zzlr();
    }

    static /* synthetic */ boolean zza(zzuh zzuh2, int n) {
        return zzuh2.zzu(1);
    }

    static /* synthetic */ String zzf(zzuh zzuh2) {
        return zzuh2.zzcbo;
    }

    static /* synthetic */ void zza(zzuh zzuh2, zzug zzug2) {
        zzuh2.zza(zzug2);
    }
}

