/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzabu;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zznn;
import java.util.Locale;

public final class zzabv {
    private int zzcrt;
    private boolean zzcsa;
    private boolean zzcsb;
    private int zzcsf;
    private int zzcsj;
    private int zzcsk;
    private String zzcrw;
    private int zzcsg;
    private int zzcsh;
    private int zzcsi;
    private boolean zzcsn;
    private int zzcso;
    private double zzcsl;
    private boolean zzcsm;
    private String zzcsp;
    private String zzcsq;
    private boolean zzcru;
    private boolean zzcrv;
    private String zzcrx;
    private boolean zzcry;
    private boolean zzcrz;
    private String zzcsc;
    private String zzcsd;
    private float zzaxd;
    private int zzclx;
    private int zzcly;
    private String zzcse;
    private boolean zzcsr;

    public zzabv(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzm(context);
        this.zzn(context);
        this.zzo(context);
        Locale locale = Locale.getDefault();
        this.zzcru = zzabv.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcrv = zzabv.zza(packageManager, "http://www.google.com") != null;
        this.zzcrx = locale.getCountry();
        zzjk.zzhx();
        this.zzcry = zzais.zzqs();
        this.zzcrz = zzi.zzcr((Context)context);
        this.zzcsc = locale.getLanguage();
        this.zzcsd = zzabv.zzb(context, packageManager);
        this.zzcse = zzabv.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzaxd = displayMetrics.density;
        this.zzclx = displayMetrics.widthPixels;
        this.zzcly = displayMetrics.heightPixels;
    }

    public zzabv(Context context, zzabu zzabu2) {
        context.getPackageManager();
        this.zzm(context);
        this.zzn(context);
        this.zzo(context);
        Context context2 = context;
        zzabv zzabv2 = this;
        this.zzcsp = Build.FINGERPRINT;
        zzabv2.zzcsq = Build.DEVICE;
        zzabv2.zzcsr = zzq.zzalv() && zznn.zzi(context2);
        this.zzcru = zzabu2.zzcru;
        this.zzcrv = zzabu2.zzcrv;
        this.zzcrx = zzabu2.zzcrx;
        this.zzcry = zzabu2.zzcry;
        this.zzcrz = zzabu2.zzcrz;
        this.zzcsc = zzabu2.zzcsc;
        this.zzcsd = zzabu2.zzcsd;
        this.zzcse = zzabu2.zzcse;
        this.zzaxd = zzabu2.zzaxd;
        this.zzclx = zzabu2.zzclx;
        this.zzcly = zzabu2.zzcly;
    }

    private final void zzm(Context context) {
        zzbs.zzec();
        AudioManager audioManager = zzagr.zzao(context);
        if (audioManager != null) {
            try {
                this.zzcrt = audioManager.getMode();
                this.zzcsa = audioManager.isMusicActive();
                this.zzcsb = audioManager.isSpeakerphoneOn();
                this.zzcsf = audioManager.getStreamVolume(3);
                this.zzcsj = audioManager.getRingerMode();
                this.zzcsk = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbs.zzeg().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcrt = -2;
        this.zzcsa = false;
        this.zzcsb = false;
        this.zzcsf = 0;
        this.zzcsj = 0;
        this.zzcsk = 0;
    }

    @TargetApi(value=16)
    private final void zzn(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcrw = telephonyManager.getNetworkOperator();
        this.zzcsh = telephonyManager.getNetworkType();
        this.zzcsi = telephonyManager.getPhoneType();
        this.zzcsg = -2;
        this.zzcsn = false;
        this.zzcso = -1;
        zzbs.zzec();
        if (zzagr.zzd(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcsg = networkInfo.getType();
                this.zzcso = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcsg = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcsn = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzo(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcsl = (float)n2 / (float)n3;
            this.zzcsm = n == 2 || n == 5;
            return;
        }
        this.zzcsl = -1.0;
        this.zzcsm = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbgc.zzcy((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzabv.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbgc.zzcy((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbs.zzeg().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzabu zzns() {
        return new zzabu(this.zzcrt, this.zzcru, this.zzcrv, this.zzcrw, this.zzcrx, this.zzcry, this.zzcrz, this.zzcsa, this.zzcsb, this.zzcsc, this.zzcsd, this.zzcse, this.zzcsf, this.zzcsg, this.zzcsh, this.zzcsi, this.zzcsj, this.zzcsk, this.zzaxd, this.zzclx, this.zzcly, this.zzcsl, this.zzcsm, this.zzcsn, this.zzcso, this.zzcsp, this.zzcsr, this.zzcsq);
    }
}

