/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzzb;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzb
public final class zzakw
extends FrameLayout
implements zzakt {
    private final zzali zzdef;
    private final FrameLayout zzdeg;
    private final zznd zzdeh;
    private final zzalk zzdei;
    private final long zzdej;
    @Nullable
    private zzaku zzdek;
    private boolean zzdel;
    private boolean zzdem;
    private boolean zzden;
    private boolean zzdeo;
    private long zzdep;
    private long zzdeq;
    private String zzder;
    private Bitmap zzdes;
    private ImageView zzdet;
    private boolean zzdeu;

    public static void zza(zzali zzali2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzali2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzali zzali2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzali2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzali zzali2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzali2.zza("onVideoEvent", hashMap);
    }

    public zzakw(Context context, zzali zzali2, int n, boolean bl, zznd zznd2, zzalh zzalh2) {
        super(context);
        zzmg<Constable> zzmg2;
        this.zzdef = zzali2;
        this.zzdeh = zznd2;
        this.zzdeg = new FrameLayout(context);
        this.addView((View)this.zzdeg, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzu((Object)zzali2.zzbk());
        this.zzdek = zzali2.zzbk().zzanr.zza(context, zzali2, n, bl, zznd2, zzalh2);
        if (this.zzdek != null) {
            this.zzdeg.addView((View)this.zzdek, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzmg2 = zzmq.zzbgz;
            if (((Boolean)((Object)zzbs.zzep().zzd(zzmg2))).booleanValue()) {
                this.zzrn();
            }
        }
        this.zzdet = new ImageView(context);
        zzmg2 = zzmq.zzbhd;
        this.zzdej = zzbs.zzep().zzd(zzmg2);
        zzmg2 = zzmq.zzbhb;
        this.zzdeo = (Boolean)((Object)zzbs.zzep().zzd(zzmg2));
        if (this.zzdeh != null) {
            this.zzdeh.zzf("spinner_used", this.zzdeo ? "1" : "0");
        }
        this.zzdei = new zzalk(this);
        if (this.zzdek != null) {
            this.zzdek.zza(this);
        }
        if (this.zzdek == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzdeg.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzcp(String string2) {
        this.zzder = string2;
    }

    public final void zza(float f, float f2) {
        if (this.zzdek != null) {
            this.zzdek.zza(f, f2);
        }
    }

    public final void zzrk() {
        if (this.zzdek == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzder)) {
            this.zzdek.setVideoPath(this.zzder);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzdek == null) {
            return;
        }
        this.zzdek.pause();
    }

    public final void play() {
        if (this.zzdek == null) {
            return;
        }
        this.zzdek.play();
    }

    public final void seekTo(int n) {
        if (this.zzdek == null) {
            return;
        }
        this.zzdek.seekTo(n);
    }

    public final void zzrl() {
        if (this.zzdek == null) {
            return;
        }
        zzaku zzaku2 = this.zzdek;
        zzaku2.zzdee.setMuted(true);
        zzaku2.zzrd();
    }

    public final void zzrm() {
        if (this.zzdek == null) {
            return;
        }
        zzaku zzaku2 = this.zzdek;
        zzaku2.zzdee.setMuted(false);
        zzaku2.zzrd();
    }

    public final void zzb(float f) {
        if (this.zzdek == null) {
            return;
        }
        float f2 = f;
        zzaku zzaku2 = this.zzdek;
        zzaku2.zzdee.zzb(f2);
        zzaku2.zzrd();
    }

    @TargetApi(value=14)
    public final void zzf(MotionEvent motionEvent) {
        if (this.zzdek == null) {
            return;
        }
        this.zzdek.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzrn() {
        if (this.zzdek == null) {
            return;
        }
        Context context = this.zzdek.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzdek.zzqz());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzdeg.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzdeg.bringChildToFront((View)textView);
    }

    @Override
    public final void zzre() {
        this.zzdei.resume();
        zzagr.zzczc.post((Runnable)new zzakx(this));
    }

    @Override
    public final void zzrf() {
        if (this.zzdek == null) {
            return;
        }
        if (this.zzdeq == 0L) {
            float f = (float)this.zzdek.getDuration() / 1000.0f;
            int n = this.zzdek.getVideoWidth();
            int n2 = this.zzdek.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzrg() {
        zzakw zzakw2 = this;
        if (zzakw2.zzdef.zzrz() != null && !zzakw2.zzdem) {
            WindowManager.LayoutParams layoutParams = zzakw2.zzdef.zzrz().getWindow().getAttributes();
            boolean bl = zzakw2.zzden = (layoutParams.flags & 0x80) != 0;
            if (!zzakw2.zzden) {
                zzakw2.zzdef.zzrz().getWindow().addFlags(128);
                zzakw2.zzdem = true;
            }
        }
        this.zzdel = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzrq();
        this.zzdel = false;
    }

    @Override
    public final void zzrh() {
        this.zza("ended", new String[0]);
        this.zzrq();
    }

    @Override
    public final void zzg(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzri() {
        zzakw zzakw2 = this;
        if (zzakw2.zzdeu && zzakw2.zzdes != null && !zzakw2.zzrp()) {
            zzakw2.zzdet.setImageBitmap(zzakw2.zzdes);
            zzakw2.zzdet.invalidate();
            zzakw2.zzdeg.addView((View)zzakw2.zzdet, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzakw2.zzdeg.bringChildToFront((View)zzakw2.zzdet);
        }
        this.zzdei.pause();
        this.zzdeq = this.zzdep;
        zzagr.zzczc.post((Runnable)new zzaky(this));
    }

    public final void destroy() {
        this.zzdei.pause();
        if (this.zzdek != null) {
            this.zzdek.stop();
        }
        this.zzrq();
    }

    final void zzro() {
        if (this.zzdek == null) {
            return;
        }
        long l = this.zzdek.getCurrentPosition();
        if (this.zzdep != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzdep = l;
        }
    }

    @Override
    public final void zzrj() {
        zzakw zzakw2;
        if (this.zzdel && (zzakw2 = this).zzrp()) {
            zzakw2.zzdeg.removeView((View)zzakw2.zzdet);
        }
        zzakw2 = this;
        if (zzakw2.zzdes != null) {
            long l = zzbs.zzei().elapsedRealtime();
            if (zzakw2.zzdek.getBitmap(zzakw2.zzdes) != null) {
                zzakw2.zzdeu = true;
            }
            long l2 = zzbs.zzei().elapsedRealtime() - l;
            if (zzafj.zzpt()) {
                zzafj.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzakw2.zzdej) {
                zzafj.zzco((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzakw2.zzdeo = false;
                zzakw2.zzdes = null;
                if (zzakw2.zzdeh != null) {
                    zzakw2.zzdeh.zzf("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzf(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzakw zzakw2 = this;
        if (zzakw2.zzdeo) {
            zzmg<Integer> zzmg2 = zzmq.zzbhc;
            n4 = Math.max(n4 / zzbs.zzep().zzd(zzmg2), 1);
            zzmg2 = zzmq.zzbhc;
            n3 = Math.max(n3 / zzbs.zzep().zzd(zzmg2), 1);
            if (zzakw2.zzdes == null || zzakw2.zzdes.getWidth() != n4 || zzakw2.zzdes.getHeight() != n3) {
                zzakw2.zzdes = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzakw2.zzdeu = false;
            }
        }
    }

    private final boolean zzrp() {
        return this.zzdet.getParent() != null;
    }

    private final void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzdef.zza("onVideoEvent", hashMap);
    }

    private final void zzrq() {
        if (this.zzdef.zzrz() == null) {
            return;
        }
        if (this.zzdem && !this.zzden) {
            this.zzdef.zzrz().getWindow().clearFlags(128);
            this.zzdem = false;
        }
    }

    static /* synthetic */ void zza(zzakw zzakw2, String string2, String[] stringArray) {
        zzakw2.zza(string2, stringArray);
    }
}

