/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzald;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzb;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzzb
@TargetApi(value=14)
public final class zzalg
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzalf {
    private static final float[] zzdfl = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzald zzdfm;
    private final float[] zzdfi;
    private final float[] zzdfn;
    private final float[] zzdfo;
    private final float[] zzdfp;
    private final float[] zzdfq;
    private final float[] zzdfr;
    private final float[] zzdfs;
    private float zzdft;
    private float zzdfu;
    private float zzdfv;
    private int zzakx;
    private int zzakw;
    private SurfaceTexture zzdfw;
    private SurfaceTexture zzdfx;
    private int zzdfy;
    private int zzdfz;
    private int zzdga;
    private FloatBuffer zzdgb = ByteBuffer.allocateDirect(zzdfl.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzdgc;
    private final Object zzdgd;
    private EGL10 zzdge;
    private EGLDisplay zzdgf;
    private EGLContext zzdgg;
    private EGLSurface zzdgh;
    private volatile boolean zzdgi;
    private volatile boolean zzdgj;

    public zzalg(Context context) {
        super("SphericalVideoProcessor");
        this.zzdgb.put(zzdfl).position(0);
        this.zzdfi = new float[9];
        this.zzdfn = new float[9];
        this.zzdfo = new float[9];
        this.zzdfp = new float[9];
        this.zzdfq = new float[9];
        this.zzdfr = new float[9];
        this.zzdfs = new float[9];
        this.zzdft = Float.NaN;
        this.zzdfm = new zzald(context);
        this.zzdfm.zza(this);
        this.zzdgc = new CountDownLatch(1);
        this.zzdgd = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzakw = n;
        this.zzakx = n2;
        this.zzdfx = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(int n, int n2) {
        Object object = this.zzdgd;
        synchronized (object) {
            this.zzakw = n;
            this.zzakx = n2;
            this.zzdgi = true;
            this.zzdgd.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzrs() {
        Object object = this.zzdgd;
        synchronized (object) {
            this.zzdgj = true;
            this.zzdfx = null;
            this.zzdgd.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzrt() {
        if (this.zzdfx == null) {
            return null;
        }
        try {
            this.zzdgc.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzdfw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzdga;
        Object object = this.zzdgd;
        synchronized (object) {
            this.zzdgd.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzms() {
        Object object = this.zzdgd;
        synchronized (object) {
            this.zzdgd.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzmg<String> zzmg2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzdfx == null) {
            zzafj.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzdgc.countDown();
            return;
        }
        zzalg zzalg2 = this;
        this.zzdge = (EGL10)EGLContext.getEGL();
        zzalg2.zzdgf = zzalg2.zzdge.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzalg2.zzdgf == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzalg2.zzdge.eglInitialize(zzalg2.zzdgf, nArray)) {
                bl2 = false;
            } else {
                object2 = zzalg2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzalg)object2).zzdge.eglChooseConfig(((zzalg)object2).zzdgf, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzalg2.zzdgg = zzalg2.zzdge.eglCreateContext(zzalg2.zzdgf, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzalg2.zzdgg == null || zzalg2.zzdgg == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzalg2.zzdgh = zzalg2.zzdge.eglCreateWindowSurface(zzalg2.zzdgf, (EGLConfig)object, (Object)zzalg2.zzdfx, null);
                        bl2 = zzalg2.zzdgh == null || zzalg2.zzdgh == EGL10.EGL_NO_SURFACE ? false : zzalg2.zzdge.eglMakeCurrent(zzalg2.zzdgf, zzalg2.zzdgh, zzalg2.zzdgh, zzalg2.zzdgg);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzalg2 = this;
        zzmg<String> zzmg3 = zzmg2 = zzmq.zzbkv;
        if (!zzbs.zzep().zzd(zzmg3).equals(zzmg2.zzip())) {
            zzmg3 = zzmg2;
            string2 = zzbs.zzep().zzd(zzmg3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzalg.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzmg3 = zzmg2 = zzmq.zzbkw;
            if (!zzbs.zzep().zzd(zzmg3).equals(zzmg2.zzip())) {
                zzmg3 = zzmg2;
                string3 = zzbs.zzep().zzd(zzmg3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzalg.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzalg.zzcq("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzalg.zzcq("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzalg.zzcq("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzalg.zzcq("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzalg.zzcq("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzalg.zzcq("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzalg.zzcq("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzdfy = n;
        GLES20.glUseProgram((int)zzalg2.zzdfy);
        zzalg.zzcq("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzalg2.zzdfy, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzalg2.zzdgb);
        zzalg.zzcq("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzalg.zzcq("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzalg.zzcq("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzalg.zzcq("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzalg.zzcq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzalg.zzcq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzalg.zzcq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzalg.zzcq("texParameteri");
        zzalg2.zzdfz = GLES20.glGetUniformLocation((int)zzalg2.zzdfy, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzalg2.zzdfz, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzdfy != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzdge.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzafj.e((String)string6);
            zzbs.zzeg().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzrv();
            this.zzdgc.countDown();
            return;
        }
        this.zzdfw = new SurfaceTexture(n7);
        this.zzdfw.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzdgc.countDown();
        this.zzdfm.start();
        try {
            this.zzdgi = true;
            while (!this.zzdgj) {
                this.zzru();
                if (this.zzdgi) {
                    zzalg2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzalg2.zzakw, (int)zzalg2.zzakx);
                    zzalg.zzcq("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzalg2.zzdfy, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzalg2.zzdfy, (String)"uFOVy");
                    if (zzalg2.zzakw > zzalg2.zzakx) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzalg2.zzakx / (float)zzalg2.zzakw));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzalg2.zzakw / (float)zzalg2.zzakx));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzdgi = false;
                }
                try {
                    Object object3 = this.zzdgd;
                    synchronized (object3) {
                        if (!this.zzdgj && !this.zzdgi && this.zzdga == 0) {
                            this.zzdgd.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzafj.zzco((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzafj.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbs.zzeg().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzdfm.stop();
            this.zzdfw.setOnFrameAvailableListener(null);
            this.zzdfw = null;
            this.zzrv();
        }
    }

    private final void zzru() {
        while (this.zzdga > 0) {
            this.zzdfw.updateTexImage();
            --this.zzdga;
        }
        if (this.zzdfm.zza(this.zzdfi)) {
            if (Float.isNaN(this.zzdft)) {
                float[] fArray = this.zzdfi;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzdfi;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzdft = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzalg.zzb(this.zzdfr, this.zzdft + this.zzdfu);
        } else {
            zzalg.zza(this.zzdfi, -1.5707964f);
            zzalg.zzb(this.zzdfr, this.zzdfu);
        }
        zzalg.zza(this.zzdfn, 1.5707964f);
        zzalg.zza(this.zzdfo, this.zzdfr, this.zzdfn);
        zzalg.zza(this.zzdfp, this.zzdfi, this.zzdfo);
        zzalg.zza(this.zzdfq, this.zzdfv);
        zzalg.zza(this.zzdfs, this.zzdfq, this.zzdfp);
        GLES20.glUniformMatrix3fv((int)this.zzdfz, (int)1, (boolean)false, (float[])this.zzdfs, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzalg.zzcq("drawArrays");
        GLES20.glFinish();
        this.zzdge.eglSwapBuffers(this.zzdgf, this.zzdgh);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzakw > this.zzakx) {
            f4 = 1.7453293f * f / (float)this.zzakw;
            f3 = 1.7453293f * f2 / (float)this.zzakw;
        } else {
            f4 = 1.7453293f * f / (float)this.zzakx;
            f3 = 1.7453293f * f2 / (float)this.zzakx;
        }
        this.zzdfu -= f4;
        this.zzdfv -= f3;
        if (this.zzdfv < -1.5707964f) {
            this.zzdfv = -1.5707964f;
        }
        if (this.zzdfv > 1.5707964f) {
            this.zzdfv = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzalg.zzcq("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzalg.zzcq("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzalg.zzcq("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzalg.zzcq("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzalg.zzcq("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zzrv() {
        boolean bl = false;
        if (this.zzdgh != null && this.zzdgh != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzdge.eglMakeCurrent(this.zzdgf, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzdge.eglDestroySurface(this.zzdgf, this.zzdgh);
            this.zzdgh = null;
        }
        if (this.zzdgg != null) {
            bl |= this.zzdge.eglDestroyContext(this.zzdgf, this.zzdgg);
            this.zzdgg = null;
        }
        if (this.zzdgf != null) {
            bl |= this.zzdge.eglTerminate(this.zzdgf);
            this.zzdgf = null;
        }
        return bl;
    }

    private static void zzcq(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

