/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzzv;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzv
public class zzalf<T>
implements zzakv<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdfl;
    private boolean zzdfm;
    private boolean zzcfb;
    private final zzakw zzdfn = new zzakw();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdfn.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcfb) {
                return;
            }
            if (this.zzrg()) {
                zzbs.zzem().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdfm = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdfn.zzre();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcfb) {
                return;
            }
            if (this.zzrg()) {
                zzbs.zzem().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdfl = throwable;
            this.mLock.notifyAll();
            this.zzdfn.zzre();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrg()) {
                this.mLock.wait();
            }
            if (this.zzdfl != null) {
                throw new ExecutionException(this.zzdfl);
            }
            if (this.zzcfb) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrg()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdfl != null) {
                throw new ExecutionException(this.zzdfl);
            }
            if (!this.zzdfm) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzcfb) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrg()) {
                return false;
            }
            this.zzcfb = true;
            this.zzdfm = true;
            this.mLock.notifyAll();
            this.zzdfn.zzre();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcfb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrg();
        }
    }

    private final boolean zzrg() {
        return this.zzdfl != null || this.zzdfm;
    }
}

