/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzals;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalx;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamn;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzamq;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzv
@TargetApi(value=14)
public final class zzalr
extends zzamb
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzdfu = new HashMap<Integer, String>();
    private final zzamq zzdfv;
    private final boolean zzdfw;
    private int zzdfx = 0;
    private int zzdfy = 0;
    private MediaPlayer zzdfz;
    private Uri zzdga;
    private int zzdgb;
    private int zzdgc;
    private int zzdgd;
    private int zzdge;
    private int zzdgf;
    private zzamn zzdgg;
    private boolean zzdgh;
    private int zzdgi;
    private zzama zzdgj;

    public zzalr(Context context, boolean bl, boolean bl2, zzamo zzamo2, zzamq zzamq2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzdfv = zzamq2;
        this.zzdgh = bl;
        this.zzdfw = bl2;
        this.zzdfv.zza(this);
    }

    @Override
    public final String zzri() {
        String string2 = String.valueOf(this.zzdgh ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzama zzama2) {
        this.zzdgj = zzama2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzalr zzalr2 = this;
        zzil zzil2 = zzil.zzd(uri);
        zzalr2.zzdga = zzil2 == null ? uri : Uri.parse((String)zzil2.url);
        zzalr2.zzdgi = 0;
        zzalr2.zzrj();
        zzalr2.requestLayout();
        zzalr2.invalidate();
    }

    @Override
    public final void stop() {
        zzagf.v("AdMediaPlayerView stop");
        if (this.zzdfz != null) {
            this.zzdfz.stop();
            this.zzdfz.release();
            this.zzdfz = null;
            this.zzaf(0);
            this.zzdfy = 0;
        }
        this.zzdfv.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzagf.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzdgb = mediaPlayer.getVideoWidth();
        this.zzdgc = mediaPlayer.getVideoHeight();
        if (this.zzdgb != 0 && this.zzdgc != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzagf.v("AdMediaPlayerView prepared");
        this.zzaf(2);
        this.zzdfv.zzro();
        zzahn.zzdaw.post((Runnable)new zzals(this));
        this.zzdgb = mediaPlayer.getVideoWidth();
        this.zzdgc = mediaPlayer.getVideoHeight();
        if (this.zzdgi != 0) {
            ((zzamb)this).seekTo(this.zzdgi);
        }
        this.zzrk();
        int n = this.zzdgb;
        int n2 = this.zzdgc;
        zzagf.zzct((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzdfy == 3) {
            ((zzamb)this).play();
        }
        ((zzamb)this).zzrm();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzagf.v("AdMediaPlayerView completion");
        this.zzaf(5);
        this.zzdfy = 5;
        zzahn.zzdaw.post((Runnable)new zzalt(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdfu.get(n);
        String string3 = zzdfu.get(n2);
        zzagf.v(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdfu.get(n);
        String string3 = zzdfu.get(n2);
        zzagf.zzcu((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzaf(-1);
        this.zzdfy = -1;
        zzahn.zzdaw.post((Runnable)new zzalu(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzdgd = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzagf.v("AdMediaPlayerView surface created");
        this.zzrj();
        zzahn.zzdaw.post((Runnable)new zzalv(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzagf.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzdfy == 3;
        boolean bl3 = bl = this.zzdgb == n && this.zzdgc == n2;
        if (this.zzdfz != null && bl2 && bl) {
            if (this.zzdgi != 0) {
                ((zzamb)this).seekTo(this.zzdgi);
            }
            ((zzamb)this).play();
        }
        if (this.zzdgg != null) {
            this.zzdgg.zzh(n, n2);
        }
        zzahn.zzdaw.post((Runnable)new zzalw(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzagf.v("AdMediaPlayerView surface destroyed");
        if (this.zzdfz != null && this.zzdgi == 0) {
            this.zzdgi = this.zzdfz.getCurrentPosition();
        }
        if (this.zzdgg != null) {
            this.zzdgg.zzsb();
        }
        zzahn.zzdaw.post((Runnable)new zzalx(this));
        this.zzab(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzdfv.zzb(this);
        this.zzdgp.zza(surfaceTexture, this.zzdgj);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzalr.getDefaultSize((int)this.zzdgb, (int)n);
        int n4 = zzalr.getDefaultSize((int)this.zzdgc, (int)n2);
        if (this.zzdgb > 0 && this.zzdgc > 0 && this.zzdgg == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzdgb * n4 < n3 * this.zzdgc) {
                    n3 = n4 * this.zzdgb / this.zzdgc;
                } else if (this.zzdgb * n4 > n3 * this.zzdgc) {
                    n4 = n3 * this.zzdgc / this.zzdgb;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzdgc / this.zzdgb;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzdgb / this.zzdgc;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzdgb;
                n4 = this.zzdgc;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzdgb / this.zzdgc;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzdgc / this.zzdgb;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzdgg != null) {
            this.zzdgg.zzh(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdge > 0 && this.zzdge != n3 || this.zzdgf > 0 && this.zzdgf != n4) {
                this.zzrk();
            }
            this.zzdge = n3;
            this.zzdgf = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzrj() {
        zzagf.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzdga == null || surfaceTexture == null) {
            return;
        }
        this.zzab(false);
        try {
            Surface surface;
            zzbs.zzex();
            this.zzdfz = new MediaPlayer();
            this.zzdfz.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzdfz.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzdfz.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzdfz.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzdfz.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzdfz.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzdgd = 0;
            if (this.zzdgh) {
                this.zzdgg = new zzamn(this.getContext());
                this.zzdgg.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzdgg.start();
                surface = this.zzdgg.zzsc();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzdgg.zzsb();
                    this.zzdgg = null;
                }
            }
            this.zzdfz.setDataSource(this.getContext(), this.zzdga);
            zzbs.zzey();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzdfz.setSurface(surface);
            this.zzdfz.setAudioStreamType(3);
            this.zzdfz.setScreenOnWhilePlaying(true);
            this.zzdfz.prepareAsync();
            this.zzaf(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzdga);
            zzagf.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzdfz, 1, 0);
            return;
        }
    }

    private final void zzrk() {
        if (!this.zzdfw) {
            return;
        }
        if (this.zzrl() && this.zzdfz.getCurrentPosition() > 0 && this.zzdfy != 3) {
            zzagf.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzdfz.start();
            int n = this.zzdfz.getCurrentPosition();
            long l = zzbs.zzeo().currentTimeMillis();
            while (this.zzrl() && this.zzdfz.getCurrentPosition() == n && zzbs.zzeo().currentTimeMillis() - l <= 250L) {
            }
            this.zzdfz.pause();
            ((zzamb)this).zzrm();
        }
    }

    private final void zzab(boolean bl) {
        zzagf.v("AdMediaPlayerView release");
        if (this.zzdgg != null) {
            this.zzdgg.zzsb();
            this.zzdgg = null;
        }
        if (this.zzdfz != null) {
            this.zzdfz.reset();
            this.zzdfz.release();
            this.zzdfz = null;
            this.zzaf(0);
            if (bl) {
                this.zzdfy = 0;
                this.zzdfy = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzagf.v("AdMediaPlayerView play");
        if (this.zzrl()) {
            this.zzdfz.start();
            this.zzaf(3);
            this.zzdgp.zzrp();
            zzahn.zzdaw.post((Runnable)new zzaly(this));
        }
        this.zzdfy = 3;
    }

    @Override
    public final void pause() {
        zzagf.v("AdMediaPlayerView pause");
        if (this.zzrl() && this.zzdfz.isPlaying()) {
            this.zzdfz.pause();
            this.zzaf(4);
            zzahn.zzdaw.post((Runnable)new zzalz(this));
        }
        this.zzdfy = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzrl()) {
            return this.zzdfz.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzrl()) {
            return this.zzdfz.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzagf.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzrl()) {
            this.zzdfz.seekTo(n);
            this.zzdgi = 0;
            return;
        }
        this.zzdgi = n;
    }

    private final boolean zzrl() {
        return this.zzdfz != null && this.zzdfx != -1 && this.zzdfx != 0 && this.zzdfx != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzdgg != null) {
            this.zzdgg.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzdfz != null) {
            return this.zzdfz.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzdfz != null) {
            return this.zzdfz.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzrm() {
        this.zza(this.zzdgq.getVolume());
    }

    private final void zza(float f) {
        if (this.zzdfz != null) {
            try {
                this.zzdfz.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzagf.zzcu((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzaf(int n) {
        if (n == 3) {
            this.zzdfv.zzsn();
            this.zzdgq.zzsn();
        } else if (this.zzdfx == 3) {
            this.zzdfv.zzso();
            this.zzdgq.zzso();
        }
        this.zzdfx = n;
    }

    static /* synthetic */ zzama zza(zzalr zzalr2) {
        return zzalr2.zzdgj;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzdfu.put(-1004, "MEDIA_ERROR_IO");
            zzdfu.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzdfu.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzdfu.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzdfu.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzdfu.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzdfu.put(1, "MEDIA_ERROR_UNKNOWN");
        zzdfu.put(1, "MEDIA_INFO_UNKNOWN");
        zzdfu.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzdfu.put(701, "MEDIA_INFO_BUFFERING_START");
        zzdfu.put(702, "MEDIA_INFO_BUFFERING_END");
        zzdfu.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzdfu.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzdfu.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzdfu.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzdfu.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

