/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzzv;

@zzzv
final class zzamk
implements SensorEventListener {
    private final SensorManager zzdhq;
    private final Object zzdhr;
    private final Display zzdhs;
    private final float[] zzdht;
    private final float[] zzdhu;
    private float[] zzdhv;
    private Handler zzdhw;
    private zzamm zzdhx;

    zzamk(Context context) {
        this.zzdhq = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzdhs = windowManager.getDefaultDisplay();
        this.zzdht = new float[9];
        this.zzdhu = new float[9];
        this.zzdhr = new Object();
    }

    final void start() {
        if (this.zzdhw != null) {
            return;
        }
        Sensor sensor = this.zzdhq.getDefaultSensor(11);
        if (sensor == null) {
            zzagf.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzdhw = new Handler(handlerThread.getLooper());
        if (!this.zzdhq.registerListener((SensorEventListener)this, sensor, 0, this.zzdhw)) {
            zzagf.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzdhw == null) {
            return;
        }
        this.zzdhq.unregisterListener((SensorEventListener)this);
        this.zzdhw.post((Runnable)new zzaml(this));
        this.zzdhw = null;
    }

    final void zza(zzamm zzamm2) {
        this.zzdhx = zzamm2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzamk zzamk2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzamk2.zzdhr;
            synchronized (object) {
                if (zzamk2.zzdhv == null) {
                    zzamk2.zzdhv = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzamk2.zzdht, (float[])fArray);
            switch (zzamk2.zzdhs.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzamk2.zzdht, (int)2, (int)129, (float[])zzamk2.zzdhu);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzamk2.zzdht, (int)129, (int)130, (float[])zzamk2.zzdhu);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzamk2.zzdht, (int)130, (int)1, (float[])zzamk2.zzdhu);
                    break;
                }
                default: {
                    System.arraycopy(zzamk2.zzdht, 0, zzamk2.zzdhu, 0, 9);
                }
            }
            zzamk2.zzg(1, 3);
            zzamk2.zzg(2, 6);
            zzamk2.zzg(5, 7);
            Object object2 = zzamk2.zzdhr;
            synchronized (object2) {
                System.arraycopy(zzamk2.zzdhu, 0, zzamk2.zzdhv, 0, 9);
            }
            if (zzamk2.zzdhx != null) {
                zzamk2.zzdhx.zzmy();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzdhr;
        synchronized (object) {
            if (this.zzdhv == null) {
                return false;
            }
            System.arraycopy(this.zzdhv, 0, fArray, 0, this.zzdhv.length);
            return true;
        }
    }

    private final void zzg(int n, int n2) {
        float f = this.zzdhu[n];
        this.zzdhu[n] = this.zzdhu[n2];
        this.zzdhu[n2] = f;
    }
}

