/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzamk;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzv;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzzv
@TargetApi(value=14)
public final class zzamn
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzamm {
    private static final float[] zzdhy = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzamk zzdhz;
    private final float[] zzdhv;
    private final float[] zzdia;
    private final float[] zzdib;
    private final float[] zzdic;
    private final float[] zzdid;
    private final float[] zzdie;
    private final float[] zzdif;
    private float zzdig;
    private float zzdih;
    private float zzdii;
    private int zzalw;
    private int zzalv;
    private SurfaceTexture zzdij;
    private SurfaceTexture zzdik;
    private int zzdil;
    private int zzdim;
    private int zzdin;
    private FloatBuffer zzdio = ByteBuffer.allocateDirect(zzdhy.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzdip;
    private final Object zzdiq;
    private EGL10 zzdir;
    private EGLDisplay zzdis;
    private EGLContext zzdit;
    private EGLSurface zzdiu;
    private volatile boolean zzdiv;
    private volatile boolean zzdiw;

    public zzamn(Context context) {
        super("SphericalVideoProcessor");
        this.zzdio.put(zzdhy).position(0);
        this.zzdhv = new float[9];
        this.zzdia = new float[9];
        this.zzdib = new float[9];
        this.zzdic = new float[9];
        this.zzdid = new float[9];
        this.zzdie = new float[9];
        this.zzdif = new float[9];
        this.zzdig = Float.NaN;
        this.zzdhz = new zzamk(context);
        this.zzdhz.zza(this);
        this.zzdip = new CountDownLatch(1);
        this.zzdiq = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzalv = n;
        this.zzalw = n2;
        this.zzdik = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(int n, int n2) {
        Object object = this.zzdiq;
        synchronized (object) {
            this.zzalv = n;
            this.zzalw = n2;
            this.zzdiv = true;
            this.zzdiq.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzsb() {
        Object object = this.zzdiq;
        synchronized (object) {
            this.zzdiw = true;
            this.zzdik = null;
            this.zzdiq.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzsc() {
        if (this.zzdik == null) {
            return null;
        }
        try {
            this.zzdip.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzdij;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzdin;
        Object object = this.zzdiq;
        synchronized (object) {
            this.zzdiq.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzmy() {
        Object object = this.zzdiq;
        synchronized (object) {
            this.zzdiq.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzmx zzmx2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzdik == null) {
            zzagf.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzdip.countDown();
            return;
        }
        zzamn zzamn2 = this;
        this.zzdir = (EGL10)EGLContext.getEGL();
        zzamn2.zzdis = zzamn2.zzdir.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzamn2.zzdis == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzamn2.zzdir.eglInitialize(zzamn2.zzdis, nArray)) {
                bl2 = false;
            } else {
                object2 = zzamn2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzamn)object2).zzdir.eglChooseConfig(((zzamn)object2).zzdis, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzamn2.zzdit = zzamn2.zzdir.eglCreateContext(zzamn2.zzdis, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzamn2.zzdit == null || zzamn2.zzdit == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzamn2.zzdiu = zzamn2.zzdir.eglCreateWindowSurface(zzamn2.zzdis, (EGLConfig)object, (Object)zzamn2.zzdik, null);
                        bl2 = zzamn2.zzdiu == null || zzamn2.zzdiu == EGL10.EGL_NO_SURFACE ? false : zzamn2.zzdir.eglMakeCurrent(zzamn2.zzdis, zzamn2.zzdiu, zzamn2.zzdiu, zzamn2.zzdit);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzamn2 = this;
        zzmx zzmx3 = zzmx2 = zznh.zzbml;
        if (!((String)zzkb.zzif().zzd(zzmx3)).equals(zzmx2.zziv())) {
            zzmx3 = zzmx2;
            string2 = (String)zzkb.zzif().zzd(zzmx3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzamn.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzmx3 = zzmx2 = zznh.zzbmm;
            if (!((String)zzkb.zzif().zzd(zzmx3)).equals(zzmx2.zziv())) {
                zzmx3 = zzmx2;
                string3 = (String)zzkb.zzif().zzd(zzmx3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzamn.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzamn.zzcw("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzamn.zzcw("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzamn.zzcw("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzamn.zzcw("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzamn.zzcw("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzamn.zzcw("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzamn.zzcw("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzdil = n;
        GLES20.glUseProgram((int)zzamn2.zzdil);
        zzamn.zzcw("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzamn2.zzdil, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzamn2.zzdio);
        zzamn.zzcw("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzamn.zzcw("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzamn.zzcw("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzamn.zzcw("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzamn.zzcw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzamn.zzcw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzamn.zzcw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzamn.zzcw("texParameteri");
        zzamn2.zzdim = GLES20.glGetUniformLocation((int)zzamn2.zzdil, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzamn2.zzdim, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzdil != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzdir.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzagf.e((String)string6);
            zzbs.zzem().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzse();
            this.zzdip.countDown();
            return;
        }
        this.zzdij = new SurfaceTexture(n7);
        this.zzdij.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzdip.countDown();
        this.zzdhz.start();
        try {
            this.zzdiv = true;
            while (!this.zzdiw) {
                this.zzsd();
                if (this.zzdiv) {
                    zzamn2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzamn2.zzalv, (int)zzamn2.zzalw);
                    zzamn.zzcw("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzamn2.zzdil, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzamn2.zzdil, (String)"uFOVy");
                    if (zzamn2.zzalv > zzamn2.zzalw) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzamn2.zzalw / (float)zzamn2.zzalv));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzamn2.zzalv / (float)zzamn2.zzalw));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzdiv = false;
                }
                try {
                    Object object3 = this.zzdiq;
                    synchronized (object3) {
                        if (!this.zzdiw && !this.zzdiv && this.zzdin == 0) {
                            this.zzdiq.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzagf.zzcu((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzagf.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbs.zzem().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzdhz.stop();
            this.zzdij.setOnFrameAvailableListener(null);
            this.zzdij = null;
            this.zzse();
        }
    }

    private final void zzsd() {
        while (this.zzdin > 0) {
            this.zzdij.updateTexImage();
            --this.zzdin;
        }
        if (this.zzdhz.zza(this.zzdhv)) {
            if (Float.isNaN(this.zzdig)) {
                float[] fArray = this.zzdhv;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzdhv;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzdig = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzamn.zzb(this.zzdie, this.zzdig + this.zzdih);
        } else {
            zzamn.zza(this.zzdhv, -1.5707964f);
            zzamn.zzb(this.zzdie, this.zzdih);
        }
        zzamn.zza(this.zzdia, 1.5707964f);
        zzamn.zza(this.zzdib, this.zzdie, this.zzdia);
        zzamn.zza(this.zzdic, this.zzdhv, this.zzdib);
        zzamn.zza(this.zzdid, this.zzdii);
        zzamn.zza(this.zzdif, this.zzdid, this.zzdic);
        GLES20.glUniformMatrix3fv((int)this.zzdim, (int)1, (boolean)false, (float[])this.zzdif, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzamn.zzcw("drawArrays");
        GLES20.glFinish();
        this.zzdir.eglSwapBuffers(this.zzdis, this.zzdiu);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzalv > this.zzalw) {
            f4 = 1.7453293f * f / (float)this.zzalv;
            f3 = 1.7453293f * f2 / (float)this.zzalv;
        } else {
            f4 = 1.7453293f * f / (float)this.zzalw;
            f3 = 1.7453293f * f2 / (float)this.zzalw;
        }
        this.zzdih -= f4;
        this.zzdii -= f3;
        if (this.zzdii < -1.5707964f) {
            this.zzdii = -1.5707964f;
        }
        if (this.zzdii > 1.5707964f) {
            this.zzdii = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzamn.zzcw("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzamn.zzcw("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzamn.zzcw("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzamn.zzcw("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzamn.zzcw("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zzse() {
        boolean bl = false;
        if (this.zzdiu != null && this.zzdiu != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzdir.eglMakeCurrent(this.zzdis, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzdir.eglDestroySurface(this.zzdis, this.zzdiu);
            this.zzdiu = null;
        }
        if (this.zzdit != null) {
            bl |= this.zzdir.eglDestroyContext(this.zzdis, this.zzdit);
            this.zzdit = null;
        }
        if (this.zzdis != null) {
            bl |= this.zzdir.eglTerminate(this.zzdis);
            this.zzdis = null;
        }
        return bl;
    }

    private static void zzcw(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

