/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbl;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzana;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaoz;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzzv;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
final class zzanx
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzanh {
    private final zzaoz zzdly;
    private final Object mLock = new Object();
    @Nullable
    private final zzcv zzbuv;
    private final zzakd zzapr;
    private final zzbl zzdlz;
    private final zzv zzanr;
    private zzani zzdma;
    private zzd zzdmb;
    private zzapa zzdmc;
    private String zzalx;
    private boolean zzdmd;
    private boolean zzdme;
    private boolean zzdmf;
    private boolean zzdmg;
    private Boolean zzcza;
    private int zzdmh;
    private boolean zzdmi = true;
    private boolean zzdmj = false;
    private String zzcrt = "";
    private zzaoa zzdmk;
    private boolean zzdml;
    private boolean zzdmm;
    private zzoq zzdmn;
    private int zzdmo;
    private int zzdmp;
    private zzns zzdmq;
    private zzns zzdje;
    private zzns zzdmr;
    private zznt zzdms;
    private WeakReference<View.OnClickListener> zzdmt;
    private zzd zzdmu;
    private boolean zzdmv;
    private zzajq zzavi;
    private int zzchm = -1;
    private int zzchl = -1;
    private int zzcho = -1;
    private int zzchp = -1;
    private Map<String, zzana> zzdmw;
    private final WindowManager zzavx;
    private final zzis zzcmo;

    static zzanx zzb(Context context, zzapa zzapa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzakd zzakd2, zznu zznu2, zzbl zzbl2, zzv zzv2, zzis zzis2) {
        zzaoz zzaoz2 = new zzaoz(context);
        return new zzanx(zzaoz2, zzapa2, string2, bl, bl2, zzcv2, zzakd2, zznu2, zzbl2, zzv2, zzis2);
    }

    private zzanx(zzaoz zzaoz2, zzapa zzapa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzakd zzakd2, zznu zznu2, zzbl zzbl2, zzv zzv2, zzis zzis2) {
        super((Context)zzaoz2);
        this.zzdly = zzaoz2;
        this.zzdmc = zzapa2;
        this.zzalx = string2;
        this.zzdmf = bl;
        this.zzdmh = -1;
        this.zzbuv = zzcv2;
        this.zzapr = zzakd2;
        this.zzdlz = zzbl2;
        this.zzanr = zzv2;
        this.zzavx = (WindowManager)this.getContext().getSystemService("window");
        this.zzcmo = zzis2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzagf.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string3 = zzakd2.zzcv;
        Object object = zzaoz2;
        Object object2 = zzbs.zzei();
        webSettings2.setUserAgentString(((zzahn)object2).zzp((Context)object, string3));
        zzbs.zzek().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzub();
        if (zzq.zzamj()) {
            object2 = this;
            this.addJavascriptInterface(new zzaod<Object>(object2, (zzaof)((Object)new zzaoe((zzanh)object2))), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzavi = new zzajq(this.zzdly.zzsi(), (View)this, this, null);
        object = zznu2;
        object2 = this;
        ((zzanx)object2).zzue();
        ((zzanx)object2).zzdms = new zznt(new zznu(true, "make_wv", ((zzanx)object2).zzalx));
        ((zzanx)object2).zzdms.zzje().zzc((zznu)object);
        ((zzanx)object2).zzdje = zznn.zzb(((zzanx)object2).zzdms.zzje());
        ((zzanx)object2).zzdms.zza("native:view_create", ((zzanx)object2).zzdje);
        ((zzanx)object2).zzdmr = null;
        ((zzanx)object2).zzdmq = null;
        zzbs.zzek().zzax((Context)zzaoz2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzani) {
            this.zzdma = (zzani)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final zzv zzbq() {
        return this.zzanr;
    }

    private final boolean zztz() {
        int n;
        int n2;
        if (!this.zzdma.zzfv() && !this.zzdma.zztn()) {
            return false;
        }
        zzbs.zzei();
        DisplayMetrics displayMetrics = zzahn.zza(this.zzavx);
        zzkb.zzia();
        int n3 = zzajr.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzkb.zzia();
        int n4 = zzajr.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzdly.zzsi();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbs.zzei();
            int[] nArray = zzahn.zzf(activity);
            zzkb.zzia();
            n2 = zzajr.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzkb.zzia();
            n = zzajr.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzchl == n3 && this.zzchm == n4 && this.zzcho == n2 && this.zzchp == n) {
            return false;
        }
        boolean bl = this.zzchl != n3 || this.zzchm != n4;
        this.zzchl = n3;
        this.zzchm = n4;
        this.zzcho = n2;
        this.zzchp = n;
        new zzxb(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzavx.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbs.zzei().zzq(map);
        }
        catch (JSONException jSONException) {
            zzagf.zzcu((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzdc(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                    zzbs.zzem().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzagf.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcz(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
                zzbs.zzem().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzagf.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzdd(String string2) {
        if (zzq.zzaml()) {
            Object object;
            zzanx zzanx2;
            if (this.zzpg() == null) {
                zzanx2 = this;
                object = zzanx2.mLock;
                synchronized (object) {
                    zzanx2.zzcza = zzbs.zzem().zzpg();
                    if (zzanx2.zzcza == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzanx2.evaluateJavascript(string3, null);
                            zzanx2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzanx2.zza(false);
                        }
                    }
                }
            }
            if (this.zzpg().booleanValue()) {
                object = string2;
                zzanx2 = this;
                Object object2 = zzanx2.mLock;
                synchronized (object2) {
                    if (!zzanx2.isDestroyed()) {
                        zzanx2.evaluateJavascript((String)object, null);
                    } else {
                        zzagf.zzcu((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzdc(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzdc(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcza = bl;
        }
        zzbs.zzem().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzpg() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcza;
        }
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzanx zzanx2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzanx2.zzdd(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzagf.zzbx((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzdd(stringBuilder.toString());
    }

    @Override
    public final void zzss() {
        this.zzua();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapr.zzcv);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzag(int n) {
        if (n == 0) {
            zzanx zzanx2 = this;
            zznn.zza(zzanx2.zzdms.zzje(), zzanx2.zzdje, "aebb2");
        }
        this.zzua();
        if (this.zzdms.zzje() != null) {
            this.zzdms.zzje().zzf("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzapr.zzcv);
        this.zza("onhide", hashMap);
    }

    private final void zzua() {
        zznn.zza(this.zzdms.zzje(), this.zzdje, "aeh2");
    }

    @Override
    public final void zzmz() {
        if (this.zzdmq == null) {
            zznn.zza(this.zzdms.zzje(), this.zzdje, "aes2");
            this.zzdmq = zznn.zzb(this.zzdms.zzje());
            this.zzdms.zza("native:view_show", this.zzdmq);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapr.zzcv);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzst() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbs.zzei();
        hashMap.put("app_muted", String.valueOf(zzahn.zzdo()));
        zzbs.zzei();
        hashMap.put("app_volume", String.valueOf(zzahn.zzdn()));
        zzbs.zzei();
        hashMap.put("device_volume", String.valueOf(zzahn.zzaq(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzd zzsv() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzd zzsw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzapa zzsx() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzsy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzalx;
        }
    }

    @Override
    public final zzani zzsz() {
        return this.zzdma;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzta() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmd;
        }
    }

    @Override
    public final zzcv zztb() {
        return this.zzbuv;
    }

    @Override
    public final zzakd zzsk() {
        return this.zzapr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zztc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmf;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbs.zzei();
            zzahn.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzagf.zzbx((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdma.zztn()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzdmn != null) {
                    this.zzdmn.zzc(motionEvent);
                }
            }
        } else if (this.zzbuv != null) {
            this.zzbuv.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzmx zzmx2 = zznh.zzbla;
        if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzdmf || this.zzdmc.zzui()) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzdmc.zzuj()) {
                float f = 0.0f;
                zzaoa zzaoa2 = this.zzsg();
                if (zzaoa2 != null) {
                    f = zzaoa2.getAspectRatio();
                }
                if (f == 0.0f) {
                    super.onMeasure(n, n2);
                    return;
                }
                int n3 = View.MeasureSpec.getSize((int)n);
                int n4 = View.MeasureSpec.getSize((int)n2);
                int n5 = (int)((float)n4 * f);
                int n6 = (int)((float)n3 / f);
                if (n4 == 0 && n6 != 0) {
                    n4 = n6;
                    n5 = (int)((float)n4 * f);
                } else if (n3 == 0 && n5 != 0) {
                    n3 = n5;
                    n6 = (int)((float)n3 / f);
                }
                int n7 = Math.min(n5, n3);
                int n8 = Math.min(n6, n4);
                this.setMeasuredDimension(n7, n8);
                return;
            }
            if (this.zzdmc.isFluid()) {
                int n9;
                Object object2 = zznh.zzbpa;
                if (((Boolean)zzkb.zzif().zzd(object2)).booleanValue() || !zzq.zzamj()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzany((zzanx)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzdd(string2);
                float f = this.zzdly.getResources().getDisplayMetrics().density;
                int n10 = View.MeasureSpec.getSize((int)n);
                switch (this.zzdmp) {
                    case -1: {
                        n9 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n9 = (int)((float)this.zzdmp * f);
                    }
                }
                this.setMeasuredDimension(n10, n9);
                return;
            }
            if (this.zzdmc.zzuh()) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzavx.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n11 = View.MeasureSpec.getMode((int)n);
            int n12 = View.MeasureSpec.getSize((int)n);
            int n13 = View.MeasureSpec.getMode((int)n2);
            int n14 = View.MeasureSpec.getSize((int)n2);
            int n15 = Integer.MAX_VALUE;
            if (n11 == Integer.MIN_VALUE || n11 == 0x40000000) {
                n15 = n12;
            }
            int n16 = Integer.MAX_VALUE;
            if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
                n16 = n14;
            }
            if (this.zzdmc.widthPixels > n15 || this.zzdmc.heightPixels > n16) {
                float f = this.zzdly.getResources().getDisplayMetrics().density;
                int n17 = (int)((float)this.zzdmc.widthPixels / f);
                int n18 = (int)((float)this.zzdmc.heightPixels / f);
                int n19 = (int)((float)n12 / f);
                int n20 = (int)((float)n14 / f);
                zzagf.zzcu((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n17).append("x").append(n18).append(" dp, but only has ").append(n19).append("x").append(n20).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzdmc.widthPixels, this.zzdmc.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zztz();
        zzd zzd2 = this.zzsv();
        if (zzd2 != null && bl) {
            zzd2.zzmy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzd zzd2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmb = zzd2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzd zzd2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmu = zzd2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzapa zzapa2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmc = zzapa2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzad(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzdmf;
            this.zzdmf = bl;
            this.zzub();
            if (bl2) {
                new zzxb(this).zzbo(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zzth() {
        this.zzavi.zzqu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzavi.onAttachedToWindow();
            }
            boolean bl = this.zzdml;
            if (this.zzdma != null && this.zzdma.zztn()) {
                bl = true;
                if (!this.zzdmm) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdma.zzto();
                    if (onGlobalLayoutListener != null) {
                        zzbs.zzfc();
                        zzanx zzanx2 = this;
                        if (zzanx2 == null) {
                            throw null;
                        }
                        zzaln.zza((View)zzanx2, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzdma.zztp()) != null) {
                        zzbs.zzfc();
                        zzanx zzanx3 = this;
                        if (zzanx3 == null) {
                            throw null;
                        }
                        zzaln.zza((View)zzanx3, onScrollChangedListener);
                    }
                    this.zzdmm = true;
                }
                this.zztz();
            }
            this.zzah(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzavi.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdmm && this.zzdma != null && this.zzdma.zztn() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdma.zzto();
                if (onGlobalLayoutListener != null) {
                    zzbs.zzek().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdma.zztp()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdmm = false;
            }
        }
        this.zzah(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzdly.setBaseContext(context);
        this.zzavi.zzi(this.zzdly.zzsi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdmb != null) {
                this.zzdmb.zza(this.zzdma.zzfv(), bl);
            } else {
                this.zzdmd = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmh = n;
            if (this.zzdmb != null) {
                this.zzdmb.setRequestedOrientation(this.zzdmh);
            }
            return;
        }
    }

    @Override
    public final Activity zzsi() {
        return this.zzdly.zzsi();
    }

    @Override
    public final Context zzsu() {
        return this.zzdly.zzsu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzub() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdmf || this.zzdmc.zzuh()) {
                zzagf.zzbx((String)"Enabling hardware acceleration on an overlay.");
                this.zzuc();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzagf.zzbx((String)"Disabling hardware acceleration on an AdView.");
                zzanx zzanx2 = this;
                Object object2 = zzanx2.mLock;
                synchronized (object2) {
                    if (!zzanx2.zzdmg) {
                        zzbs.zzek().zzy((View)zzanx2);
                    }
                    zzanx2.zzdmg = true;
                }
            } else {
                zzagf.zzbx((String)"Enabling hardware acceleration on an AdView.");
                this.zzuc();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzuc() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdmg) {
                zzbs.zzek().zzx((View)this);
            }
            this.zzdmg = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzue();
            this.zzavi.zzqv();
            if (this.zzdmb != null) {
                this.zzdmb.close();
                this.zzdmb.onDestroy();
                this.zzdmb = null;
            }
            this.zzdma.reset();
            if (this.zzdme) {
                return;
            }
            zzbs.zzfb();
            zzamz.zzb(this);
            this.zzud();
            this.zzdme = true;
            zzagf.v("Initiating WebView self destruct sequence in 3...");
            this.zzdma.zztr();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzdme) {
                        this.zzdma.reset();
                        zzbs.zzfb();
                        zzamz.zzb(this);
                        this.zzud();
                        this.zzpu();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zztd() {
        Object object = this.mLock;
        synchronized (object) {
            zzagf.v("Destroying WebView!");
            this.zzpu();
            zzahn.zzdaw.post((Runnable)new zzanz(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzpu() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzdmv) {
                this.zzdmv = true;
                zzbs.zzem().zzpu();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdme;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdma != null && this.zzdma.zzty() != null) {
            this.zzdma.zzty().zzdb();
        }
    }

    @Override
    public final void zzti() {
        if (this.zzdmr == null) {
            this.zzdmr = zznn.zzb(this.zzdms.zzje());
            this.zzdms.zza("native:view_load", this.zzdmr);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zztl() {
        zzagf.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaf(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmi = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzte() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zztf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcq() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmj = true;
            if (this.zzdlz != null) {
                this.zzdlz.zzcq();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcr() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmj = false;
            if (this.zzdlz != null) {
                this.zzdlz.zzcr();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzud() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmw = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzda(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcrt = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcrt;
        }
    }

    @Override
    public final zzamg zzsf() {
        return null;
    }

    @Override
    public final zzns zzsh() {
        return this.zzdje;
    }

    @Override
    public final zznt zzsj() {
        return this.zzdms;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdmt = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzdmt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzoq zzoq2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmn = zzoq2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzoq zztj() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzaoa zzsg() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzaoa zzaoa2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdmk != null) {
                zzagf.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzdmk = zzaoa2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zztg() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdmo > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzag(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdmo += bl ? 1 : -1;
            if (this.zzdmo <= 0 && this.zzdmb != null) {
                this.zzdmb.zznb();
            }
            return;
        }
    }

    private final void zzue() {
        if (this.zzdms == null) {
            return;
        }
        zznu zznu2 = this.zzdms.zzje();
        if (zznu2 != null && zzbs.zzem().zzpc() != null) {
            zzbs.zzem().zzpc().zza(zznu2);
        }
    }

    @Override
    public final void zztk() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzac(boolean bl) {
        this.zzdma.zzac(bl);
    }

    @Override
    public final void zzna() {
        zzd zzd2 = this.zzsv();
        if (zzd2 != null) {
            zzd2.zzna();
        }
    }

    @Override
    public final int zzsl() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzsm() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzdma.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzdma.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzdma.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzdma.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgs zzgs2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdml = zzgs2.zzake;
        }
        this.zzah(zzgs2.zzake);
    }

    private final void zzah(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzt<? super zzanh> zzt2) {
        if (this.zzdma != null) {
            this.zzdma.zza(string2, zzt2);
        }
    }

    @Override
    public final void zzb(String string2, zzt<? super zzanh> zzt2) {
        if (this.zzdma != null) {
            this.zzdma.zzb(string2, zzt2);
        }
    }

    static /* synthetic */ Object zza(zzanx zzanx2) {
        return zzanx2.mLock;
    }

    static /* synthetic */ int zzb(zzanx zzanx2) {
        return zzanx2.zzdmp;
    }

    static /* synthetic */ int zza(zzanx zzanx2, int n) {
        zzanx2.zzdmp = n;
        return zzanx2.zzdmp;
    }

    static /* synthetic */ void zzc(zzanx zzanx2) {
        super.destroy();
    }
}

