/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdpq;
import com.google.android.gms.internal.zzdpw;
import com.google.android.gms.internal.zzdpx;
import com.google.android.gms.internal.zzdqc;
import com.google.android.gms.internal.zzdqd;
import com.google.android.gms.internal.zzdsy;
import com.google.android.gms.internal.zzdtb;
import com.google.android.gms.internal.zzdtd;
import com.google.android.gms.internal.zzdth;
import com.google.android.gms.internal.zzdtt;
import com.google.android.gms.internal.zzfes;
import com.google.android.gms.internal.zzfhe;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdqe {
    private static final Logger logger = Logger.getLogger(zzdqe.class.getName());
    private static final ConcurrentMap<String, zzdpw> zzlsx = new ConcurrentHashMap<String, zzdpw>();
    private static final ConcurrentMap<String, Boolean> zzlsy = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzdpq> zzlsz = new ConcurrentHashMap<String, zzdpq>();

    public static synchronized void zza(String string2, zzdpq zzdpq2) throws GeneralSecurityException {
        if (zzlsz.containsKey(string2.toLowerCase())) {
            zzdpq zzdpq3 = (zzdpq)zzlsz.get(string2.toLowerCase());
            if (!zzdpq2.getClass().equals(zzdpq3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzlsz.put(string2.toLowerCase(), zzdpq2);
    }

    public static zzdpq zzog(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzdpq zzdpq2 = (zzdpq)zzlsz.get(string2.toLowerCase());
        if (zzdpq2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkhybrid")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinksignature")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.init().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.init().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzdpq2;
    }

    public static <P> void zza(String string2, zzdpw<P> zzdpw2) throws GeneralSecurityException {
        zzdqe.zza(string2, zzdpw2, true);
    }

    public static synchronized <P> void zza(String string2, zzdpw<P> zzdpw2, boolean bl) throws GeneralSecurityException {
        if (zzdpw2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (zzlsx.containsKey(string2)) {
            zzdpw<P> zzdpw3 = zzdqe.zzoh(string2);
            boolean bl2 = (Boolean)zzlsy.get(string2);
            if (!zzdpw2.getClass().equals(zzdpw3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzdpw3.getClass().getName(), zzdpw2.getClass().getName()));
            }
        }
        zzlsx.put(string2, zzdpw2);
        zzlsy.put(string2, bl);
    }

    private static <P> zzdpw<P> zzoh(String string2) throws GeneralSecurityException {
        zzdpw zzdpw2 = (zzdpw)zzlsx.get(string2);
        if (zzdpw2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        return zzdpw2;
    }

    public static <P> zzdsy zza(zzdtd zzdtd2) throws GeneralSecurityException {
        zzdpw<P> zzdpw2 = zzdqe.zzoh(zzdtd2.zzbon());
        if (((Boolean)zzlsy.get(zzdtd2.zzbon())).booleanValue()) {
            return zzdpw2.zzc(zzdtd2.zzboo());
        }
        String string2 = String.valueOf(zzdtd2.zzbon());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzfhe zzb(zzdtd zzdtd2) throws GeneralSecurityException {
        zzdpw<P> zzdpw2 = zzdqe.zzoh(zzdtd2.zzbon());
        if (((Boolean)zzlsy.get(zzdtd2.zzbon())).booleanValue()) {
            return zzdpw2.zzb(zzdtd2.zzboo());
        }
        String string2 = String.valueOf(zzdtd2.zzbon());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzfhe zza(String string2, zzfhe zzfhe2) throws GeneralSecurityException {
        zzdpw<P> zzdpw2 = zzdqe.zzoh(string2);
        if (((Boolean)zzlsy.get(string2)).booleanValue()) {
            return zzdpw2.zzb(zzfhe2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zzb(String string2, zzfhe zzfhe2) throws GeneralSecurityException {
        return zzdqe.zzoh(string2).zza(zzfhe2);
    }

    private static <P> P zza(String string2, zzfes zzfes2) throws GeneralSecurityException {
        return zzdqe.zzoh(string2).zza(zzfes2);
    }

    public static <P> P zzf(String string2, byte[] byArray) throws GeneralSecurityException {
        return zzdqe.zza(string2, zzfes.zzaz((byte[])byArray));
    }

    public static <P> zzdqc<P> zza(zzdpx zzdpx2, zzdpw<P> zzdpw2) throws GeneralSecurityException {
        zzdth zzdth2 = zzdpx2.zzblu();
        if (zzdth2.zzbpe() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
        int n = zzdth2.zzbpc();
        boolean bl = false;
        boolean bl2 = true;
        Iterator<zzdth.zzb> iterator = zzdth2.zzbpd().iterator();
        while (iterator.hasNext()) {
            zzdth.zzb zzb2;
            zzdth.zzb zzb3 = zzb2 = iterator.next();
            if (!zzb2.zzbpg()) {
                throw new GeneralSecurityException(String.format("key %d has no key data", zzb3.zzbpj()));
            }
            if (zzb3.zzbpk() == zzdtt.zzlxs) {
                throw new GeneralSecurityException(String.format("key %d has unknown prefix", zzb3.zzbpj()));
            }
            if (zzb3.zzbpi() == zzdtb.zzlwl) {
                throw new GeneralSecurityException(String.format("key %d has unknown status", zzb3.zzbpj()));
            }
            if (zzb2.zzbpi() == zzdtb.zzlwm && zzb2.zzbpj() == n) {
                if (bl) {
                    throw new GeneralSecurityException("keyset contains multiple primary keys");
                }
                bl = true;
            }
            if (zzb2.zzbph().zzbop() == zzdsy.zzb.zzlwh) continue;
            bl2 = false;
        }
        if (!bl && !bl2) {
            throw new GeneralSecurityException("keyset doesn't contain a valid primary key");
        }
        zzdqc zzdqc2 = new zzdqc();
        for (zzdth.zzb zzb4 : zzdpx2.zzblu().zzbpd()) {
            if (zzb4.zzbpi() != zzdtb.zzlwm) continue;
            P p = zzdqe.zza(zzb4.zzbph().zzbon(), zzb4.zzbph().zzboo());
            zzdqd zzdqd2 = zzdqc2.zza(p, zzb4);
            if (zzb4.zzbpj() != zzdpx2.zzblu().zzbpc()) continue;
            zzdqc2.zza(zzdqd2);
        }
        return zzdqc2;
    }
}

