/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdpw;
import com.google.android.gms.internal.zzdqa;
import com.google.android.gms.internal.zzdsq;
import com.google.android.gms.internal.zzdss;
import com.google.android.gms.internal.zzdsu;
import com.google.android.gms.internal.zzdsw;
import com.google.android.gms.internal.zzdsy;
import com.google.android.gms.internal.zzdvg;
import com.google.android.gms.internal.zzdvi;
import com.google.android.gms.internal.zzdvk;
import com.google.android.gms.internal.zzfes;
import com.google.android.gms.internal.zzfge;
import com.google.android.gms.internal.zzfhe;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzdqy
implements zzdpw<zzdqa> {
    zzdqy() {
    }

    private final zzdqa zzh(zzfes zzfes2) throws GeneralSecurityException {
        try {
            zzdvg zzdvg2;
            zzdss zzdss2;
            zzdss zzdss3;
            zzdss zzdss4 = zzdss3 = zzdss.zzae(zzfes2);
            zzdss zzdss5 = zzdss3;
            if (!(zzdss3 instanceof zzdss)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdss zzdss6 = zzdss2 = zzdss5;
            zzdvk.zzt(zzdss2.getVersion(), 0);
            if (zzdss6.zzbmj().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdqy.zza(zzdss6.zzbod());
            zzdsq zzdsq2 = zzdss2.zzbod().zzboj();
            byte[] byArray = zzdss2.zzbmj().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzdss2.zzbod().zzbok();
            switch (zzdsq2) {
                case zzlvo: {
                    zzdvg2 = new zzdvg("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzlvq: {
                    zzdvg2 = new zzdvg("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzlvr: {
                    zzdvg2 = new zzdvg("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdvg2;
        }
        catch (zzfge zzfge2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzfge2);
        }
    }

    @Override
    public final zzfhe zzb(zzfes zzfes2) throws GeneralSecurityException {
        try {
            zzdsu zzdsu2 = zzdsu.zzag(zzfes2);
            return this.zzb((zzfhe)zzdsu2);
        }
        catch (zzfge zzfge2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzfge2);
        }
    }

    @Override
    public final zzfhe zzb(zzfhe zzfhe2) throws GeneralSecurityException {
        zzdsu zzdsu2;
        if (!(zzfhe2 instanceof zzdsu)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdsu zzdsu3 = zzdsu2 = (zzdsu)zzfhe2;
        if (zzdsu2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdqy.zza(zzdsu3.zzbod());
        return zzdss.zzboe().zzfs(0).zzc(zzdsu2.zzbod()).zzaf(zzfes.zzaz((byte[])zzdvi.zzgh(zzdsu2.getKeySize()))).zzcxt();
    }

    @Override
    public final zzdsy zzc(zzfes zzfes2) throws GeneralSecurityException {
        zzdss zzdss2 = (zzdss)this.zzb(zzfes2);
        return (zzdsy)zzdsy.zzboq().zzoj("type.googleapis.com/google.crypto.tink.HmacKey").zzai(zzdss2.toByteString()).zzb(zzdsy.zzb.zzlwf).zzcxt();
    }

    private static void zza(zzdsw zzdsw2) throws GeneralSecurityException {
        if (zzdsw2.zzbok() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzdsw2.zzboj()) {
            case zzlvo: {
                if (zzdsw2.zzbok() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlvq: {
                if (zzdsw2.zzbok() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlvr: {
                if (zzdsw2.zzbok() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzfhe zzfhe2) throws GeneralSecurityException {
        zzdss zzdss2;
        zzfhe zzfhe3 = zzfhe2;
        if (!(zzfhe3 instanceof zzdss)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdss zzdss3 = zzdss2 = (zzdss)zzfhe3;
        zzdvk.zzt(zzdss2.getVersion(), 0);
        if (zzdss3.zzbmj().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdqy.zza(zzdss3.zzbod());
        zzdsq zzdsq2 = zzdss2.zzbod().zzboj();
        byte[] byArray = zzdss2.zzbmj().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzdss2.zzbod().zzbok();
        switch (zzdsq2) {
            case zzlvo: {
                return new zzdvg("HMACSHA1", secretKeySpec, n);
            }
            case zzlvq: {
                return new zzdvg("HMACSHA256", secretKeySpec, n);
            }
            case zzlvr: {
                return new zzdvg("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzfes zzfes2) throws GeneralSecurityException {
        return this.zzh(zzfes2);
    }
}

