/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzt;
import com.google.android.gms.internal.zzzv;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
@TargetApi(value=14)
public final class zzhk
extends Thread {
    private boolean mStarted = false;
    private boolean zzazb = false;
    private boolean zzbn = false;
    private final Object mLock;
    private final zzhf zzazc;
    private final zzzt zzazd;
    private final int zzaze;
    private final int zzaya;
    private final int zzazf;
    private final int zzayc;
    private final int zzazg;
    private final int zzazh;
    private final int zzazi;
    private final int zzazj;
    private final String zzazk;
    private final boolean zzazl;

    public zzhk(zzhf zzhf2, zzzt zzzt2) {
        this.zzazc = zzhf2;
        this.zzazd = zzzt2;
        this.mLock = new Object();
        zzmx zzmx2 = zznh.zzbjp;
        this.zzaya = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjq;
        this.zzazf = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjr;
        this.zzayc = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjs;
        this.zzazg = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjv;
        this.zzazh = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjx;
        this.zzazi = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjy;
        this.zzazj = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbjt;
        this.zzaze = (Integer)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbka;
        this.zzazk = (String)zzkb.zzif().zzd(zzmx2);
        zzmx2 = zznh.zzbkc;
        this.zzazl = (Boolean)zzkb.zzif().zzd(zzmx2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgt() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzagf.zzbx((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzhk.zzgu()) {
                    object = zzbs.zzel().getActivity();
                    if (object == null) {
                        zzagf.zzbx((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgw();
                    } else {
                        Activity activity = object;
                        zzhk zzhk2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbs.zzem().zza(exception, "ContentFetchTask.extractContent");
                                zzagf.zzbx((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzhk zzhk3 = zzhk2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzhl(zzhk3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzagf.zzbx((String)"ContentFetchTask: sleeping");
                    this.zzgw();
                }
                Thread.sleep(this.zzaze * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzagf.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzagf.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzazd.zza((Throwable)exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzazb) {
                    try {
                        zzagf.zzbx((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzj(View view) {
        try {
            zzhe zzhe2 = new zzhe(this.zzaya, this.zzazf, this.zzayc, this.zzazg, this.zzazh, this.zzazi, this.zzazj);
            zzho zzho2 = this.zza(view, zzhe2);
            zzhe2.zzgq();
            if (zzho2.zzazt == 0 && zzho2.zzazu == 0) {
                return;
            }
            if (zzho2.zzazu == 0 && zzhe2.zzgr() == 0) {
                return;
            }
            if (zzho2.zzazu == 0 && this.zzazc.zza(zzhe2)) {
                return;
            }
            this.zzazc.zzc(zzhe2);
            return;
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzazd.zza((Throwable)exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzgu() {
        try {
            Context context = zzbs.zzel().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbs.zzem().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzho zza(@Nullable View view, zzhe zzhe2) {
        Object object;
        if (view == null) {
            return new zzho(this, 0, 0);
        }
        Context context = zzbs.zzel().getContext();
        if (context != null) {
            object = zznh.zzbjz;
            int n = context.getResources().getIdentifier((String)zzkb.zzif().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzazk) && string2 != null && string2.equals(this.zzazk)) {
                return new zzho(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzhe2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzho(this, 1, 0);
            }
            return new zzho(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzanh)) {
            boolean bl2;
            zzhe2.zzgp();
            zzhe zzhe3 = zzhe2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzq.zzaml()) {
                bl2 = false;
            } else {
                zzhe3.zzgp();
                webView.post((Runnable)new zzhm((zzhk)object, zzhe3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzho(this, 0, 1);
            }
            return new zzho(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzho zzho2 = this.zza(viewGroup.getChildAt(i), zzhe2);
                n += zzho2.zzazt;
                n2 += zzho2.zzazu;
            }
            return new zzho(this, n, n2);
        }
        return new zzho(this, 0, 0);
    }

    final void zza(zzhe zzhe2, WebView webView, String string2, boolean bl) {
        zzhe2.zzgo();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzazl && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzhe2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzhe2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzhe2.zzgj()) {
                this.zzazc.zzb(zzhe2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzagf.zzbx((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzagf.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzazd.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzhe zzgv() {
        return this.zzazc.zzgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzazb = false;
            this.mLock.notifyAll();
            zzagf.zzbx((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgw() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzazb = true;
            zzagf.zzbx((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzgx() {
        return this.zzazb;
    }
}

