/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzoy;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzzb;
import com.google.android.gms.internal.zzzv;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
public class zzow
implements zzos {
    private final Object mLock = new Object();
    private final zzot zzbuq;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbut;
    @Nullable
    private final zzzb zzarn;
    @Nullable
    private final zzou zzbuu;
    private final zzcv zzbuv;
    @Nullable
    private final zzakd zzapr;
    boolean zzbuw;
    @Nullable
    private String zzaro;
    @Nullable
    private zzafe zzaqh;
    private WeakReference<View> zzbux = null;

    public zzow(Context context, zzot zzot2, @Nullable zzzb zzzb2, zzcv zzcv2, @Nullable JSONObject jSONObject, @Nullable zzou zzou2, @Nullable zzakd zzakd2, @Nullable String string2) {
        this.mContext = context;
        this.zzbuq = zzot2;
        this.zzarn = zzzb2;
        this.zzbuv = zzcv2;
        this.zzbut = jSONObject;
        this.zzbuu = zzou2;
        this.zzapr = zzakd2;
        this.zzaro = string2;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zzog zzog2 = this.zzbuu.zzjv();
        if (zzog2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zzog2.zzjp()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzoh zzoh2 = new zzoh(this.mContext, zzog2, layoutParams);
        zzoh2.setOnClickListener(onClickListener);
        zzmx zzmx2 = zznh.zzbou;
        zzoh2.setContentDescription((CharSequence)zzkb.zzif().zzd(zzmx2));
        return zzoh2;
    }

    @Override
    public boolean zzkc() {
        zzog zzog2 = this.zzbuu.zzjv();
        return zzog2 != null && zzog2.zzjq();
    }

    @Override
    public boolean zzkd() {
        return this.zzbut != null && this.zzbut.optBoolean("allow_pub_owned_ad_view", false);
    }

    private final boolean zzar(String string2) {
        JSONObject jSONObject = this.zzbut == null ? null : this.zzbut.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, String string2, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzn(view2);
        JSONObject jSONObject3 = zzow.zzo(view2);
        JSONObject jSONObject4 = this.zzp(view2);
        JSONObject jSONObject5 = null;
        try {
            JSONObject jSONObject6 = zzbs.zzei().zza(bundle, null);
            jSONObject5 = new JSONObject();
            jSONObject5.put("click_point", (Object)jSONObject6);
            jSONObject5.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbq.zzge((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            Map<String, WeakReference<View>> map2 = map;
            synchronized (map2) {
                for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                    View view3 = (View)entry.getValue().get();
                    if (!view.equals(view3)) continue;
                    this.zza(view, entry.getKey(), bundle, map, view2);
                    return;
                }
            }
        }
        if ("2".equals(this.zzbuu.zzju())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzbuu.zzju())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzagf.zzbx((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzar("click_reporting")) {
            zzagf.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string2 = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbs.zzei().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, String string2, JSONObject jSONObject5, JSONObject jSONObject6) {
        zzbq.zzge((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzbut);
            if (jSONObject2 != null) {
                jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject7.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject5 != null) {
                jSONObject7.put("click_signal", (Object)jSONObject5);
            }
            if (jSONObject3 != null) {
                jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            }
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", (Object)this.zzbuu.zzju());
            zzbs.zzek();
            jSONObject8.put("is_privileged_process", zzaht.zzqj());
            jSONObject8.put("has_custom_click_handler", this.zzbuq.zzs(this.zzbuu.getCustomTemplateId()) != null);
            jSONObject7.put("has_custom_click_handler", this.zzbuq.zzs(this.zzbuu.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject9 = this.zzbut.optJSONObject("tracking_urls_and_actions");
                if (jSONObject9 == null) {
                    jSONObject9 = new JSONObject();
                }
                String string3 = jSONObject9.optString("click_string");
                String string4 = this.zzbuv.zzaf().zza(this.mContext, string3, view);
                jSONObject8.put("click_signals", (Object)string4);
            }
            catch (Exception exception) {
                zzagf.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject7.put("click", (Object)jSONObject8);
            if (jSONObject6 != null) {
                jSONObject7.put("provided_signals", (Object)jSONObject6);
            }
            jSONObject7.put("ads_id", (Object)this.zzaro);
            zzakj.zza(this.zzarn.zzj(jSONObject7), "NativeAdEngineImpl.performClick");
            return;
        }
        catch (JSONException jSONException) {
            zzagf.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzbuv.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzagf.zzbx((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzar("touch_reporting")) {
            zzagf.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbuv.zzaf().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbuw) {
                return;
            }
            if (zzow.zzl(view)) {
                this.zza(view, map);
                return;
            }
            zzmx zzmx2 = zznh.zzboz;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && map != null) {
                Map<String, WeakReference<View>> map2 = map;
                synchronized (map2) {
                    Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        View view2 = (View)iterator.next().getValue().get();
                        if (view2 == null || !zzow.zzl(view2)) continue;
                        this.zza(view, map);
                        return;
                    }
                }
            }
            return;
        }
    }

    private static boolean zzl(View view) {
        return view.isShown() && view.getGlobalVisibleRect(new Rect(), null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzn(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzow.zzo(view);
        JSONObject jSONObject4 = this.zzp(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, jSONObject4, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzar("impression_reporting")) {
            zzagf.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbs.zzei().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbq.zzge((String)"recordImpression must be called on the main UI thread.");
        if (this.zzbuw) {
            return true;
        }
        this.zzbuw = true;
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbut);
            jSONObject6.put("ads_id", (Object)this.zzaro);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            }
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            zzakj.zza(this.zzarn.zzk(jSONObject6), "NativeAdEngineImpl.recordImpression");
        }
        catch (JSONException jSONException) {
            zzagf.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbuq.zza(this);
        this.zzbuq.zzcc();
        return true;
    }

    @Override
    public final View zzkj() {
        if (this.zzbux != null) {
            return (View)this.zzbux.get();
        }
        return null;
    }

    @Override
    public final void zzk(View view) {
        this.zzbux = new WeakReference<View>(view);
    }

    @Override
    public final void zzi(View view) {
        zzcr zzcr2;
        zzmx zzmx2 = zznh.zzbnp;
        if (!((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            return;
        }
        if (this.zzbuv != null && (zzcr2 = this.zzbuv.zzaf()) != null) {
            zzcr2.zzb(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        Map<String, WeakReference<View>> map3;
        zzmx zzmx2 = zznh.zzbos;
        if (!((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map != null) {
            map3 = map;
            synchronized (map3) {
                iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                    view2.setClickable(true);
                    view2.setOnClickListener(onClickListener);
                }
            }
        }
        if (map2 != null) {
            map3 = map2;
            synchronized (map3) {
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzmx zzmx2 = zznh.zzbor;
        if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                View view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(null);
                view2.setClickable(false);
                view2.setOnClickListener(null);
            }
            return;
        }
    }

    public zzanh zzkg() throws zzanv {
        if (this.zzbut == null || this.zzbut.optJSONObject("overlay") == null) {
            return null;
        }
        zzow zzow2 = this;
        zzakd zzakd2 = zzow2.zzapr;
        zzcv zzcv2 = zzow2.zzbuv;
        zzjn zzjn2 = zzjn.zzf((Context)zzow2.mContext);
        Context context = zzow2.mContext;
        zzanh zzanh2 = zzbs.zzej().zza(context, zzapa.zzc(zzjn2), zzjn2.zzbek, false, false, zzcv2, zzakd2, null, null, null, zzis.zzhl());
        if (zzanh2 != null) {
            zzanh zzanh3 = zzanh2;
            if (zzanh3 == null) {
                throw null;
            }
            ((View)zzanh3).setVisibility(8);
            new zzoy(zzanh2).zza(this.zzarn);
        }
        return zzanh2;
    }

    public final void zzh(Map<String, WeakReference<View>> map) {
        if (this.zzbuu.zzjw() != null) {
            if ("2".equals(this.zzbuu.zzju())) {
                zzbs.zzem().zzb(this.mContext, this.zzbuq.getAdUnitId(), this.zzbuu.zzju(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzbuu.zzju())) {
                zzbs.zzem().zzb(this.mContext, this.zzbuq.getAdUnitId(), this.zzbuu.zzju(), map.containsKey("1009"));
            }
        }
    }

    public final boolean zzb(View view, zzoq zzoq2) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        View view2 = this.zzbuu.zzjw();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbuq.zza(zzoq2);
            return true;
        }
        return false;
    }

    @Override
    public final void zza(View view, zzoq zzoq2) {
        Object object;
        zzpq zzpq2;
        if (this.zzb(view, zzoq2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzbuu instanceof zzov)) {
            return;
        }
        zzov zzov2 = (zzov)this.zzbuu;
        if (zzov2.getImages() != null && zzov2.getImages().size() > 0 && (zzpq2 = (object = zzov2.getImages().get(0)) instanceof IBinder ? zzpr.zzk((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzpq2.zzjr();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzx((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzow)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzagf.zzcu((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zzki() {
        this.zzbuq.zzcv();
    }

    @Override
    public void zzkh() {
        this.zzarn.zzls();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzm(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzt(int n) {
        zzkb.zzia();
        return zzajr.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzt(rect.right - rect.left));
        jSONObject.put("height", this.zzt(rect.bottom - rect.top));
        jSONObject.put("x", this.zzt(rect.left));
        jSONObject.put("y", this.zzt(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzn(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzow.zzm(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzt(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzt(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzt(nArray[0]));
            jSONObject3.put("y", this.zzt(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzt(nArray[0]));
                jSONObject2.put("y", this.zzt(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzagf.zzcu((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzo(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzei();
            int n = zzahn.zzw(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzp(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzei();
            jSONObject.put("can_show_on_lock_screen", zzahn.zzv(view));
            zzbs.zzei();
            jSONObject.put("is_keyguard_locked", zzahn.zzat(this.mContext));
        }
        catch (JSONException jSONException) {
            zzagf.zzcu((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzow.zzm(view);
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = zzow.zzm(view2);
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = new JSONObject();
                try {
                    JSONObject jSONObject4;
                    jSONObject3.put("width", this.zzt(view2.getMeasuredWidth()));
                    jSONObject3.put("height", this.zzt(view2.getMeasuredHeight()));
                    jSONObject3.put("x", this.zzt(nArray2[0] - nArray[0]));
                    jSONObject3.put("y", this.zzt(nArray2[1] - nArray[1]));
                    jSONObject3.put("relative_to", (Object)"ad_view");
                    jSONObject2.put("frame", (Object)jSONObject3);
                    Rect rect = new Rect();
                    if (view2.getLocalVisibleRect(rect)) {
                        jSONObject4 = this.zzb(rect);
                    } else {
                        jSONObject4 = new JSONObject();
                        jSONObject4.put("width", 0);
                        jSONObject4.put("height", 0);
                        jSONObject4.put("x", this.zzt(nArray2[0] - nArray[0]));
                        jSONObject4.put("y", this.zzt(nArray2[1] - nArray[1]));
                        jSONObject4.put("relative_to", (Object)"ad_view");
                    }
                    jSONObject2.put("visible_bounds", (Object)jSONObject4);
                    if (view2 instanceof TextView) {
                        TextView textView = (TextView)view2;
                        jSONObject2.put("text_color", textView.getCurrentTextColor());
                        jSONObject2.put("font_size", (double)textView.getTextSize());
                        jSONObject2.put("text", (Object)textView.getText());
                    }
                    jSONObject.put(entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzagf.zzcu((String)"Unable to get asset views information");
                }
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzafe zzkk() {
        if (zzbs.zzfd().zzs(this.mContext)) {
            if (this.zzaqh == null) {
                this.zzaqh = new zzafe(this.mContext, this.zzbuq.getAdUnitId());
            }
            return this.zzaqh;
        }
        return null;
    }
}

