/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzacw;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzabh
@Hide
public final class zzacv
extends zzbgl {
    public static final Parcelable.Creator<zzacv> CREATOR = new zzacx();
    private ParcelFileDescriptor zza;
    private Parcelable zzb;
    private boolean zzc;

    public zzacv(ParcelFileDescriptor parcelFileDescriptor) {
        this.zza = parcelFileDescriptor;
        this.zzb = null;
        this.zzc = true;
    }

    public zzacv(zzbgp zzbgp2) {
        this.zza = null;
        this.zzb = zzbgp2;
        this.zzc = false;
    }

    public final <T extends zzbgp> T zza(Parcelable.Creator<T> creator) {
        if (this.zzc) {
            byte[] byArray;
            if (this.zza == null) {
                zzahw.zzc((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zza));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzahw.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                zzp.zza((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzb = (zzbgp)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzc = false;
        }
        return (T)((zzbgp)this.zzb);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zza();
        Parcel parcel2 = parcel;
        zzacv zzacv2 = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)zzacv2.zza, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zza() {
        if (this.zza == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzb.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zza = this.zza(byArray);
        }
        return this.zza;
    }

    private final <T> ParcelFileDescriptor zza(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzacw zzacw2 = new zzacw(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzacw2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzahw.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbt.zzi().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzp.zza(autoCloseOutputStream);
            return null;
        }
    }
}

