/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzanl
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzank {
    private static final float[] zza = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzani zzb;
    private final float[] zzc;
    private final float[] zzd;
    private final float[] zze;
    private final float[] zzf;
    private final float[] zzg;
    private final float[] zzh;
    private final float[] zzi;
    private float zzj;
    private float zzk;
    private float zzl;
    private int zzm;
    private int zzn;
    private SurfaceTexture zzo;
    private SurfaceTexture zzp;
    private int zzq;
    private int zzr;
    private int zzs;
    private FloatBuffer zzt = ByteBuffer.allocateDirect(zza.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzu;
    private final Object zzv;
    private EGL10 zzw;
    private EGLDisplay zzx;
    private EGLContext zzy;
    private EGLSurface zzz;
    private volatile boolean zzaa;
    private volatile boolean zzab;

    public zzanl(Context context) {
        super("SphericalVideoProcessor");
        this.zzt.put(zza).position(0);
        this.zzc = new float[9];
        this.zzd = new float[9];
        this.zze = new float[9];
        this.zzf = new float[9];
        this.zzg = new float[9];
        this.zzh = new float[9];
        this.zzi = new float[9];
        this.zzj = Float.NaN;
        this.zzb = new zzani(context);
        this.zzb.zza(this);
        this.zzu = new CountDownLatch(1);
        this.zzv = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzn = n;
        this.zzm = n2;
        this.zzp = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2) {
        Object object = this.zzv;
        synchronized (object) {
            this.zzn = n;
            this.zzm = n2;
            this.zzaa = true;
            this.zzv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb() {
        Object object = this.zzv;
        synchronized (object) {
            this.zzab = true;
            this.zzp = null;
            this.zzv.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzc() {
        if (this.zzp == null) {
            return null;
        }
        try {
            this.zzu.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzs;
        Object object = this.zzv;
        synchronized (object) {
            this.zzv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza() {
        Object object = this.zzv;
        synchronized (object) {
            this.zzv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzny zzny2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzp == null) {
            zzahw.zzc((String)"SphericalVideoProcessor started with no output texture.");
            this.zzu.countDown();
            return;
        }
        zzanl zzanl2 = this;
        this.zzw = (EGL10)EGLContext.getEGL();
        zzanl2.zzx = zzanl2.zzw.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzanl2.zzx == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzanl2.zzw.eglInitialize(zzanl2.zzx, nArray)) {
                bl2 = false;
            } else {
                object2 = zzanl2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzanl)object2).zzw.eglChooseConfig(((zzanl)object2).zzx, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzanl2.zzy = zzanl2.zzw.eglCreateContext(zzanl2.zzx, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzanl2.zzy == null || zzanl2.zzy == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzanl2.zzz = zzanl2.zzw.eglCreateWindowSurface(zzanl2.zzx, (EGLConfig)object, (Object)zzanl2.zzp, null);
                        bl2 = zzanl2.zzz == null || zzanl2.zzz == EGL10.EGL_NO_SURFACE ? false : zzanl2.zzw.eglMakeCurrent(zzanl2.zzx, zzanl2.zzz, zzanl2.zzz, zzanl2.zzy);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzanl2 = this;
        zzny zzny3 = zzny2 = zzoi.zzdb;
        if (!((String)zzlc.zzf().zza(zzny3)).equals(zzny2.zzb())) {
            zzny3 = zzny2;
            string2 = (String)zzlc.zzf().zza(zzny3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzanl.zza(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzny3 = zzny2 = zzoi.zzdc;
            if (!((String)zzlc.zzf().zza(zzny3)).equals(zzny2.zzb())) {
                zzny3 = zzny2;
                string3 = (String)zzlc.zzf().zza(zzny3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzanl.zza(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzanl.zza("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzanl.zza("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzanl.zza("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzanl.zza("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzanl.zza("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzanl.zza("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzanl.zza("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzq = n;
        GLES20.glUseProgram((int)zzanl2.zzq);
        zzanl.zza("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzanl2.zzq, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzanl2.zzt);
        zzanl.zza("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzanl.zza("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzanl.zza("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzanl.zza("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzanl.zza("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzanl.zza("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzanl.zza("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzanl.zza("texParameteri");
        zzanl2.zzr = GLES20.glGetUniformLocation((int)zzanl2.zzq, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzanl2.zzr, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzq != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzw.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzahw.zzc((String)string6);
            zzbt.zzi().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zze();
            this.zzu.countDown();
            return;
        }
        this.zzo = new SurfaceTexture(n7);
        this.zzo.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzu.countDown();
        this.zzb.zza();
        try {
            this.zzaa = true;
            while (!this.zzab) {
                this.zzd();
                if (this.zzaa) {
                    zzanl2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzanl2.zzn, (int)zzanl2.zzm);
                    zzanl.zza("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzanl2.zzq, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzanl2.zzq, (String)"uFOVy");
                    if (zzanl2.zzn > zzanl2.zzm) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzanl2.zzm / (float)zzanl2.zzn));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzanl2.zzn / (float)zzanl2.zzm));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzaa = false;
                }
                try {
                    Object object3 = this.zzv;
                    synchronized (object3) {
                        if (!this.zzab && !this.zzaa && this.zzs == 0) {
                            this.zzv.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzahw.zze((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzahw.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbt.zzi().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzb.zzb();
            this.zzo.setOnFrameAvailableListener(null);
            this.zzo = null;
            this.zze();
        }
    }

    private final void zzd() {
        while (this.zzs > 0) {
            this.zzo.updateTexImage();
            --this.zzs;
        }
        if (this.zzb.zza(this.zzc)) {
            if (Float.isNaN(this.zzj)) {
                float[] fArray = this.zzc;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzc;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzj = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzanl.zzb(this.zzh, this.zzj + this.zzk);
        } else {
            zzanl.zza(this.zzc, -1.5707964f);
            zzanl.zzb(this.zzh, this.zzk);
        }
        zzanl.zza(this.zzd, 1.5707964f);
        zzanl.zza(this.zze, this.zzh, this.zzd);
        zzanl.zza(this.zzf, this.zzc, this.zze);
        zzanl.zza(this.zzg, this.zzl);
        zzanl.zza(this.zzi, this.zzg, this.zzf);
        GLES20.glUniformMatrix3fv((int)this.zzr, (int)1, (boolean)false, (float[])this.zzi, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzanl.zza("drawArrays");
        GLES20.glFinish();
        this.zzw.eglSwapBuffers(this.zzx, this.zzz);
    }

    public final void zza(float f, float f2) {
        float f3;
        float f4;
        if (this.zzn > this.zzm) {
            f4 = 1.7453293f * f / (float)this.zzn;
            f3 = 1.7453293f * f2 / (float)this.zzn;
        } else {
            f4 = 1.7453293f * f / (float)this.zzm;
            f3 = 1.7453293f * f2 / (float)this.zzm;
        }
        this.zzk -= f4;
        this.zzl -= f3;
        if (this.zzl < -1.5707964f) {
            this.zzl = -1.5707964f;
        }
        if (this.zzl > 1.5707964f) {
            this.zzl = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zza(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzanl.zza("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzanl.zza("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzanl.zza("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzanl.zza("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzanl.zza("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zze() {
        boolean bl = false;
        if (this.zzz != null && this.zzz != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzw.eglMakeCurrent(this.zzx, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzw.eglDestroySurface(this.zzx, this.zzz);
            this.zzz = null;
        }
        if (this.zzy != null) {
            bl |= this.zzw.eglDestroyContext(this.zzx, this.zzy);
            this.zzy = null;
        }
        if (this.zzx != null) {
            bl |= this.zzw.eglTerminate(this.zzx);
            this.zzx = null;
        }
        return bl;
    }

    private static void zza(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

