/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzanb;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzant
implements zzt<zzann> {
    private boolean zza;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzlc.zza();
                n2 = zzako.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzahw.zze((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzanb zzanb2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzahw.zze((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Object object2;
        Object object3;
        Map map2 = map;
        zzann zzann2 = (zzann)object;
        zzant zzant2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzahw.zze((String)"Action missing from video GMSG.");
            return;
        }
        if (zzahw.zza((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzahw.zzb((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzahw.zze((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzann2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzahw.zze((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzahw.zze((String)"No MIME types specified for decoder properties inspection.");
                zzanb.zza(zzann2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzahw.zze((String)"Video decoder properties available on API versions >= 16.");
                zzanb.zza(zzann2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzakm.zza(string3.trim()));
            }
            zzanb.zza(zzann2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzann2.zza();
        if (object3 == null) {
            zzahw.zze((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzann2.getContext();
            int n2 = zzant.zza(context, map2, "x", 0);
            int n3 = zzant.zza(context, map2, "y", 0);
            int n4 = zzant.zza(context, map2, "w", -1);
            int n5 = zzant.zza(context, map2, "h", -1);
            zzny zzny2 = zzoi.zzex;
            if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
                n4 = Math.min(n4, zzann2.zzk() - n2);
                n5 = Math.min(n5, zzann2.zzj() - n3);
            }
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzane)object3).zza() == null) {
                zzanm zzanm2 = new zzanm((String)map2.get("flags"));
                ((zzane)object3).zza(n2, n3, n4, n5, n, bl3, zzanm2);
                zzanb zzanb2 = ((zzane)object3).zza();
                if (zzanb2 != null) {
                    zzant.zza(zzanb2, map2);
                }
                return;
            }
            ((zzane)object3).zza(n2, n3, n4, n5);
            return;
        }
        zzanb zzanb3 = ((zzane)object3).zza();
        if (zzanb3 == null) {
            zzanb.zza(zzann2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzann2.getContext();
            int n = zzant.zza(context, map2, "x", 0);
            int n6 = zzant.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzanb3.zza(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = (String)map2.get("time");
            if (string4 == null) {
                zzahw.zze((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzanb3.zza(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzahw.zze((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzanb3.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzanb3.zzh();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzant.zza(zzanb3, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzanb3.zzk();
                return;
            }
            zzanb3.zzl();
            return;
        }
        if ("pause".equals(string2)) {
            zzanb3.zzi();
            return;
        }
        if ("play".equals(string2)) {
            zzanb3.zzj();
            return;
        }
        if ("show".equals(string2)) {
            zzanb3.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzanb3.zza((String)map2.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzann2.getContext();
            int n = zzant.zza(context, map2, "dx", 0);
            int n7 = zzant.zza(context, map2, "dy", 0);
            zzanb3.zza((float)n, (float)n7);
            if (!zzant2.zza) {
                zzann2.zzf();
                zzant2.zza = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = (String)map2.get("volume");
            if (string6 == null) {
                zzahw.zze((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzanb3.zza(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzahw.zze((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzanb3.zzm();
            return;
        }
        String string8 = String.valueOf(string2);
        zzahw.zze((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

