/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzabf;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzhm
extends Thread {
    private boolean zza = false;
    private boolean zzb = false;
    private boolean zzc = false;
    private final Object zzd;
    private final zzhh zze;
    private final zzabf zzf;
    private final int zzg;
    private final int zzh;
    private final int zzi;
    private final int zzj;
    private final int zzk;
    private final int zzl;
    private final int zzm;
    private final int zzn;
    private final String zzo;
    private final boolean zzp;

    public zzhm(zzhh zzhh2, zzabf zzabf2) {
        this.zze = zzhh2;
        this.zzf = zzabf2;
        this.zzd = new Object();
        zzny zzny2 = zzoi.zzan;
        this.zzh = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzao;
        this.zzi = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzap;
        this.zzj = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzaq;
        this.zzk = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzat;
        this.zzl = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzav;
        this.zzm = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzaw;
        this.zzn = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzar;
        this.zzg = (Integer)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzay;
        this.zzo = (String)zzlc.zzf().zza(zzny2);
        zzny2 = zzoi.zzba;
        this.zzp = (Boolean)zzlc.zzf().zza(zzny2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza() {
        Object object = this.zzd;
        synchronized (object) {
            if (this.zza) {
                zzahw.zzb((String)"Content hash thread already started, quiting...");
                return;
            }
            this.zza = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzhm.zze()) {
                    object = zzbt.zzh().zza();
                    if (object == null) {
                        zzahw.zzb((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzf();
                    } else {
                        Activity activity = object;
                        zzhm zzhm2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbt.zzi().zza(exception, "ContentFetchTask.extractContent");
                                zzahw.zzb((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzhm zzhm3 = zzhm2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzhn(zzhm3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzahw.zzb((String)"ContentFetchTask: sleeping");
                    this.zzf();
                }
                Thread.sleep(this.zzg * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzahw.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzf.zza((Throwable)exception, "ContentFetchTask.run");
            }
            object = this.zzd;
            synchronized (object) {
                while (this.zzb) {
                    try {
                        zzahw.zzb((String)"ContentFetchTask: waiting");
                        this.zzd.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zza(View view) {
        try {
            zzhg zzhg2 = new zzhg(this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, this.zzn);
            zzhq zzhq2 = this.zza(view, zzhg2);
            zzhg2.zzh();
            if (zzhq2.zza == 0 && zzhq2.zzb == 0) {
                return;
            }
            if (zzhq2.zzb == 0 && zzhg2.zzj() == 0) {
                return;
            }
            if (zzhq2.zzb == 0 && this.zze.zza(zzhg2)) {
                return;
            }
            this.zze.zzc(zzhg2);
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzf.zza((Throwable)exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zze() {
        try {
            Context context = zzbt.zzh().zzb();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbt.zzi().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzhq zza(@Nullable View view, zzhg zzhg2) {
        Object object;
        if (view == null) {
            return new zzhq(this, 0, 0);
        }
        Context context = zzbt.zzh().zzb();
        if (context != null) {
            object = zzoi.zzax;
            int n = context.getResources().getIdentifier((String)zzlc.zzf().zza(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzo) && string2 != null && string2.equals(this.zzo)) {
                return new zzhq(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzhg2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzhq(this, 1, 0);
            }
            return new zzhq(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzaof)) {
            boolean bl2;
            zzhg2.zzg();
            zzhg zzhg3 = zzhg2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzs.zze()) {
                bl2 = false;
            } else {
                zzhg3.zzg();
                webView.post((Runnable)new zzho((zzhm)object, zzhg3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzhq(this, 0, 1);
            }
            return new zzhq(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzhq zzhq2 = this.zza(viewGroup.getChildAt(i), zzhg2);
                n += zzhq2.zza;
                n2 += zzhq2.zzb;
            }
            return new zzhq(this, n, n2);
        }
        return new zzhq(this, 0, 0);
    }

    final void zza(zzhg zzhg2, WebView webView, String string2, boolean bl) {
        zzhg2.zzf();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzp && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzhg2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzhg2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzhg2.zza()) {
                this.zze.zzb(zzhg2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzahw.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzf.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzhg zzb() {
        return this.zze.zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc() {
        Object object = this.zzd;
        synchronized (object) {
            this.zzb = false;
            this.zzd.notifyAll();
            zzahw.zzb((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzf() {
        Object object = this.zzd;
        synchronized (object) {
            boolean bl = this.zzb = true;
            zzahw.zzb((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzd() {
        return this.zzb;
    }
}

