/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaan;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaip;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalg;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzpw;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqt;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public class zzpz
implements zzpv {
    private final Object zzb = new Object();
    private final zzpw zzc;
    private final Context zzd;
    @Nullable
    private final JSONObject zze;
    @Nullable
    private final zzaan zzf;
    @Nullable
    private final zzpx zzg;
    private final zzcv zzh;
    @Nullable
    private final zzala zzi;
    boolean zza;
    @Nullable
    private String zzj;
    @Nullable
    private zzagt zzk;
    private WeakReference<View> zzl = null;

    public zzpz(Context context, zzpw zzpw2, @Nullable zzaan zzaan2, zzcv zzcv2, @Nullable JSONObject jSONObject, @Nullable zzpx zzpx2, @Nullable zzala zzala2, @Nullable String string2) {
        this.zzd = context;
        this.zzc = zzpw2;
        this.zzf = zzaan2;
        this.zzh = zzcv2;
        this.zze = jSONObject;
        this.zzg = zzpx2;
        this.zzi = zzala2;
        this.zzj = string2;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zzph zzph2 = this.zzg.zzm();
        if (zzph2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zzph2.zzh()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzpi zzpi2 = new zzpi(this.zzd, zzph2, layoutParams);
        zzpi2.setOnClickListener(onClickListener);
        zzny zzny2 = zzoi.zzew;
        zzpi2.setContentDescription((CharSequence)zzlc.zzf().zza(zzny2));
        return zzpi2;
    }

    @Override
    public boolean zza() {
        zzph zzph2 = this.zzg.zzm();
        return zzph2 != null && zzph2.zzi();
    }

    @Override
    public boolean zzb() {
        return this.zze != null && this.zze.optBoolean("allow_pub_owned_ad_view", false);
    }

    private final boolean zza(String string2) {
        JSONObject jSONObject = this.zze == null ? null : this.zze.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, String string2, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zze(view2);
        JSONObject jSONObject3 = zzpz.zzf(view2);
        JSONObject jSONObject4 = this.zzg(view2);
        JSONObject jSONObject5 = null;
        try {
            JSONObject jSONObject6 = zzbt.zze().zza(bundle, null);
            jSONObject5 = new JSONObject();
            jSONObject5.put("click_point", (Object)jSONObject6);
            jSONObject5.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbq.zzb((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            Map<String, WeakReference<View>> map2 = map;
            synchronized (map2) {
                for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                    View view3 = (View)entry.getValue().get();
                    if (!view.equals(view3)) continue;
                    this.zza(view, entry.getKey(), bundle, map, view2);
                    return;
                }
            }
        }
        if ("6".equals(this.zzg.zzk())) {
            this.zza(view, "3099", bundle, map, view2);
            return;
        }
        if ("2".equals(this.zzg.zzk())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzg.zzk())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void zzb(Bundle bundle) {
        if (bundle == null) {
            zzahw.zzb((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zza("click_reporting")) {
            zzahw.zzc((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string2 = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbt.zze().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, String string2, JSONObject jSONObject5, JSONObject jSONObject6) {
        zzbq.zzb((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zze);
            if (jSONObject2 != null) {
                jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject7.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject5 != null) {
                jSONObject7.put("click_signal", (Object)jSONObject5);
            }
            if (jSONObject3 != null) {
                jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            }
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", (Object)this.zzg.zzk());
            zzbt.zzg();
            jSONObject8.put("is_privileged_process", zzaip.zze());
            jSONObject8.put("has_custom_click_handler", this.zzc.zzb(this.zzg.zzl()) != null);
            jSONObject7.put("has_custom_click_handler", this.zzc.zzb(this.zzg.zzl()) != null);
            try {
                JSONObject jSONObject9 = this.zze.optJSONObject("tracking_urls_and_actions");
                if (jSONObject9 == null) {
                    jSONObject9 = new JSONObject();
                }
                String string3 = jSONObject9.optString("click_string");
                String string4 = this.zzh.zza().zza(this.zzd, string3, view);
                jSONObject8.put("click_signals", (Object)string4);
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject7.put("click", (Object)jSONObject8);
            if (jSONObject6 != null) {
                jSONObject7.put("provided_signals", (Object)jSONObject6);
            }
            jSONObject7.put("ads_id", (Object)this.zzj);
            zzalg.zza(this.zzf.zzb(jSONObject7), "NativeAdEngineImpl.performClick");
            return;
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zza(MotionEvent motionEvent) {
        this.zzh.zza(motionEvent);
    }

    @Override
    public final void zzc(Bundle bundle) {
        if (bundle == null) {
            zzahw.zzb((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zza("touch_reporting")) {
            zzahw.zzc((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzh.zza().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zza) {
                return;
            }
            if (zzpz.zzc(view)) {
                this.zza(view, map);
                return;
            }
            zzny zzny2 = zzoi.zzfb;
            if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue() && map != null) {
                Map<String, WeakReference<View>> map2 = map;
                synchronized (map2) {
                    Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        View view2 = (View)iterator.next().getValue().get();
                        if (view2 == null || !zzpz.zzc(view2)) continue;
                        this.zza(view, map);
                        return;
                    }
                }
            }
            return;
        }
    }

    private static boolean zzc(View view) {
        return view.isShown() && view.getGlobalVisibleRect(new Rect(), null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zze(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzpz.zzf(view);
        JSONObject jSONObject4 = this.zzg(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, jSONObject4, null);
    }

    @Override
    public final boolean zza(Bundle bundle) {
        if (!this.zza("impression_reporting")) {
            zzahw.zzc((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbt.zze().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbq.zzb((String)"recordImpression must be called on the main UI thread.");
        if (this.zza) {
            return true;
        }
        this.zza = true;
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zze);
            jSONObject6.put("ads_id", (Object)this.zzj);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            }
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            zzalg.zza(this.zzf.zzc(jSONObject6), "NativeAdEngineImpl.recordImpression");
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzc.zza(this);
        this.zzc.zzu();
        return true;
    }

    @Override
    public final View zzh() {
        if (this.zzl != null) {
            return (View)this.zzl.get();
        }
        return null;
    }

    @Override
    public final void zzb(View view) {
        this.zzl = new WeakReference<View>(view);
    }

    @Override
    public final void zza(View view) {
        zzcr zzcr2;
        zzny zzny2 = zzoi.zzdz;
        if (!((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            return;
        }
        if (this.zzh != null && (zzcr2 = this.zzh.zza()) != null) {
            zzcr2.zza(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        Map<String, WeakReference<View>> map3;
        zzny zzny2 = zzoi.zzeu;
        if (!((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map != null) {
            map3 = map;
            synchronized (map3) {
                iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                    view2.setClickable(true);
                    view2.setOnClickListener(onClickListener);
                }
            }
        }
        if (map2 != null) {
            map3 = map2;
            synchronized (map3) {
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzny zzny2 = zzoi.zzet;
        if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                View view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(null);
                view2.setClickable(false);
                view2.setOnClickListener(null);
            }
            return;
        }
    }

    public zzaof zze() throws zzaop {
        if (this.zze == null || this.zze.optJSONObject("overlay") == null) {
            return null;
        }
        zzpz zzpz2 = this;
        zzala zzala2 = zzpz2.zzi;
        zzcv zzcv2 = zzpz2.zzh;
        zzko zzko2 = zzko.zza((Context)zzpz2.zzd);
        Context context = zzpz2.zzd;
        zzaof zzaof2 = zzbt.zzf().zza(context, zzaqa.zza(zzko2), zzko2.zza, false, false, zzcv2, zzala2, null, null, null, zziu.zza());
        if (zzaof2 != null) {
            zzaof2.zzm().setVisibility(8);
            new zzqb(zzaof2).zza(this.zzf);
        }
        return zzaof2;
    }

    public final void zza(Map<String, WeakReference<View>> map) {
        if (this.zzg.zzo() != null) {
            if ("2".equals(this.zzg.zzk())) {
                zzbt.zzi().zzl().zza(this.zzc.zzv(), this.zzg.zzk(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzg.zzk())) {
                zzbt.zzi().zzl().zza(this.zzc.zzv(), this.zzg.zzk(), map.containsKey("1009"));
            }
        }
    }

    public final boolean zzb(View view, zzpt zzpt2) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        View view2 = this.zzg.zzo();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzc.zza(zzpt2);
            return true;
        }
        return false;
    }

    @Override
    public final void zza(View view, zzpt zzpt2) {
        Object object;
        zzqs zzqs2;
        if (this.zzb(view, zzpt2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzg instanceof zzpy)) {
            return;
        }
        zzpy zzpy2 = (zzpy)this.zzg;
        if (zzpy2.zzb() != null && zzpy2.zzb().size() > 0 && (zzqs2 = (object = zzpy2.zzb().get(0)) instanceof IBinder ? zzqt.zza((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzqs2.zza();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zza((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzpz)object).zzd);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzahw.zze((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zzg() {
        this.zzc.zzaq();
    }

    @Override
    public void zzf() {
        this.zzf.zza();
    }

    @Override
    public final Context zzi() {
        return this.zzd;
    }

    private static int[] zzd(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zza(int n) {
        zzlc.zza();
        return zzako.zzb((Context)this.zzd, (int)n);
    }

    private final JSONObject zza(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zza(rect.right - rect.left));
        jSONObject.put("height", this.zza(rect.bottom - rect.top));
        jSONObject.put("x", this.zza(rect.left));
        jSONObject.put("y", this.zza(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zze(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzpz.zzd(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zza(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zza(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zza(nArray[0]));
            jSONObject3.put("y", this.zza(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zza(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zza(nArray[0]));
                jSONObject2.put("y", this.zza(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzahw.zze((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzf(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbt.zze();
            int n = zzaij.zzd(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzg(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbt.zze();
            jSONObject.put("can_show_on_lock_screen", zzaij.zzc(view));
            zzbt.zze();
            jSONObject.put("is_keyguard_locked", zzaij.zzj(this.zzd));
        }
        catch (JSONException jSONException) {
            zzahw.zze((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzpz.zzd(view);
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = zzpz.zzd(view2);
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = new JSONObject();
                try {
                    JSONObject jSONObject4;
                    jSONObject3.put("width", this.zza(view2.getMeasuredWidth()));
                    jSONObject3.put("height", this.zza(view2.getMeasuredHeight()));
                    jSONObject3.put("x", this.zza(nArray2[0] - nArray[0]));
                    jSONObject3.put("y", this.zza(nArray2[1] - nArray[1]));
                    jSONObject3.put("relative_to", (Object)"ad_view");
                    jSONObject2.put("frame", (Object)jSONObject3);
                    Rect rect = new Rect();
                    if (view2.getLocalVisibleRect(rect)) {
                        jSONObject4 = this.zza(rect);
                    } else {
                        jSONObject4 = new JSONObject();
                        jSONObject4.put("width", 0);
                        jSONObject4.put("height", 0);
                        jSONObject4.put("x", this.zza(nArray2[0] - nArray[0]));
                        jSONObject4.put("y", this.zza(nArray2[1] - nArray[1]));
                        jSONObject4.put("relative_to", (Object)"ad_view");
                    }
                    jSONObject2.put("visible_bounds", (Object)jSONObject4);
                    if (view2 instanceof TextView) {
                        TextView textView = (TextView)view2;
                        jSONObject2.put("text_color", textView.getCurrentTextColor());
                        jSONObject2.put("font_size", (double)textView.getTextSize());
                        jSONObject2.put("text", (Object)textView.getText());
                    }
                    jSONObject.put(entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzahw.zze((String)"Unable to get asset views information");
                }
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzagt zzj() {
        if (zzbt.zzaa().zzc(this.zzd)) {
            if (this.zzk == null) {
                this.zzk = new zzagt(this.zzd, this.zzc.zzv());
            }
            return this.zzk;
        }
        return null;
    }
}

