/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzye;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyo;
import java.util.Map;
import java.util.Set;

@zzabh
@Hide
public final class zzyd
extends zzyn {
    private static Set<String> zza = com.google.android.gms.common.util.zzf.zza((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzb = "top-right";
    private boolean zzc = true;
    private int zzd = 0;
    private int zze = 0;
    private int zzf = -1;
    private int zzg = 0;
    private int zzh = 0;
    private int zzi = -1;
    private final Object zzj = new Object();
    private final zzaof zzk;
    private final Activity zzl;
    private zzaqa zzm;
    private ImageView zzn;
    private LinearLayout zzo;
    private zzyo zzp;
    private PopupWindow zzq;
    private RelativeLayout zzr;
    private ViewGroup zzs;

    public zzyd(zzaof zzaof2, zzyo zzyo2) {
        super(zzaof2, "resize");
        this.zzk = zzaof2;
        this.zzl = zzaof2.zzd();
        this.zzp = zzyo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Map<String, String> map) {
        Object object = this.zzj;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzl == null) {
                this.zza("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzk.zzt() == null) {
                this.zza("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzk.zzt().zzd()) {
                this.zza("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzk.zzy()) {
                this.zza("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzyd zzyd2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbt.zze();
                zzyd2.zzi = zzaij.zzb(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbt.zze();
                zzyd2.zzf = zzaij.zzb(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbt.zze();
                zzyd2.zzg = zzaij.zzb(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbt.zze();
                zzyd2.zzh = zzaij.zzb(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzyd2.zzc = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzyd2.zzb = string2;
            }
            zzyd2 = this;
            if (!(zzyd2.zzi >= 0 && zzyd2.zzf >= 0)) {
                this.zza("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzl.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zza("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzb();
            if (nArray == null) {
                this.zza("Resize location out of screen or close button is not visible.");
                return;
            }
            zzlc.zza();
            int n = zzako.zza((Context)this.zzl, (int)this.zzi);
            zzlc.zza();
            int n2 = zzako.zza((Context)this.zzl, (int)this.zzf);
            ViewParent viewParent = this.zzk.zzm().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzk.zzm());
                if (this.zzq == null) {
                    this.zzs = (ViewGroup)viewParent;
                    zzbt.zze();
                    bitmap = zzaij.zza(this.zzk.zzm());
                    this.zzn = new ImageView((Context)this.zzl);
                    this.zzn.setImageBitmap(bitmap);
                    this.zzm = this.zzk.zzt();
                    this.zzs.addView((View)this.zzn);
                } else {
                    this.zzq.dismiss();
                }
            } else {
                this.zza("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzr = new RelativeLayout((Context)this.zzl);
            this.zzr.setBackgroundColor(0);
            this.zzr.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbt.zze();
            this.zzq = zzaij.zza((View)this.zzr, n, n2, false);
            this.zzq.setOutsideTouchable(true);
            this.zzq.setTouchable(true);
            this.zzq.setClippingEnabled(!this.zzc);
            this.zzr.addView(this.zzk.zzm(), -1, -1);
            this.zzo = new LinearLayout((Context)this.zzl);
            zzlc.zza();
            int n3 = zzako.zza((Context)this.zzl, (int)50);
            zzlc.zza();
            bitmap = new RelativeLayout.LayoutParams(n3, zzako.zza((Context)this.zzl, (int)50));
            switch (this.zzb) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzo.setOnClickListener((View.OnClickListener)new zzye(this));
            this.zzo.setContentDescription((CharSequence)"Close button");
            this.zzr.addView((View)this.zzo, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzlc.zza();
                int n4 = zzako.zza((Context)this.zzl, (int)nArray[0]);
                zzlc.zza();
                this.zzq.showAtLocation(view, 0, n4, zzako.zza((Context)this.zzl, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zza(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzr.removeView(this.zzk.zzm());
                if (this.zzs != null) {
                    this.zzs.removeView((View)this.zzn);
                    this.zzs.addView(this.zzk.zzm());
                    this.zzk.zza(this.zzm);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzyd2 = this;
            if (zzyd2.zzp != null) {
                zzyd2.zzp.zza(n6, n5, zzyd2.zzi, zzyd2.zzf);
            }
            this.zzk.zza(zzaqa.zza(n, n2));
            this.zzb(nArray[0], nArray[1]);
            this.zzc("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(boolean bl) {
        Object object = this.zzj;
        synchronized (object) {
            if (this.zzq != null) {
                this.zzq.dismiss();
                this.zzr.removeView(this.zzk.zzm());
                if (this.zzs != null) {
                    this.zzs.removeView((View)this.zzn);
                    this.zzs.addView(this.zzk.zzm());
                    this.zzk.zza(this.zzm);
                }
                if (bl) {
                    this.zzc("default");
                    if (this.zzp != null) {
                        this.zzp.zzas();
                    }
                }
                this.zzq = null;
                this.zzr = null;
                this.zzs = null;
                this.zzo = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzb() {
        zzyd zzyd2 = this;
        int[] nArray = zzbt.zze().zzb(zzyd2.zzl);
        int[] nArray2 = zzbt.zze().zzc(zzyd2.zzl);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzyd2.zzi < 50 || zzyd2.zzi > n) {
            zzahw.zze((String)"Width is too small or too large.");
            return null;
        }
        if (zzyd2.zzf < 50 || zzyd2.zzf > n2) {
            zzahw.zze((String)"Height is too small or too large.");
            return null;
        }
        if (zzyd2.zzf == n2 && zzyd2.zzi == n) {
            zzahw.zze((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzyd2.zzc) {
            int n3;
            int n4;
            switch (zzyd2.zzb) {
                case "top-left": {
                    n4 = zzyd2.zzd + zzyd2.zzg;
                    n3 = zzyd2.zze + zzyd2.zzh;
                    break;
                }
                case "top-center": {
                    n4 = zzyd2.zzd + zzyd2.zzg + zzyd2.zzi / 2 - 25;
                    n3 = zzyd2.zze + zzyd2.zzh;
                    break;
                }
                case "center": {
                    n4 = zzyd2.zzd + zzyd2.zzg + zzyd2.zzi / 2 - 25;
                    n3 = zzyd2.zze + zzyd2.zzh + zzyd2.zzf / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzyd2.zzd + zzyd2.zzg;
                    n3 = zzyd2.zze + zzyd2.zzh + zzyd2.zzf - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzyd2.zzd + zzyd2.zzg + zzyd2.zzi / 2 - 25;
                    n3 = zzyd2.zze + zzyd2.zzh + zzyd2.zzf - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzyd2.zzd + zzyd2.zzg + zzyd2.zzi - 50;
                    n3 = zzyd2.zze + zzyd2.zzh + zzyd2.zzf - 50;
                    break;
                }
                default: {
                    n4 = zzyd2.zzd + zzyd2.zzg + zzyd2.zzi - 50;
                    n3 = zzyd2.zze + zzyd2.zzh;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzc) {
            return new int[]{this.zzd + this.zzg, this.zze + this.zzh};
        }
        int[] nArray3 = zzbt.zze().zzb(this.zzl);
        int[] nArray4 = zzbt.zze().zzc(this.zzl);
        int n5 = nArray3[0];
        int n6 = this.zzd + this.zzg;
        int n7 = this.zze + this.zzh;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzi > n5) {
            n6 = n5 - this.zzi;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzf <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzf;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzd = n;
            this.zze = n2;
            if (this.zzq != null && bl) {
                int[] nArray = this.zzb();
                if (nArray != null) {
                    zzlc.zza();
                    int n3 = zzako.zza((Context)this.zzl, (int)nArray[0]);
                    zzlc.zza();
                    this.zzq.update(n3, zzako.zza((Context)this.zzl, (int)nArray[1]), this.zzq.getWidth(), this.zzq.getHeight());
                    this.zzb(nArray[0], nArray[1]);
                } else {
                    this.zza(true);
                }
            }
            return;
        }
    }

    private final void zzb(int n, int n2) {
        int n3 = zzbt.zze().zzc(this.zzl)[0];
        this.zza(n, n2 - n3, this.zzi, this.zzf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zza() {
        Object object = this.zzj;
        synchronized (object) {
            return this.zzq != null;
        }
    }

    public final void zza(int n, int n2) {
        this.zzd = n;
        this.zze = n2;
    }
}

