/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.gmsg.HttpClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.gmsg.zzy;
import com.google.android.gms.ads.internal.js.zzaa;
import com.google.android.gms.ads.internal.js.zzc;
import com.google.android.gms.ads.internal.js.zzn;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabj;
import com.google.android.gms.internal.zzacf;
import com.google.android.gms.internal.zzacg;
import com.google.android.gms.internal.zzacj;
import com.google.android.gms.internal.zzadb;
import com.google.android.gms.internal.zzadc;
import com.google.android.gms.internal.zzadf;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzadi;
import com.google.android.gms.internal.zzadl;
import com.google.android.gms.internal.zzads;
import com.google.android.gms.internal.zzaea;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzada
extends zzahs {
    private static long zzcuy = TimeUnit.SECONDS.toMillis(10L);
    private static final Object sLock = new Object();
    private static boolean zzcuz = false;
    private static zzn zzcql = null;
    private static HttpClient zzcva = null;
    private static zzy zzcvb = null;
    private static zzt<Object> zzcvc = null;
    private final zzabj zzcre;
    private final zzacg zzcrf;
    private final Object zzcoe = new Object();
    private final Context mContext;
    private zzaa zzcvd;
    private zziz zzcrh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzada(Context context, zzacg zzacg2, zzabj zzabj2, zziz zziz2) {
        super(true);
        this.zzcre = zzabj2;
        this.mContext = context;
        this.zzcrf = zzacg2;
        this.zzcrh = zziz2;
        Object object = sLock;
        synchronized (object) {
            if (!zzcuz) {
                zzcvb = new zzy();
                zzcva = new HttpClient(context.getApplicationContext(), zzacg2.zzatz);
                zzcvc = new zzadi();
                zzny zzny2 = zzoi.zzblc;
                zzcql = new zzn(this.mContext.getApplicationContext(), this.zzcrf.zzatz, (String)zzlc.zzio().zzd(zzny2), new zzadh(), new zzadg());
                zzcuz = true;
            }
            return;
        }
    }

    protected static void zzb(zzc zzc2) {
        zzc2.zza("/loadAd", zzcvb);
        zzc2.zza("/fetchHttpRequest", zzcva);
        zzc2.zza("/invalidRequest", zzcvc);
    }

    protected static void zzc(zzc zzc2) {
        zzc2.zzb("/loadAd", zzcvb);
        zzc2.zzb("/fetchHttpRequest", zzcva);
        zzc2.zzb("/invalidRequest", zzcvc);
    }

    @Override
    public final void zzdo() {
        zzahw.zzby((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzbt.zzfh().zzz(this.mContext);
        zzacf zzacf2 = new zzacf(this.zzcrf, -1L, zzbt.zzfh().zzx(this.mContext), zzbt.zzfh().zzy(this.mContext), string2);
        zzbt.zzfh().zzg(this.mContext, string2);
        zzacj zzacj2 = this.zzc(zzacf2);
        long l = zzbt.zzes().elapsedRealtime();
        zzahe zzahe2 = new zzahe(zzacf2, zzacj2, null, null, zzacj2.errorCode, l, zzacj2.zzcts, null, this.zzcrh);
        zzako.zzaju.post((Runnable)new zzadb(this, zzahe2));
    }

    private final zzacj zzc(zzacf zzacf2) {
        JSONObject jSONObject;
        zzbt.zzel();
        String string2 = zzaij.zzrc();
        JSONObject jSONObject2 = this.zza(zzacf2, string2);
        if (jSONObject2 == null) {
            return new zzacj(0);
        }
        long l = zzbt.zzes().elapsedRealtime();
        Future<JSONObject> future = zzcvb.zzas(string2);
        zzako.zzaju.post((Runnable)new zzadc(this, jSONObject2, string2));
        long l2 = zzcuy - (zzbt.zzes().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzacj(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzacj(2);
        }
        catch (ExecutionException executionException) {
            return new zzacj(0);
        }
        if (jSONObject == null) {
            return new zzacj(-1);
        }
        zzacj zzacj2 = zzads.zza(this.mContext, zzacf2, jSONObject.toString());
        if (zzacj2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzacj2.body)) {
            return new zzacj(3);
        }
        return zzacj2;
    }

    private final JSONObject zza(zzacf zzacf2, String string2) {
        Bundle bundle = zzacf2.zzcrv.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzaea zzaea2 = null;
        try {
            zzaea2 = zzbt.zzew().zzo(this.mContext).get();
        }
        catch (Exception exception) {
            zzahw.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        Object object = zzacf2;
        zzadl zzadl2 = new zzadl();
        new zzadl().zzcvm = object;
        object = zzaea2;
        v0.zzcvn = object;
        JSONObject jSONObject = zzads.zza(this.mContext, zzadl2);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzahw.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzbt.zzel().zzq(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzcoe;
        synchronized (object) {
            zzako.zzaju.post((Runnable)new zzadf(this));
            return;
        }
    }

    static /* synthetic */ zzy zzoc() {
        return zzcvb;
    }

    static /* synthetic */ zzabj zza(zzada zzada2) {
        return zzada2.zzcre;
    }

    static /* synthetic */ zzaa zzb(zzada zzada2) {
        return zzada2.zzcvd;
    }

    static /* synthetic */ zzaa zza(zzada zzada2, zzaa zzaa2) {
        zzada2.zzcvd = zzaa2;
        return zzada2.zzcvd;
    }

    static /* synthetic */ zzn zzod() {
        return zzcql;
    }
}

