/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzalu;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzabh
@Hide
public class zzamd<T>
implements zzalt<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdka;
    private boolean zzdkb;
    private boolean zzcjn;
    private final zzalu zzdkc = new zzalu();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdkc.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcjn) {
                return;
            }
            if (this.zzsh()) {
                zzbt.zzep().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdkb = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdkc.zzsf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcjn) {
                return;
            }
            if (this.zzsh()) {
                zzbt.zzep().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdka = throwable;
            this.mLock.notifyAll();
            this.zzdkc.zzsf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzsh()) {
                this.mLock.wait();
            }
            if (this.zzdka != null) {
                throw new ExecutionException(this.zzdka);
            }
            if (this.zzcjn) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzsh()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdka != null) {
                throw new ExecutionException(this.zzdka);
            }
            if (!this.zzdkb) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzcjn) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsh()) {
                return false;
            }
            this.zzcjn = true;
            this.zzdkb = true;
            this.mLock.notifyAll();
            this.zzdkc.zzsf();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcjn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsh();
        }
    }

    private final boolean zzsh() {
        return this.zzdka != null || this.zzdkb;
    }
}

