/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbm;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaox;
import com.google.android.gms.internal.zzapp;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zzapz;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqb;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzaqg;
import com.google.android.gms.internal.zzaqh;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzyn;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
final class zzaqe
extends zzaqh
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzaof {
    @Nullable
    private final zzcv zzbyz;
    private final zzala zzapq;
    private final zzbm zzdqn;
    private final zzv zzanp;
    private zzaqb zzdsr;
    private zzd zzdqq;
    private zzaqa zzdqr;
    private String zzalv;
    private boolean zzdqs;
    private boolean zzdqt;
    private boolean zzdqu;
    private boolean zzdqv;
    private int zzdqw;
    private boolean zzdqx = true;
    private boolean zzdqy = false;
    private String zzcwj = "";
    private zzaou zzdqz;
    private boolean zzdra;
    private boolean zzdrb;
    private zzpt zzdrc;
    private int zzdrd;
    private int zzdre;
    private zzot zzdrf;
    private zzot zzdnt;
    private zzot zzdrg;
    private zzou zzdrh;
    private WeakReference<View.OnClickListener> zzdri;
    private zzd zzdrj;
    private boolean zzdrk;
    private zzakn zzavk;
    private int zzclz = -1;
    private int zzcly = -1;
    private int zzcmb = -1;
    private int zzcmc = -1;
    private float zzdss;
    private Map<String, zzany> zzdrl;
    private final WindowManager zzavz;

    static zzaqe zzc(Context context, zzaqa zzaqa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzala zzala2, zzov zzov2, zzbm zzbm2, zzv zzv2, zziu zziu2) {
        zzapz zzapz2 = new zzapz(context);
        return new zzaqe(zzapz2, zzaqa2, string2, bl, bl2, zzcv2, zzala2, zzov2, zzbm2, zzv2, zziu2);
    }

    private zzaqe(zzapz zzapz2, zzaqa zzaqa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzala zzala2, zzov zzov2, zzbm zzbm2, zzv zzv2, zziu zziu2) {
        super(zzapz2);
        this.zzdqr = zzaqa2;
        this.zzalv = string2;
        this.zzdqu = bl;
        this.zzdqw = -1;
        this.zzbyz = zzcv2;
        this.zzapq = zzala2;
        this.zzdqn = zzbm2;
        this.zzanp = zzv2;
        this.zzavz = (WindowManager)this.getContext().getSystemService("window");
        this.zzavk = new zzakn(this.zzvo().zztj(), (View)this, this, null);
        zzbt.zzel().zza((Context)zzapz2, zzala2.zzcu, this.getSettings());
        this.setDownloadListener(this);
        this.zzdss = this.zzvo().getResources().getDisplayMetrics().density;
        this.zzvd();
        if (zzs.zzant()) {
            this.addJavascriptInterface(zzaox.zzl(this), "googleAdsJsInterface");
        }
        zzov zzov3 = zzov2;
        zzaqe zzaqe2 = this;
        zzaqe2.zzvh();
        zzaqe2.zzdrh = new zzou(new zzov(true, "make_wv", zzaqe2.zzalv));
        zzaqe2.zzdrh.zzjn().zzc(zzov3);
        zzaqe2.zzdnt = zzoo.zzb(zzaqe2.zzdrh.zzjn());
        zzaqe2.zzdrh.zza("native:view_create", zzaqe2.zzdnt);
        zzaqe2.zzdrg = null;
        zzaqe2.zzdrf = null;
        zzbt.zzen().zzat((Context)zzapz2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzaqb) {
            this.zzdsr = (zzaqb)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzv zzbo() {
        return this.zzanp;
    }

    private final boolean zzva() {
        int n;
        int n2;
        if (!this.zzdsr.zzfz() && !this.zzdsr.zzuo()) {
            return false;
        }
        zzbt.zzel();
        DisplayMetrics displayMetrics = zzaij.zza(this.zzavz);
        zzlc.zzij();
        int n3 = zzako.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzlc.zzij();
        int n4 = zzako.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzvo().zztj();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbt.zzel();
            int[] nArray = zzaij.zzf(activity);
            zzlc.zzij();
            n2 = zzako.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzlc.zzij();
            n = zzako.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzcly == n3 && this.zzclz == n4 && this.zzcmb == n2 && this.zzcmc == n) {
            return false;
        }
        boolean bl = this.zzcly != n3 || this.zzclz != n4;
        this.zzcly = n3;
        this.zzclz = n4;
        this.zzcmb = n2;
        this.zzcmc = n;
        new zzyn(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzavz.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbt.zzel().zzq(map);
        }
        catch (JSONException jSONException) {
            zzahw.zzcz((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zzc(String string2, String string3, @Nullable String string4) {
        if (!this.isDestroyed()) {
            zzny zzny2 = zzoi.zzbow;
            String string5 = (Boolean)zzlc.zzio().zzd(zzny2) != false ? zzapp.zzb(string3, zzapp.zzvi()) : string3;
            super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
            return;
        }
        zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    protected final synchronized void zzdj(String string2) {
        if (!this.isDestroyed()) {
            super.zzdj(string2);
            return;
        }
        zzahw.zzcz((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzaqe zzaqe2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        ((zzaqh)zzaqe2).zzdj(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzahw.zzby((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        ((zzaqh)this).zzdj(stringBuilder.toString());
    }

    @Override
    public final void zztt() {
        this.zzvc();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapq.zzcu);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzag(int n) {
        if (n == 0) {
            zzaqe zzaqe2 = this;
            zzoo.zza(zzaqe2.zzdrh.zzjn(), zzaqe2.zzdnt, "aebb2");
        }
        this.zzvc();
        if (this.zzdrh.zzjn() != null) {
            this.zzdrh.zzjn().zzf("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzapq.zzcu);
        this.zza("onhide", hashMap);
    }

    private final void zzvc() {
        zzoo.zza(this.zzdrh.zzjn(), this.zzdnt, "aeh2");
    }

    @Override
    public final void zznn() {
        if (this.zzdrf == null) {
            zzoo.zza(this.zzdrh.zzjn(), this.zzdnt, "aes2");
            this.zzdrf = zzoo.zzb(this.zzdrh.zzjn());
            this.zzdrh.zza("native:view_show", this.zzdrf);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapq.zzcu);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zztu() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzbt.zzfj().zzdq()));
        hashMap.put("app_volume", String.valueOf(zzbt.zzfj().zzdp()));
        hashMap.put("device_volume", String.valueOf(zzaja.zzav(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final synchronized zzd zztw() {
        return this.zzdqq;
    }

    @Override
    public final synchronized zzd zztx() {
        return this.zzdrj;
    }

    @Override
    public final synchronized zzaqa zzty() {
        return this.zzdqr;
    }

    @Override
    public final synchronized String zztz() {
        return this.zzalv;
    }

    @Override
    public final zzapu zzua() {
        return this.zzdsr;
    }

    @Override
    public final synchronized boolean zzub() {
        return this.zzdqs;
    }

    @Override
    public final zzcv zzuc() {
        return this.zzbyz;
    }

    @Override
    public final zzala zztl() {
        return this.zzapq;
    }

    @Override
    public final synchronized boolean zzud() {
        return this.zzdqu;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbt.zzel();
            zzaij.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzahw.zzby((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdsr.zzuo()) {
            zzaqe zzaqe2 = this;
            synchronized (zzaqe2) {
                if (this.zzdrc != null) {
                    this.zzdrc.zzc(motionEvent);
                }
            }
        } else if (this.zzbyz != null) {
            this.zzbyz.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzny zzny2 = zzoi.zzbou;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzdqu || this.zzdqr.zzvm()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzdqr.zzvn()) {
            float f = 0.0f;
            zzaou zzaou2 = this.zzth();
            if (zzaou2 != null) {
                f = zzaou2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzdqr.isFluid()) {
            int n11;
            Object object = zzoi.zzbsx;
            if (((Boolean)zzlc.zzio().zzd(object)).booleanValue() || !zzs.zzant()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzaqf((zzaqe)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzaqh)this).zzdj(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzdre) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzdre * this.zzdss);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzdqr.zzvl()) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.zzavz.getDefaultDisplay().getMetrics(displayMetrics);
            this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzdqr.widthPixels > n17 || this.zzdqr.heightPixels > n18 ? 1 : 0;
        zzny zzny2 = zzoi.zzbvq;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
            int n20 = n4 = !((float)this.zzdqr.widthPixels / this.zzdss > (float)n17 / this.zzdss) && !((float)this.zzdqr.heightPixels / this.zzdss > (float)n18 / this.zzdss) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzdqr.widthPixels / this.zzdss);
            int n21 = (int)((float)this.zzdqr.heightPixels / this.zzdss);
            int n22 = (int)((float)n14 / this.zzdss);
            int n23 = (int)((float)n16 / this.zzdss);
            zzahw.zzcz((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzdqr.widthPixels, this.zzdqr.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzva();
        zzd zzd2 = this.zztw();
        if (zzd2 != null && bl) {
            zzd2.zznm();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzdqq = zzd2;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzdrj = zzd2;
    }

    @Override
    public final synchronized void zza(zzaqa zzaqa2) {
        this.zzdqr = zzaqa2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzah(boolean bl) {
        boolean bl2 = bl != this.zzdqu;
        this.zzdqu = bl;
        this.zzvd();
        if (bl2) {
            new zzyn(this).zzbo(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzui() {
        this.zzavk.zzrv();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzavk.onAttachedToWindow();
        }
        boolean bl = this.zzdra;
        if (this.zzdsr != null && this.zzdsr.zzuo()) {
            bl = true;
            if (!this.zzdrb) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdsr.zzup();
                if (onGlobalLayoutListener != null) {
                    zzbt.zzfg();
                    zzaqe zzaqe2 = this;
                    if (zzaqe2 == null) {
                        throw null;
                    }
                    zzaml.zza((View)zzaqe2, onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdsr.zzuq()) != null) {
                    zzbt.zzfg();
                    zzaqe zzaqe3 = this;
                    if (zzaqe3 == null) {
                        throw null;
                    }
                    zzaml.zza((View)zzaqe3, onScrollChangedListener);
                }
                this.zzdrb = true;
            }
            this.zzva();
        }
        this.zzal(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzaqe zzaqe2 = this;
        synchronized (zzaqe2) {
            if (!this.isDestroyed()) {
                this.zzavk.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdrb && this.zzdsr != null && this.zzdsr.zzuo() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdsr.zzup();
                if (onGlobalLayoutListener != null) {
                    zzbt.zzen().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdsr.zzuq()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdrb = false;
            }
        }
        this.zzal(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzvo().setBaseContext(context);
        this.zzavk.zzi(this.zzvo().zztj());
    }

    @Override
    public final synchronized void zzai(boolean bl) {
        if (this.zzdqq != null) {
            this.zzdqq.zza(this.zzdsr.zzfz(), bl);
            return;
        }
        this.zzdqs = bl;
    }

    @Override
    public final synchronized int getRequestedOrientation() {
        return this.zzdqw;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzdqw = n;
        if (this.zzdqq != null) {
            this.zzdqq.setRequestedOrientation(this.zzdqw);
        }
    }

    @Override
    public final Activity zztj() {
        return this.zzvo().zztj();
    }

    @Override
    public final Context zztv() {
        return this.zzvo().zztv();
    }

    private final synchronized void zzvd() {
        if (this.zzdqu || this.zzdqr.zzvl()) {
            zzahw.zzby((String)"Enabling hardware acceleration on an overlay.");
            this.zzvf();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzahw.zzby((String)"Disabling hardware acceleration on an AdView.");
            this.zzve();
            return;
        }
        zzahw.zzby((String)"Enabling hardware acceleration on an AdView.");
        this.zzvf();
    }

    private final synchronized void zzve() {
        if (!this.zzdqv) {
            zzbt.zzen().zzy((View)this);
        }
        this.zzdqv = true;
    }

    private final synchronized void zzvf() {
        if (this.zzdqv) {
            zzbt.zzen().zzx((View)this);
        }
        this.zzdqv = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzvh();
        this.zzavk.zzrw();
        if (this.zzdqq != null) {
            this.zzdqq.close();
            this.zzdqq.onDestroy();
            this.zzdqq = null;
        }
        zzaqb.reset();
        if (this.zzdqt) {
            return;
        }
        zzbt.zzff();
        zzanx.zzb(this);
        this.zzvg();
        this.zzdqt = true;
        zzahw.v("Initiating WebView self destruct sequence in 3...");
        zzahw.v("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzbt.zzep().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzahw.zzc((String)"Could not call loadUrl. ", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzaqe zzaqe2 = this;
            synchronized (zzaqe2) {
                if (!this.zzdqt) {
                    zzaqb.reset();
                    zzbt.zzff();
                    zzanx.zzb(this);
                    this.zzvg();
                    this.zzqc();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzue() {
        zzahw.v("Destroying WebView!");
        this.zzqc();
        zzaij.zzdfn.post((Runnable)new zzaqg(this));
    }

    private final synchronized void zzqc() {
        if (!this.zzdrk) {
            this.zzdrk = true;
            zzbt.zzep().zzqc();
        }
    }

    @Override
    public final synchronized boolean isDestroyed() {
        return this.zzdqt;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdsr != null && this.zzdsr.zzuy() != null) {
            this.zzdsr.zzuy().zzdb();
        }
    }

    @Override
    public final void zzuj() {
        if (this.zzdrg == null) {
            this.zzdrg = zzoo.zzb(this.zzdrh.zzjn());
            this.zzdrh.zza("native:view_load", this.zzdrg);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzum() {
        zzahw.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzaj(boolean bl) {
        this.zzdqx = bl;
    }

    @Override
    public final synchronized boolean zzuf() {
        return this.zzdqx;
    }

    @Override
    public final synchronized boolean zzug() {
        return this.zzdqy;
    }

    @Override
    public final synchronized void zzcp() {
        this.zzdqy = true;
        if (this.zzdqn != null) {
            this.zzdqn.zzcp();
        }
    }

    @Override
    public final synchronized void zzcq() {
        this.zzdqy = false;
        if (this.zzdqn != null) {
            this.zzdqn.zzcq();
        }
    }

    private final synchronized void zzvg() {
        this.zzdrl = null;
    }

    @Override
    public final synchronized void zzde(String string2) {
        this.zzcwj = string2 == null ? "" : string2;
    }

    @Override
    public final synchronized String getRequestId() {
        return this.zzcwj;
    }

    @Override
    public final zzane zztg() {
        return null;
    }

    @Override
    public final zzot zzti() {
        return this.zzdnt;
    }

    @Override
    public final zzou zztk() {
        return this.zzdrh;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdri = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzdri.get();
    }

    @Override
    public final synchronized void zzb(zzpt zzpt2) {
        this.zzdrc = zzpt2;
    }

    @Override
    public final synchronized zzpt zzuk() {
        return this.zzdrc;
    }

    @Override
    public final synchronized zzaou zzth() {
        return this.zzdqz;
    }

    @Override
    public final synchronized void zza(zzaou zzaou2) {
        if (this.zzdqz != null) {
            zzahw.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzdqz = zzaou2;
    }

    @Override
    public final synchronized boolean zzuh() {
        return this.zzdrd > 0;
    }

    @Override
    public final synchronized void zzak(boolean bl) {
        this.zzdrd += bl ? 1 : -1;
        if (this.zzdrd <= 0 && this.zzdqq != null) {
            this.zzdqq.zznp();
        }
    }

    private final void zzvh() {
        if (this.zzdrh == null) {
            return;
        }
        zzov zzov2 = this.zzdrh.zzjn();
        if (zzov2 != null && zzbt.zzep().zzpv() != null) {
            zzbt.zzep().zzpv().zza(zzov2);
        }
    }

    @Override
    public final void zzul() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzag(boolean bl) {
        this.zzdsr.zzag(bl);
    }

    @Override
    public final void zzno() {
        zzd zzd2 = this.zztw();
        if (zzd2 != null) {
            zzd2.zzno();
        }
    }

    @Override
    public final int zztm() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zztn() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        zzaqb.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        zzaqb.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        zzaqb.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        zzaqb.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgu zzgu2) {
        zzaqe zzaqe2 = this;
        synchronized (zzaqe2) {
            this.zzdra = zzgu2.zzakc;
        }
        this.zzal(zzgu2.zzakc);
    }

    private final void zzal(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzt<? super zzaof> zzt2) {
        if (this.zzdsr != null) {
            this.zzdsr.zza(string2, zzt2);
        }
    }

    @Override
    public final void zzb(String string2, zzt<? super zzaof> zzt2) {
        if (this.zzdsr != null) {
            zzaqb.zzb(string2, zzt2);
        }
    }

    static /* synthetic */ int zza(zzaqe zzaqe2) {
        return zzaqe2.zzdre;
    }

    static /* synthetic */ int zza(zzaqe zzaqe2, int n) {
        zzaqe2.zzdre = n;
        return zzaqe2.zzdre;
    }

    static /* synthetic */ void zzb(zzaqe zzaqe2) {
        super.destroy();
    }
}

