/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdtj;
import com.google.android.gms.internal.zzdxx;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzdyj
implements zzdtj {
    private Mac zzmlu;
    private final int zzmlv;
    private final String zzmlw;
    private final Key zzmlx;

    public zzdyj(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzmlw = string2;
        this.zzmlv = n;
        this.zzmlx = key;
        this.zzmlu = zzdxx.zzmll.zzoy(string2);
        this.zzmlu.init(key);
    }

    @Override
    public final byte[] zzaf(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzmlu.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzdxx.zzmll.zzoy(this.zzmlw);
            mac.init(this.zzmlx);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzmlv];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzmlv);
        return byArray2;
    }
}

