/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzfy;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzko;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzfv
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzahd> zzavv;
    private WeakReference<ViewTreeObserver> zzavw;
    private final zzhf zzavx;
    protected final zzft zzavy;
    private final Context mApplicationContext;
    private final WindowManager zzavz;
    private final PowerManager zzawa;
    private final KeyguardManager zzawb;
    private final DisplayMetrics zzawc;
    @Nullable
    private zzgc zzawd;
    private boolean zzawe;
    private boolean zzarz = false;
    private boolean zzawf = false;
    private boolean zzawg;
    private boolean zzawh;
    private boolean zzawi;
    @Nullable
    private BroadcastReceiver zzawj;
    private final HashSet<zzfs> zzawk = new HashSet();
    private zzake zzavf;
    private final HashSet<zzgq> zzawl = new HashSet();
    private final Rect zzawm = new Rect();
    private final zzfy zzawn;
    private float zzawo;

    public zzfv(Context context, zzko zzko2, zzahd zzahd2, zzala zzala2, zzhf zzhf2) {
        this.zzavv = new WeakReference<zzahd>(zzahd2);
        this.zzavx = zzhf2;
        this.zzavw = new WeakReference<Object>(null);
        this.zzawg = true;
        this.zzawi = false;
        this.zzavf = new zzake(200L);
        this.zzavy = new zzft(UUID.randomUUID().toString(), zzala2, zzko2.zzbia, zzahd2.zzdch, zzahd2.zzfz(), zzko2.zzbid);
        this.zzavz = (WindowManager)context.getSystemService("window");
        this.zzawa = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzawb = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzawn = new zzfy(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzawn);
        this.zzawc = context.getResources().getDisplayMetrics();
        Display display = this.zzavz.getDefaultDisplay();
        this.zzawm.right = display.getWidth();
        this.zzawm.bottom = display.getHeight();
        this.zzgb();
    }

    public final void zzgb() {
        this.zzawo = zzaja.zzav(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgc() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzawg) {
                this.zzawh = true;
                try {
                    JSONObject jSONObject = this.zzgg();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzahw.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzahw.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzavy.zzfy());
                zzahw.zzby((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzl(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgq> iterator = this.zzawl.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzgk()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzawg) {
                return;
            }
            View view = this.zzavx.zzgh();
            boolean bl3 = view != null && zzbt.zzel().zza(view, this.zzawa, this.zzawb);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzavx.zzgi()) {
                this.zzgc();
                return;
            }
            if (n == 1 && !this.zzavf.tryAcquire() && bl == this.zzawi) {
                return;
            }
            if (!bl && !this.zzawi && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzawi = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzahw.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfv zzfv2 = this;
            View view2 = zzfv2.zzavx.zzgj().zzgh();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfv2.zzavw.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfv2.zzgf();
                    if (!zzfv2.zzawe || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfv2.zzawe = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfv2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfv2);
                    }
                    zzfv2.zzavw = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzgd();
            return;
        }
    }

    private final void zzgd() {
        if (this.zzawd != null) {
            this.zzawd.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzge() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzawg;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zze(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzavy.zzfy());
    }

    final void zzf(Map<String, String> map) {
        this.zzl(3);
    }

    final void zza(zzgq zzgq2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzavy.zzfy());
        zzahw.zzby((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgq2);
    }

    final void zzg(Map<String, String> map) {
        boolean bl;
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl2 = bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        zzfv zzfv2 = this;
        Iterator<zzfs> iterator = zzfv2.zzawk.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzfv2, bl2);
        }
    }

    private final void zzgf() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzavw.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzgg() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzavy.zzfw()).put("activeViewJSON", (Object)this.zzavy.zzfx()).put("timestamp", zzbt.zzes().elapsedRealtime()).put("adFormat", (Object)this.zzavy.zzfv()).put("hashCode", (Object)this.zzavy.zzfy()).put("isMraid", this.zzavy.zzfz()).put("isStopped", this.zzawf).put("isPaused", this.zzarz).put("isNative", this.zzavy.zzga()).put("isScreenOn", this.isScreenOn()).put("appMuted", zzbt.zzfj().zzdq()).put("appVolume", (double)zzbt.zzfj().zzdp()).put("deviceVolume", (double)this.zzawo);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfv.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfv zzfv2 = this;
            ArrayList<zzgq> arrayList = new ArrayList<zzgq>(zzfv2.zzawl);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgq zzgq2 = arrayList.get(i);
                zzgq2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzahw.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgq zzgq2) {
        if (this.zzawl.isEmpty()) {
            zzfv zzfv2 = this;
            Object object = zzfv2.mLock;
            synchronized (object) {
                if (zzfv2.zzawj != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfv2.zzawj = new zzfw(zzfv2);
                    zzbt.zzfk().zza(zzfv2.mApplicationContext, zzfv2.zzawj, intentFilter);
                }
            }
            this.zzl(3);
        }
        this.zzawl.add(zzgq2);
        try {
            JSONObject jSONObject = zzfv.zza(this.zza(this.zzavx.zzgh(), null));
            zzgq2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgq zzgq2) {
        this.zzawl.remove(zzgq2);
        zzgq2.zzgl();
        if (this.zzawl.isEmpty()) {
            zzfv zzfv2 = this;
            Object object = zzfv2.mLock;
            synchronized (object) {
                zzfv2.zzgf();
                zzfv zzfv3 = zzfv2;
                Object object2 = zzfv3.mLock;
                synchronized (object2) {
                    if (zzfv3.zzawj != null) {
                        try {
                            zzbt.zzfk().zza(zzfv3.mApplicationContext, zzfv3.zzawj);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzahw.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbt.zzep().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfv3.zzawj = null;
                    }
                }
                zzfv2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfv2.zzawn);
                zzfv2.zzawg = false;
                zzfv2.zzgd();
                zzfv3 = zzfv2;
                ArrayList<zzgq> arrayList = new ArrayList<zzgq>(zzfv3.zzawl);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgq zzgq3 = arrayList.get(i);
                    zzgq zzgq4 = zzgq3;
                    zzfv3.zzb(zzgq4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfv zzfv2 = this;
            return zzfv2.zzgg().put("isAttachedToWindow", false).put("isScreenOn", zzfv2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbt.zzen().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzgg();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfv.zza(this.zzawm.top, this.zzawc)).put("bottom", zzfv.zza(this.zzawm.bottom, this.zzawc)).put("left", zzfv.zza(this.zzawm.left, this.zzawc)).put("right", zzfv.zza(this.zzawm.right, this.zzawc))).put("adBox", (Object)new JSONObject().put("top", zzfv.zza(rect.top, this.zzawc)).put("bottom", zzfv.zza(rect.bottom, this.zzawc)).put("left", zzfv.zza(rect.left, this.zzawc)).put("right", zzfv.zza(rect.right, this.zzawc))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfv.zza(rect2.top, this.zzawc)).put("bottom", zzfv.zza(rect2.bottom, this.zzawc)).put("left", zzfv.zza(rect2.left, this.zzawc)).put("right", zzfv.zza(rect2.right, this.zzawc))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfv.zza(rect3.top, this.zzawc)).put("bottom", zzfv.zza(rect3.bottom, this.zzawc)).put("left", zzfv.zza(rect3.left, this.zzawc)).put("right", zzfv.zza(rect3.right, this.zzawc))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfv.zza(rect4.top, this.zzawc)).put("bottom", zzfv.zza(rect4.bottom, this.zzawc)).put("left", zzfv.zza(rect4.left, this.zzawc)).put("right", zzfv.zza(rect4.right, this.zzawc))).put("screenDensity", (double)this.zzawc.density);
        if (bl == null) {
            bl = zzbt.zzel().zza(view, this.zzawa, this.zzawb);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzawa.isInteractive();
        }
        return this.zzawa.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzl(1);
    }

    public final void onGlobalLayout() {
        this.zzl(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgc zzgc2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzawd = zzgc2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzawf = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarz = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarz = false;
            this.zzl(3);
            return;
        }
    }
}

