/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzye;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyo;
import java.util.Map;
import java.util.Set;

@zzabh
@Hide
public final class zzyd
extends zzyn {
    private static Set<String> zzcky = zzf.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzckz = "top-right";
    private boolean zzcla = true;
    private int zzclb = 0;
    private int zzclc = 0;
    private int zzalu = -1;
    private int zzcld = 0;
    private int zzcle = 0;
    private int zzalt = -1;
    private final Object mLock = new Object();
    private final zzaof zzcct;
    private final Activity zzckp;
    private zzaqa zzclf;
    private ImageView zzclg;
    private LinearLayout zzclh;
    private zzyo zzcco;
    private PopupWindow zzcli;
    private RelativeLayout zzclj;
    private ViewGroup zzclk;

    public zzyd(zzaof zzaof2, zzyo zzyo2) {
        super(zzaof2, "resize");
        this.zzcct = zzaof2;
        this.zzckp = zzaof2.zztj();
        this.zzcco = zzyo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzckp == null) {
                this.zzbm("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzcct.zzty() == null) {
                this.zzbm("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzcct.zzty().zzvl()) {
                this.zzbm("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzcct.zzud()) {
                this.zzbm("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzyd zzyd2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbt.zzel();
                zzyd2.zzalt = zzaij.zzcj(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbt.zzel();
                zzyd2.zzalu = zzaij.zzcj(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbt.zzel();
                zzyd2.zzcld = zzaij.zzcj(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbt.zzel();
                zzyd2.zzcle = zzaij.zzcj(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzyd2.zzcla = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzyd2.zzckz = string2;
            }
            zzyd2 = this;
            if (!(zzyd2.zzalt >= 0 && zzyd2.zzalu >= 0)) {
                this.zzbm("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzckp.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbm("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzne();
            if (nArray == null) {
                this.zzbm("Resize location out of screen or close button is not visible.");
                return;
            }
            zzlc.zzij();
            int n = zzako.zza((Context)this.zzckp, (int)this.zzalt);
            zzlc.zzij();
            int n2 = zzako.zza((Context)this.zzckp, (int)this.zzalu);
            ViewParent viewParent = this.zzcct.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzcct.getView());
                if (this.zzcli == null) {
                    this.zzclk = (ViewGroup)viewParent;
                    zzbt.zzel();
                    bitmap = zzaij.zzr(this.zzcct.getView());
                    this.zzclg = new ImageView((Context)this.zzckp);
                    this.zzclg.setImageBitmap(bitmap);
                    this.zzclf = this.zzcct.zzty();
                    this.zzclk.addView((View)this.zzclg);
                } else {
                    this.zzcli.dismiss();
                }
            } else {
                this.zzbm("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzclj = new RelativeLayout((Context)this.zzckp);
            this.zzclj.setBackgroundColor(0);
            this.zzclj.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbt.zzel();
            this.zzcli = zzaij.zza((View)this.zzclj, n, n2, false);
            this.zzcli.setOutsideTouchable(true);
            this.zzcli.setTouchable(true);
            this.zzcli.setClippingEnabled(!this.zzcla);
            this.zzclj.addView(this.zzcct.getView(), -1, -1);
            this.zzclh = new LinearLayout((Context)this.zzckp);
            zzlc.zzij();
            int n3 = zzako.zza((Context)this.zzckp, (int)50);
            zzlc.zzij();
            bitmap = new RelativeLayout.LayoutParams(n3, zzako.zza((Context)this.zzckp, (int)50));
            switch (this.zzckz) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzclh.setOnClickListener((View.OnClickListener)new zzye(this));
            this.zzclh.setContentDescription((CharSequence)"Close button");
            this.zzclj.addView((View)this.zzclh, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzlc.zzij();
                int n4 = zzako.zza((Context)this.zzckp, (int)nArray[0]);
                zzlc.zzij();
                this.zzcli.showAtLocation(view, 0, n4, zzako.zza((Context)this.zzckp, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbm(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzclj.removeView(this.zzcct.getView());
                if (this.zzclk != null) {
                    this.zzclk.removeView((View)this.zzclg);
                    this.zzclk.addView(this.zzcct.getView());
                    this.zzcct.zza(this.zzclf);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzyd2 = this;
            if (zzyd2.zzcco != null) {
                zzyd2.zzcco.zza(n6, n5, zzyd2.zzalt, zzyd2.zzalu);
            }
            this.zzcct.zza(zzaqa.zzi(n, n2));
            this.zza(nArray[0], nArray[1]);
            this.zzbo("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcli != null) {
                this.zzcli.dismiss();
                this.zzclj.removeView(this.zzcct.getView());
                if (this.zzclk != null) {
                    this.zzclk.removeView((View)this.zzclg);
                    this.zzclk.addView(this.zzcct.getView());
                    this.zzcct.zza(this.zzclf);
                }
                if (bl) {
                    this.zzbo("default");
                    if (this.zzcco != null) {
                        this.zzcco.zzct();
                    }
                }
                this.zzcli = null;
                this.zzclj = null;
                this.zzclk = null;
                this.zzclh = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzne() {
        zzyd zzyd2 = this;
        int[] nArray = zzbt.zzel().zzg(zzyd2.zzckp);
        int[] nArray2 = zzbt.zzel().zzh(zzyd2.zzckp);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzyd2.zzalt < 50 || zzyd2.zzalt > n) {
            zzahw.zzcz((String)"Width is too small or too large.");
            return null;
        }
        if (zzyd2.zzalu < 50 || zzyd2.zzalu > n2) {
            zzahw.zzcz((String)"Height is too small or too large.");
            return null;
        }
        if (zzyd2.zzalu == n2 && zzyd2.zzalt == n) {
            zzahw.zzcz((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzyd2.zzcla) {
            int n3;
            int n4;
            switch (zzyd2.zzckz) {
                case "top-left": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld;
                    n3 = zzyd2.zzclc + zzyd2.zzcle;
                    break;
                }
                case "top-center": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld + zzyd2.zzalt / 2 - 25;
                    n3 = zzyd2.zzclc + zzyd2.zzcle;
                    break;
                }
                case "center": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld + zzyd2.zzalt / 2 - 25;
                    n3 = zzyd2.zzclc + zzyd2.zzcle + zzyd2.zzalu / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld;
                    n3 = zzyd2.zzclc + zzyd2.zzcle + zzyd2.zzalu - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld + zzyd2.zzalt / 2 - 25;
                    n3 = zzyd2.zzclc + zzyd2.zzcle + zzyd2.zzalu - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzyd2.zzclb + zzyd2.zzcld + zzyd2.zzalt - 50;
                    n3 = zzyd2.zzclc + zzyd2.zzcle + zzyd2.zzalu - 50;
                    break;
                }
                default: {
                    n4 = zzyd2.zzclb + zzyd2.zzcld + zzyd2.zzalt - 50;
                    n3 = zzyd2.zzclc + zzyd2.zzcle;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcla) {
            return new int[]{this.zzclb + this.zzcld, this.zzclc + this.zzcle};
        }
        int[] nArray3 = zzbt.zzel().zzg(this.zzckp);
        int[] nArray4 = zzbt.zzel().zzh(this.zzckp);
        int n5 = nArray3[0];
        int n6 = this.zzclb + this.zzcld;
        int n7 = this.zzclc + this.zzcle;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzalt > n5) {
            n6 = n5 - this.zzalt;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzalu <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzalu;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzclb = n;
            this.zzclc = n2;
            if (this.zzcli != null && bl) {
                int[] nArray = this.zzne();
                if (nArray != null) {
                    zzlc.zzij();
                    int n3 = zzako.zza((Context)this.zzckp, (int)nArray[0]);
                    zzlc.zzij();
                    this.zzcli.update(n3, zzako.zza((Context)this.zzckp, (int)nArray[1]), this.zzcli.getWidth(), this.zzcli.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzm(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbt.zzel().zzh(this.zzckp)[0];
        this.zzb(n, n2 - n3, this.zzalt, this.zzalu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zznf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcli != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzclb = n;
        this.zzclc = n2;
    }
}

