/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.zzab;
import com.google.android.gms.ads.internal.zzat;
import com.google.android.gms.ads.internal.zzau;
import com.google.android.gms.ads.internal.zzav;
import com.google.android.gms.ads.internal.zzaw;
import com.google.android.gms.ads.internal.zzax;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakm;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzpb;
import com.google.android.gms.internal.ads.zzpd;
import com.google.android.gms.internal.ads.zzqk;
import com.google.android.gms.internal.ads.zzql;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyz;
import com.google.android.gms.internal.ads.zzzc;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
public final class zzas {
    @Nullable
    public static View zze(@Nullable zzakm zzakm2) {
        if (zzakm2 == null) {
            zzalg.e((String)"AdState is null");
            return null;
        }
        if (zzas.zzf(zzakm2) && zzakm2.zzcbz != null) {
            return zzakm2.zzcbz.getView();
        }
        try {
            IObjectWrapper iObjectWrapper = zzakm2.zzbxg != null ? zzakm2.zzbxg.zznx() : null;
            if (iObjectWrapper == null) {
                zzalg.zzdp((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzalg.zzc((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean zza(zzasg var0, zzye var1_1, CountDownLatch var2_2) {
        var3_3 = false;
        try {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            var7_4 = var2_2;
                            var6_5 = var1_1;
                            var5_6 = var0;
                            var8_7 = var5_6.getView();
                            if (var8_7 != null) break block8;
                            zzalg.zzdp((String)"AdWebView is null");
                            v0 = false;
                            break block9;
                        }
                        var8_7.setVisibility(4);
                        var9_8 = var6_5.zzbxf.zzbvp;
                        if (var9_8 != null && !var9_8.isEmpty()) break block10;
                        zzalg.zzdp((String)"No template ids present in mediation response");
                        v0 = false;
                        break block9;
                    }
                    var15_9 = var7_4;
                    var14_10 = var5_6;
                    var16_11 = var15_9;
                    var14_10.zza("/nativeExpressAssetsLoaded", new zzav((CountDownLatch)var16_11));
                    var16_11 = var15_9;
                    var14_10.zza("/nativeExpressAssetsLoadingFailed", new zzaw((CountDownLatch)var16_11));
                    var10_12 = var6_5.zzbxg.zzny();
                    var11_13 = var6_5.zzbxg.zznz();
                    if (!var9_8.contains("2") || var10_12 == null) break block11;
                    var14_10 = var10_12;
                    var12_14 = new zzpb(var14_10.getHeadline(), var14_10.getImages(), var14_10.getBody(), var14_10.zzle(), var14_10.getCallToAction(), var14_10.getStarRating(), var14_10.getStore(), var14_10.getPrice(), null, var14_10.getExtras(), null, var14_10.zzog() != null ? (View)ObjectWrapper.unwrap((IObjectWrapper)var14_10.zzog()) : null, var14_10.zzlg(), null);
                    var16_11 = var6_5.zzbxf.zzbvo;
                    var15_9 = var12_14;
                    var14_10 = var5_6;
                    var14_10.zzvv().zza(new zzat((zzpb)var15_9, (String)var16_11, var14_10));
                    ** GOTO lbl46
                }
                if (!var9_8.contains("1") || var11_13 == null) {
                    zzalg.zzdp((String)"No matching template id and mapper");
                    v0 = false;
                } else {
                    var14_10 = var11_13;
                    var12_14 = new zzpd(var14_10.getHeadline(), var14_10.getImages(), var14_10.getBody(), var14_10.zzli(), var14_10.getCallToAction(), var14_10.getAdvertiser(), null, var14_10.getExtras(), null, var14_10.zzog() != null ? (View)ObjectWrapper.unwrap((IObjectWrapper)var14_10.zzog()) : null, var14_10.zzlg(), null);
                    var16_11 = var6_5.zzbxf.zzbvo;
                    var15_9 = var12_14;
                    var14_10 = var5_6;
                    var14_10.zzvv().zza(new zzau((zzpd)var15_9, (String)var16_11, var14_10));
lbl46:
                    // 2 sources

                    var12_14 = var6_5.zzbxf.zzbvm;
                    var13_15 = var6_5.zzbxf.zzbvn;
                    if (var13_15 != null) {
                        var5_6.loadDataWithBaseURL(var13_15, (String)var12_14, "text/html", "UTF-8", null);
                    } else {
                        var5_6.loadData((String)var12_14, "text/html", "UTF-8");
                    }
                    v0 = true;
                }
            }
            var3_3 = v0;
        }
        catch (RemoteException var4_16) {
            zzalg.zzc((String)"Unable to invoke load assets", (Throwable)var4_16);
        }
        catch (RuntimeException var4_17) {
            var2_2.countDown();
            throw var4_17;
        }
        if (!var3_3) {
            var2_2.countDown();
        }
        return var3_3;
    }

    public static boolean zzf(@Nullable zzakm zzakm2) {
        return zzakm2 != null && zzakm2.zzcij && zzakm2.zzbxf != null && zzakm2.zzbxf.zzbvm != null;
    }

    @VisibleForTesting
    static zzu<zzasg> zza(@Nullable zzyz zzyz2, @Nullable zzzc zzzc2, zzab zzab2) {
        return new zzax(zzyz2, zzab2, zzzc2);
    }

    private static void zzd(zzasg zzasg2) {
        View.OnClickListener onClickListener = zzasg2.getOnClickListener();
        if (onClickListener != null) {
            onClickListener.onClick(zzasg2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                Object object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzas.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzalg.zzdp((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            if (bundle.get(string3) instanceof Bitmap) {
                zzalg.zzdp((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    @VisibleForTesting
    private static String zza(@Nullable zzqk zzqk2) {
        if (zzqk2 == null) {
            zzalg.zzdp((String)"Image is null. Returning empty string");
            return "";
        }
        try {
            Uri uri = zzqk2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzalg.zzdp((String)"Unable to get image uri. Trying data uri next");
        }
        return zzas.zzb(zzqk2);
    }

    private static String zzb(zzqk zzqk2) {
        Drawable drawable2;
        try {
            IObjectWrapper iObjectWrapper = zzqk2.zzld();
            if (iObjectWrapper == null) {
                zzalg.zzdp((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzalg.zzdp((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzalg.zzdp((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        return zzas.zza(((BitmapDrawable)drawable2).getBitmap());
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzalg.zzdp((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        String string2 = Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Nullable
    private static zzqk zzd(Object object) {
        if (object instanceof IBinder) {
            return zzql.zzj((IBinder)((IBinder)object));
        }
        return null;
    }

    static final /* synthetic */ void zza(zzpd zzpd2, String string2, zzasg zzasg2, boolean bl) {
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("headline", (Object)zzpd2.getHeadline());
            jSONObject2.put("body", (Object)zzpd2.getBody());
            jSONObject2.put("call_to_action", (Object)zzpd2.getCallToAction());
            jSONObject2.put("advertiser", (Object)zzpd2.getAdvertiser());
            jSONObject2.put("logo", (Object)zzas.zza(zzpd2.zzli()));
            JSONArray jSONArray = new JSONArray();
            List list = zzpd2.getImages();
            if (list != null) {
                jSONObject = list.iterator();
                while (jSONObject.hasNext()) {
                    zzqk zzqk2 = zzas.zzd(jSONObject.next());
                    jSONArray.put((Object)zzas.zza(zzqk2));
                }
            }
            jSONObject2.put("images", (Object)jSONArray);
            jSONObject2.put("extras", (Object)zzas.zza(zzpd2.getExtras(), string2));
            jSONObject = new JSONObject();
            jSONObject.put("assets", (Object)jSONObject2);
            jSONObject.put("template_id", (Object)"1");
            zzasg2.zzb("google.afma.nativeExpressAds.loadAssets", jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
            return;
        }
    }

    static final /* synthetic */ void zza(zzpb zzpb2, String string2, zzasg zzasg2, boolean bl) {
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("headline", (Object)zzpb2.getHeadline());
            jSONObject2.put("body", (Object)zzpb2.getBody());
            jSONObject2.put("call_to_action", (Object)zzpb2.getCallToAction());
            jSONObject2.put("price", (Object)zzpb2.getPrice());
            jSONObject2.put("star_rating", (Object)String.valueOf(zzpb2.getStarRating()));
            jSONObject2.put("store", (Object)zzpb2.getStore());
            jSONObject2.put("icon", (Object)zzas.zza(zzpb2.zzle()));
            JSONArray jSONArray = new JSONArray();
            List list = zzpb2.getImages();
            if (list != null) {
                jSONObject = list.iterator();
                while (jSONObject.hasNext()) {
                    zzqk zzqk2 = zzas.zzd(jSONObject.next());
                    jSONArray.put((Object)zzas.zza(zzqk2));
                }
            }
            jSONObject2.put("images", (Object)jSONArray);
            jSONObject2.put("extras", (Object)zzas.zza(zzpb2.getExtras(), string2));
            jSONObject = new JSONObject();
            jSONObject.put("assets", (Object)jSONObject2);
            jSONObject.put("template_id", (Object)"2");
            zzasg2.zzb("google.afma.nativeExpressAds.loadAssets", jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
            return;
        }
    }

    static /* synthetic */ void zze(zzasg zzasg2) {
        zzas.zzd(zzasg2);
    }
}

