/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzabf;
import com.google.android.gms.internal.ads.zzabg;
import com.google.android.gms.internal.ads.zzabr;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzasg;
import java.util.Map;

@zzaer
public final class zzabe
extends zzabr {
    private final Map<String, String> zzbjp;
    private final Context mContext;
    private String zzbzd;
    private long zzbze;
    private long zzbzf;
    private String zzbzg;
    private String zzbzh;

    public zzabe(zzasg zzasg2, Map<String, String> map) {
        super(zzasg2, "createCalendarEvent");
        this.zzbjp = map;
        this.mContext = zzasg2.zzvc();
        zzabe zzabe2 = this;
        zzabe2.zzbzd = zzabe2.zzbz("description");
        zzabe2.zzbzg = zzabe2.zzbz("summary");
        zzabe2.zzbze = zzabe2.zzca("start_ticks");
        zzabe2.zzbzf = zzabe2.zzca("end_ticks");
        zzabe2.zzbzh = zzabe2.zzbz("location");
    }

    private final String zzbz(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbjp.get(string2))) {
            return "";
        }
        return this.zzbjp.get(string2);
    }

    private final long zzca(String string2) {
        String string3 = this.zzbjp.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzcb("Activity context is not available.");
            return;
        }
        zzbv.zzek();
        if (!zzalo.zzal(this.mContext).zzjx()) {
            this.zzcb("This feature is not available on the device.");
            return;
        }
        zzbv.zzek();
        AlertDialog.Builder builder = zzalo.zzak(this.mContext);
        Resources resources = zzbv.zzeo().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzabf(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzabg(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbzd);
        intent.putExtra("eventLocation", this.zzbzh);
        intent.putExtra("description", this.zzbzg);
        if (this.zzbze > -1L) {
            intent.putExtra("beginTime", this.zzbze);
        }
        if (this.zzbzf > -1L) {
            intent.putExtra("endTime", this.zzbzf);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzabe zzabe2) {
        return zzabe2.mContext;
    }
}

