/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzabl;
import com.google.android.gms.internal.ads.zzabm;
import com.google.android.gms.internal.ads.zzabr;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzasg;
import java.util.Map;

@zzaer
public final class zzabk
extends zzabr {
    private final Map<String, String> zzbjp;
    private final Context mContext;

    public zzabk(zzasg zzasg2, Map<String, String> map) {
        super(zzasg2, "storePicture");
        this.zzbjp = map;
        this.mContext = zzasg2.zzvc();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzcb("Activity context is not available");
            return;
        }
        zzbv.zzek();
        if (!zzalo.zzal(this.mContext).zzjw()) {
            this.zzcb("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbjp.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzcb("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzcb(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbv.zzek();
        if (!zzalo.zzda(string4)) {
            String string5 = String.valueOf(string4);
            this.zzcb(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbv.zzeo().getResources();
        zzbv.zzek();
        AlertDialog.Builder builder = zzalo.zzak(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzabl(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzabm(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzabk zzabk2) {
        return zzabk2.mContext;
    }
}

