/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaht;
import com.google.android.gms.internal.ads.zzahv;
import com.google.android.gms.internal.ads.zzaib;
import com.google.android.gms.internal.ads.zzaie;
import com.google.android.gms.internal.ads.zzaii;
import com.google.android.gms.internal.ads.zzaio;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzkz;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzyn;
import javax.annotation.concurrent.GuardedBy;

@zzaer
public final class zzahu
extends zzaie {
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzaop zzys;
    @GuardedBy(value="mLock")
    private final zzahv zzcom;

    public zzahu(Context context, zzv zzv2, zzyn zzyn2, zzaop zzaop2) {
        this(context, zzaop2, new zzahv(context, zzv2, zzjo.zzis(), zzyn2, zzaop2));
    }

    @VisibleForTesting
    private zzahu(Context context, zzaop zzaop2, zzahv zzahv2) {
        this.mContext = context;
        this.zzys = zzaop2;
        this.zzcom = zzahv2;
    }

    public final void setAppPackageName(String string2) throws RemoteException {
        block3: {
            if (this.mContext instanceof zzaht) {
                try {
                    ((zzaht)this.mContext).setAppPackageName(string2);
                    return;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    if (Build.VERSION.SDK_INT <= 15) break block3;
                    throw new RemoteException(PackageManager.NameNotFoundException.class.getSimpleName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzaio zzaio2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.zza(zzaio2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.zzql();
            return;
        }
    }

    public final synchronized void zzd(IObjectWrapper iObjectWrapper) throws RemoteException {
        if (this.mContext instanceof zzaht) {
            ((zzaht)this.mContext).zzf((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzaii zzaii2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.zza(zzaii2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzaib zzaib2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.zza(zzaib2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzkz zzkz2) {
        zznl zznl2 = zznw.zzbbo;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            Object object = this.mLock;
            synchronized (object) {
                this.zzcom.zza(zzkz2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Bundle getAdMetadata() {
        zznl zznl2 = zznw.zzbbo;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            Object object = this.mLock;
            synchronized (object) {
                return this.zzcom.getAdMetadata();
            }
        }
        return new Bundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUserId(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.setUserId(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCustomData(String string2) {
        zznl zznl2 = zznw.zzbbp;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.zzcom.zzr(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcom.isLoaded();
        }
    }

    public final void pause() {
        this.zze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zze(IObjectWrapper iObjectWrapper) {
        Object object = this.mLock;
        synchronized (object) {
            ((zza)this.zzcom).pause();
            return;
        }
    }

    public final void resume() {
        this.zzf(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(IObjectWrapper iObjectWrapper) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Context context = iObjectWrapper == null ? null : (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
                if (context != null) {
                    this.zzcom.onContextChanged(context);
                }
            }
            catch (Exception exception) {
                zzalg.zzc((String)"Unable to extract updated context.", (Throwable)exception);
            }
            ((zza)this.zzcom).resume();
            return;
        }
    }

    public final void destroy() {
        this.zzg(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzg(IObjectWrapper iObjectWrapper) {
        Object object = this.mLock;
        synchronized (object) {
            ((zza)this.zzcom).destroy();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMediationAdapterClassName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcom.getMediationAdapterClassName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setImmersiveMode(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            ((zza)this.zzcom).setImmersiveMode(bl);
            return;
        }
    }
}

