/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakq;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzali;
import com.google.android.gms.internal.ads.zzalk;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzgn;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
public final class zzalj
implements zzali {
    private final Object mLock = new Object();
    private boolean zzcun;
    private final List<Runnable> zzcuo = new ArrayList<Runnable>();
    private zzapi<?> zzcup;
    @Nullable
    @GuardedBy(value="mLock")
    private zzgn zzcuq = null;
    @Nullable
    @GuardedBy(value="mLock")
    private SharedPreferences zzcur;
    @Nullable
    @GuardedBy(value="mLock")
    private SharedPreferences.Editor zzcus;
    @GuardedBy(value="mLock")
    private boolean zzcut = false;
    @GuardedBy(value="mLock")
    private boolean zzclv = true;
    @Nullable
    @GuardedBy(value="mLock")
    private String zzcuu;
    @Nullable
    @GuardedBy(value="mLock")
    private String zzcuv;
    @GuardedBy(value="mLock")
    private boolean zzcme = false;
    @GuardedBy(value="mLock")
    private String zzcsy = "";
    @GuardedBy(value="mLock")
    private long zzcuw = 0L;
    @GuardedBy(value="mLock")
    private long zzcux = 0L;
    @GuardedBy(value="mLock")
    private long zzcuy = 0L;
    @GuardedBy(value="mLock")
    private int zzctv = -1;
    @GuardedBy(value="mLock")
    private int zzcuz = 0;
    @GuardedBy(value="mLock")
    private Set<String> zzcva = Collections.emptySet();
    @GuardedBy(value="mLock")
    private JSONObject zzcvb = new JSONObject();
    @GuardedBy(value="mLock")
    private boolean zzclw = true;
    @GuardedBy(value="mLock")
    private boolean zzclx = true;

    public final void zza(Context context, String string2, boolean bl) {
        String string3 = "admob";
        this.zzcup = zzalm.zzb(new zzalk(this, context, string3));
        this.zzcun = true;
    }

    private final void zzst() {
        if (this.zzcup == null) {
            return;
        }
        if (this.zzcup.isDone()) {
            return;
        }
        try {
            this.zzcup.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzalg.zzc((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzalg.zzb((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzsu() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.mLock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzclv);
            bundle.putBoolean("content_url_opted_out", this.zzclw);
            bundle.putBoolean("content_vertical_opted_out", this.zzclx);
            bundle.putBoolean("auto_collect_location", this.zzcme);
            bundle.putInt("version_code", this.zzcuz);
            bundle.putStringArray("never_pool_slots", this.zzcva.toArray(new String[this.zzcva.size()]));
            bundle.putString("app_settings_json", this.zzcsy);
            bundle.putLong("app_settings_last_update_ms", this.zzcuw);
            bundle.putLong("app_last_background_time_ms", this.zzcux);
            bundle.putInt("request_in_session_count", this.zzctv);
            bundle.putLong("first_ad_req_time_ms", this.zzcuy);
            bundle.putString("native_advanced_settings", this.zzcvb.toString());
            if (this.zzcuu != null) {
                bundle.putString("content_url_hashes", this.zzcuu);
            }
            if (this.zzcuv != null) {
                bundle.putString("content_vertical_hashes", this.zzcuv);
            }
        }
        return bundle;
    }

    private final void zzd(Bundle bundle) {
        zzalm.zzcve.execute(new zzall(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzab(boolean bl) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzclv == bl) {
                return;
            }
            this.zzclv = bl;
            if (this.zzcus != null) {
                this.zzcus.putBoolean("use_https", bl);
                this.zzcus.apply();
            }
            if (!this.zzcut) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("use_https", bl);
                this.zzd(bundle);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsf() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzclv || this.zzcut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzac(boolean bl) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzclw == bl) {
                return;
            }
            this.zzclw = bl;
            if (this.zzcus != null) {
                this.zzcus.putBoolean("content_url_opted_out", bl);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzclw);
            bundle.putBoolean("content_vertical_opted_out", this.zzclx);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsg() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzclw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcr(@Nullable String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzcuu)) {
                return;
            }
            this.zzcuu = string2;
            if (this.zzcus != null) {
                this.zzcus.putString("content_url_hashes", string2);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzsh() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcuu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzad(boolean bl) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzclx == bl) {
                return;
            }
            this.zzclx = bl;
            if (this.zzcus != null) {
                this.zzcus.putBoolean("content_vertical_opted_out", bl);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzclw);
            bundle.putBoolean("content_vertical_opted_out", this.zzclx);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsi() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzclx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcs(@Nullable String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzcuv)) {
                return;
            }
            this.zzcuv = string2;
            if (this.zzcus != null) {
                this.zzcus.putString("content_vertical_hashes", string2);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzsj() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcuv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(boolean bl) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcme == bl) {
                return;
            }
            this.zzcme = bl;
            if (this.zzcus != null) {
                this.zzcus.putBoolean("auto_collect_location", bl);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsk() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcme;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzal(int n) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcuz == n) {
                return;
            }
            this.zzcuz = n;
            if (this.zzcus != null) {
                this.zzcus.putInt("version_code", n);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzsl() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcuz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcva.contains(string2)) {
                return;
            }
            this.zzcva.add(string2);
            if (this.zzcus != null) {
                this.zzcus.putStringSet("never_pool_slots", this.zzcva);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzcva.toArray(new String[this.zzcva.size()]));
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcu(String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzcva.contains(string2)) {
                return;
            }
            this.zzcva.remove(string2);
            if (this.zzcus != null) {
                this.zzcus.putStringSet("never_pool_slots", this.zzcva);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzcva.toArray(new String[this.zzcva.size()]));
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzcv(String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcva.contains(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcw(String string2) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            long l;
            this.zzcuw = l = zzbv.zzer().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzcsy)) {
                return;
            }
            this.zzcsy = string2;
            if (this.zzcus != null) {
                this.zzcus.putString("app_settings_json", string2);
                this.zzcus.putLong("app_settings_last_update_ms", l);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzd(bundle);
            Iterator<Runnable> iterator = this.zzcuo.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzakq zzsm() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return new zzakq(this.zzcsy, this.zzcuw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzj(long l) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcux == l) {
                return;
            }
            this.zzcux = l;
            if (this.zzcus != null) {
                this.zzcus.putLong("app_last_background_time_ms", l);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzsn() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcux;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzam(int n) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzctv == n) {
                return;
            }
            this.zzctv = n;
            if (this.zzcus != null) {
                this.zzcus.putInt("request_in_session_count", n);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzso() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzctv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzk(long l) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcuy == l) {
                return;
            }
            this.zzcuy = l;
            if (this.zzcus != null) {
                this.zzcus.putLong("first_ad_req_time_ms", l);
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzsp() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcuy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(String string2, String string3, boolean bl) {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzcvb.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false) == bl) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzbv.zzer().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzcvb.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzalg.zzc((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzcus != null) {
                this.zzcus.putString("native_advanced_settings", this.zzcvb.toString());
                this.zzcus.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzcvb.toString());
            this.zzd((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject zzsq() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcvb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsr() {
        this.zzst();
        Object object = this.mLock;
        synchronized (object) {
            this.zzcvb = new JSONObject();
            if (this.zzcus != null) {
                this.zzcus.remove("native_advanced_settings");
                this.zzcus.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzd(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final zzgn zzss() {
        if (!this.zzcun) {
            return null;
        }
        if (!PlatformVersion.isAtLeastIceCreamSandwich()) {
            return null;
        }
        if (this.zzsg() && this.zzsi()) {
            return null;
        }
        zznl zznl2 = zznw.zzbad;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (Looper.getMainLooper() == null) {
                return null;
            }
            if (this.zzcuq == null) {
                this.zzcuq = new zzgn();
            }
            this.zzcuq.zzgw();
            zzalg.zzdo((String)"start fetching content...");
            return this.zzcuq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zzm(Context context, String string2) {
        String string3 = string2;
        Context context2 = context;
        zzalj zzalj2 = this;
        SharedPreferences sharedPreferences = context2.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = zzalj2.mLock;
        synchronized (object) {
            zzalj2.zzcur = sharedPreferences;
            zzalj2.zzcus = editor;
            zzalj2.zzcut = PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
            zzalj2.zzclv = zzalj2.zzcur.getBoolean("use_https", zzalj2.zzclv);
            zzalj2.zzclw = zzalj2.zzcur.getBoolean("content_url_opted_out", zzalj2.zzclw);
            zzalj2.zzcuu = zzalj2.zzcur.getString("content_url_hashes", zzalj2.zzcuu);
            zzalj2.zzcme = zzalj2.zzcur.getBoolean("auto_collect_location", zzalj2.zzcme);
            zzalj2.zzclx = zzalj2.zzcur.getBoolean("content_vertical_opted_out", zzalj2.zzclx);
            zzalj2.zzcuv = zzalj2.zzcur.getString("content_vertical_hashes", zzalj2.zzcuv);
            zzalj2.zzcuz = zzalj2.zzcur.getInt("version_code", zzalj2.zzcuz);
            zzalj2.zzcsy = zzalj2.zzcur.getString("app_settings_json", zzalj2.zzcsy);
            zzalj2.zzcuw = zzalj2.zzcur.getLong("app_settings_last_update_ms", zzalj2.zzcuw);
            zzalj2.zzcux = zzalj2.zzcur.getLong("app_last_background_time_ms", zzalj2.zzcux);
            zzalj2.zzctv = zzalj2.zzcur.getInt("request_in_session_count", zzalj2.zzctv);
            zzalj2.zzcuy = zzalj2.zzcur.getLong("first_ad_req_time_ms", zzalj2.zzcuy);
            zzalj2.zzcva = zzalj2.zzcur.getStringSet("never_pool_slots", zzalj2.zzcva);
            try {
                zzalj2.zzcvb = new JSONObject(zzalj2.zzcur.getString("native_advanced_settings", "{}"));
            }
            catch (JSONException jSONException) {
                zzalg.zzc((String)"Could not convert native advanced settings to json object", (Throwable)jSONException);
            }
            zzalj2.zzd(zzalj2.zzsu());
            return;
        }
    }
}

