/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaht;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalh;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzalp;
import com.google.android.gms.internal.ads.zzalq;
import com.google.android.gms.internal.ads.zzalr;
import com.google.android.gms.internal.ads.zzals;
import com.google.android.gms.internal.ads.zzalt;
import com.google.android.gms.internal.ads.zzalu;
import com.google.android.gms.internal.ads.zzalv;
import com.google.android.gms.internal.ads.zzamz;
import com.google.android.gms.internal.ads.zzano;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaod;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzbhv;
import com.google.android.gms.internal.ads.zzgh;
import com.google.android.gms.internal.ads.zzgn;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznh;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzot;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
public final class zzalo {
    public static final Handler zzcvi = new zzalh(Looper.getMainLooper());
    private final Object mLock = new Object();
    private boolean zzcvj = true;
    @GuardedBy(value="mLock")
    private String zzctf;
    private boolean zzcvk = false;
    private boolean zzcvl = false;
    @GuardedBy(value="this")
    private Pattern zzcvm;
    @GuardedBy(value="this")
    private Pattern zzcvn;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzalo zzalo2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzalo2.zzo(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzag(Context context) {
        ResolveInfo resolveInfo;
        context = zzaht.zzt(context);
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        try {
            resolveInfo = packageManager.resolveActivity(intent, 65536);
        }
        catch (Exception exception) {
            zzalg.zzc((String)"Could not verify that com.google.android.gms.ads.AdActivity is declared in AndroidManifest.xml", (Throwable)exception);
            zzbv.zzeo().zza(exception, "AdUtil.hasAdActivity");
            return false;
        }
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzalg.zzdp((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzalg.zzdp((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzalg.zzdp((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzalg.zzdp((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzalg.zzdp((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzalg.zzdp((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzalg.zzdp((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzalg.zzdp((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzn(Context context, String string2) {
        context = zzaht.zzt(context);
        String string3 = string2;
        String string4 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string3, string4) == 0;
    }

    public static void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzano(context, string2, string3).zzpe();
        }
    }

    public static void zzc(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        zzalo.zza(context, string2, arrayList);
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzbhv.zzbo((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzalg.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzot.zzi(context)) {
            zzalg.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zzot zzot2 = new zzot();
        zzalr zzalr2 = new zzalr(this, list, zzot2, context);
        zzot2.zza(zzalr2);
        zzot2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzah(Context context) {
        if (this.zzcvk) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzalv(this, null), intentFilter);
        this.zzcvk = true;
        return true;
    }

    public final boolean zzai(Context context) {
        if (this.zzcvl) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzalu(this, null), intentFilter);
        this.zzcvl = true;
        return true;
    }

    public final void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzo(context, string2));
    }

    private static String zzsv() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzo(Context context, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzctf != null) {
                return this.zzctf;
            }
            if (string2 == null) {
                return zzalo.zzsv();
            }
            try {
                this.zzctf = zzbv.zzem().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzctf)) {
                zzkd.zziz();
                if (!zzaoa.zztv()) {
                    this.zzctf = null;
                    zzcvi.post((Runnable)new zzals(this, context));
                    while (this.zzctf == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzctf = zzalo.zzsv();
                            String string3 = String.valueOf(this.zzctf);
                            zzalg.zzdp((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzctf = zzalo.zzaj(context);
                }
            }
            String string4 = String.valueOf(this.zzctf);
            this.zzctf = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (Wrappers.packageManager((Context)context).isCallerInstantApp()) {
                    this.zzctf = String.valueOf(this.zzctf).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbv.zzeo().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzctf = String.valueOf(this.zzctf).concat(")");
            return this.zzctf;
        }
    }

    @VisibleForTesting
    protected static String zzaj(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzalo.zzsv();
        }
    }

    public static String zzcy(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzn(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zze(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzalg.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zze(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zze((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzn(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzalo zzalo2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzalo2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zze((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzn(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static Map<String, String> zzg(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : zzbv.zzem().zzh(uri)) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public static String zzsw() {
        return UUID.randomUUID().toString();
    }

    public static int zzcz(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzalg.zzdp((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzsx() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzsy() {
        return new int[]{0, 0};
    }

    public static int[] zzg(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzalo.zzsy();
    }

    public final int[] zzh(Activity activity) {
        int[] nArray = zzalo.zzg(activity);
        int[] nArray2 = new int[2];
        zzkd.zziz();
        nArray2[0] = zzaoa.zzb((Context)activity, (int)nArray[0]);
        zzkd.zziz();
        nArray2[1] = zzaoa.zzb((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzi(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzalo.zzsy();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzkd.zziz();
        nArray4[0] = zzaoa.zzb((Context)activity, (int)nArray3[0]);
        zzkd.zziz();
        nArray4[1] = zzaoa.zzb((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzda(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzak(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zznh zzal(Context context) {
        return new zznh(context);
    }

    public static Bitmap zzt(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzam(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zzjo zzjo2) {
        zznl zznl2 = zznw.zzbas;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzjo2.width);
            jSONObject2.put("height", zzjo2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzalo.zzam(context));
            if (!zzjo2.zzaur) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static boolean zzan(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !zzalo.zzap(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean zzao(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !zzalo.zzap(context)) break;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean zzap(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            zzbv.zzek();
            bundle.putString("device", zzalo.zzsx());
            bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zznw.zzjz()));
        }
        zzkd.zziz();
        zzaoa.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)bl, (zzaod)new zzalt(this, context, string2));
    }

    public final void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        zznl zznl2 = zznw.zzbda;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public static void zzc(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzalm.zzb(runnable);
    }

    public static Bitmap zzu(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzalo.zzw(view);
        if (bitmap == null) {
            bitmap = zzalo.zzv(view);
        }
        return bitmap;
    }

    private static Bitmap zzv(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzalg.zzdp((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzalg.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzw(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzalg.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzaq(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            Window window = ((Activity)context).getWindow();
            if (window != null) {
                bitmap = zzalo.zzw(window.getDecorView().getRootView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzalg.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static int zzar(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzalo.zzas(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzas(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    public final boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl;
        KeyguardManager keyguardManager2;
        boolean bl2 = zzbv.zzek().zzcvj || !((keyguardManager2 = keyguardManager) == null ? false : keyguardManager2.inKeyguardRestrictedInputMode()) || zzalo.zzx(view) ? true : (bl = false);
        if (view.getVisibility() == 0 && view.isShown() && ((keyguardManager2 = powerManager) == null || keyguardManager2.isScreenOn()) && bl) {
            keyguardManager2 = zznw.zzbcx;
            if (!((Boolean)zzkd.zzjd().zzd((zznl)keyguardManager2)).booleanValue() || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzx(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzat(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        KeyguardManager keyguardManager = zzalo.zzas(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzy(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzau(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzalg.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbv.zzeo().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzsz() {
        Bundle bundle = new Bundle();
        try {
            Runtime runtime;
            zznl zznl2 = zznw.zzazm;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                runtime = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)runtime);
                bundle.putParcelable("debug_memory_info", (Parcelable)runtime);
            }
            runtime = Runtime.getRuntime();
            bundle.putLong("runtime_free_memory", runtime.freeMemory());
            bundle.putLong("runtime_max_memory", runtime.maxMemory());
            bundle.putLong("runtime_total_memory", runtime.totalMemory());
            bundle.putInt("web_view_count", zzbv.zzeo().zzrt());
        }
        catch (Exception exception) {
            zzalg.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzalo.zzb(context, intent);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzalg.zzco((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzalg.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzd(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzp(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(IOUtils.readInputStreamFully((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzalg.zzco((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zznl zznl2 = zznw.zzbgr;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return !activity.isInMultiWindowMode();
        }
        zzkd.zziz();
        int n = zzaoa.zza((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzaoa.zza((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzalo.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zznl2 = zznw.zzbgo;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * (Integer)zzkd.zzjd().zzd(zznl2);
        return zzalo.zzb(n3, n + n5, n7) && zzalo.zzb(n4, n2, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdb(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzalo zzalo2 = this;
            synchronized (zzalo2) {
                block10: {
                    zznl zznl2;
                    block9: {
                        if (this.zzcvm == null) break block9;
                        zznl2 = zznw.zzbau;
                        if (((String)zzkd.zzjd().zzd(zznl2)).equals(this.zzcvm.pattern())) break block10;
                    }
                    zznl2 = zznw.zzbau;
                    this.zzcvm = Pattern.compile((String)zzkd.zzjd().zzd(zznl2));
                }
                return this.zzcvm.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdc(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzalo zzalo2 = this;
            synchronized (zzalo2) {
                block10: {
                    zznl zznl2;
                    block9: {
                        if (this.zzcvn == null) break block9;
                        zznl2 = zznw.zzbav;
                        if (((String)zzkd.zzjd().zzd(zznl2)).equals(this.zzcvn.pattern())) break block10;
                    }
                    zznl2 = zznw.zzbav;
                    this.zzcvn = Pattern.compile((String)zzkd.zzjd().zzd(zznl2));
                }
                return this.zzcvn.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @VisibleForTesting
    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    @VisibleForTesting
    public static Bundle zza(zzgn zzgn2) {
        String string2;
        String string3;
        if (zzgn2 == null) {
            return null;
        }
        if (zzbv.zzeo().zzru().zzsg() && zzbv.zzeo().zzru().zzsi()) {
            return null;
        }
        if (zzgn2.zzha()) {
            zzgn2.wakeup();
        }
        zzgh zzgh2 = zzgn2.zzgy();
        String string4 = null;
        if (zzgh2 != null) {
            string3 = zzgh2.zzgn();
            string4 = zzgh2.zzgo();
            string2 = zzgh2.zzgp();
            if (string3 != null) {
                zzbv.zzeo().zzru().zzcr(string3);
            }
            if (string2 != null) {
                zzbv.zzeo().zzru().zzcs(string2);
            }
        } else {
            string3 = zzbv.zzeo().zzru().zzsh();
            string2 = zzbv.zzeo().zzru().zzsj();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null && !zzbv.zzeo().zzru().zzsi()) {
            bundle.putString("v_fp_vertical", string2);
        }
        if (string3 != null && !zzbv.zzeo().zzru().zzsg()) {
            bundle.putString("fingerprint", string3);
            if (!string3.equals(string4)) {
                bundle.putString("v_fp", string4);
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    @Nullable
    public static WebResourceResponse zze(Context context, String string2, String string3) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("User-Agent", zzbv.zzek().zzo(context, string2));
            hashMap.put("Cache-Control", "max-stale=3600");
            String string4 = (String)new zzamz(context).zzc(string3, hashMap).get(60L, TimeUnit.SECONDS);
            if (string4 != null) {
                return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(string4.getBytes("UTF-8")));
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzalg.zzc((String)"Could not fetch MRAID JS.", (Throwable)exception);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WebResourceResponse zzc(HttpURLConnection httpURLConnection) throws IOException {
        String string2;
        String string3;
        Object object2;
        block4: {
            Object object;
            zzbv.zzek();
            object2 = httpURLConnection.getContentType();
            string3 = TextUtils.isEmpty((CharSequence)object2) ? "" : ((String)object2).split(";")[0].trim();
            zzbv.zzek();
            object2 = httpURLConnection.getContentType();
            if (!TextUtils.isEmpty((CharSequence)object2) && ((String[])(object = ((String)object2).split(";"))).length != 1) {
                void entry;
                boolean i = true;
                while (entry < ((String[])object).length) {
                    String[] stringArray;
                    if (object[entry].trim().startsWith("charset") && (stringArray = ((String)object[entry]).trim().split("=")).length > 1) {
                        string2 = stringArray[1].trim();
                        break block4;
                    }
                    ++entry;
                }
            }
            string2 = "";
        }
        String string4 = string2;
        object2 = httpURLConnection.getHeaderFields();
        HashMap<String, String> hashMap = new HashMap<String, String>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            hashMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        HashMap<String, String> hashMap2 = hashMap;
        return zzbv.zzem().zza(string3, string4, httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage(), hashMap2, httpURLConnection.getInputStream());
    }

    public static void zza(Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        boolean bl = false;
        try {
            zznl zznl2 = zznw.zzayj;
            bl = (Boolean)zzkd.zzjd().zzd(zznl2);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bl) {
            Throwable throwable2 = throwable;
            CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable2);
        }
    }

    @Deprecated
    public final String zzav(Context context) {
        zznl zznl2 = zznw.zzbiq;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return "";
        }
        try {
            return (String)zzalm.zza(new zzalp(this, context)).get();
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            return "";
        }
        catch (ExecutionException executionException) {
            return "";
        }
    }

    @Deprecated
    public final Bundle zzaw(Context context) {
        zznl zznl2 = zznw.zzbir;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return null;
        }
        try {
            return (Bundle)zzalm.zza(new zzalq(this, context)).get();
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            return null;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static boolean zzax(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    public static boolean zzdd(String string2) {
        int n;
        Object object;
        if (!zzaoe.isEnabled()) {
            return false;
        }
        zznl zznl2 = zznw.zzbgw;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return false;
        }
        zznl2 = zznw.zzbgy;
        String string3 = (String)zzkd.zzjd().zzd(zznl2);
        if (!string3.isEmpty()) {
            object = string3.split(";");
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                if (!((String)object[n]).equals(string2)) continue;
                return false;
            }
        }
        zznl2 = zznw.zzbgx;
        object = (String)zzkd.zzjd().zzd(zznl2);
        if (((String)object).isEmpty()) {
            return true;
        }
        String[] stringArray = ((String)object).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean zza(zzalo zzalo2, boolean bl) {
        zzalo2.zzcvj = bl;
        return zzalo2.zzcvj;
    }

    static /* synthetic */ Object zza(zzalo zzalo2) {
        return zzalo2.mLock;
    }

    static /* synthetic */ String zza(zzalo zzalo2, String string2) {
        zzalo2.zzctf = string2;
        return zzalo2.zzctf;
    }
}

