/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzaqo;
import com.google.android.gms.internal.ads.zzaqp;
import com.google.android.gms.internal.ads.zzaqs;
import com.google.android.gms.internal.ads.zzaqt;
import com.google.android.gms.internal.ads.zzaqu;
import com.google.android.gms.internal.ads.zzaqv;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzarf;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzari;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzoj;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzaer
@ParametersAreNonnullByDefault
public final class zzaqr
extends FrameLayout
implements zzaqo {
    private final zzarg zzdbk;
    private final FrameLayout zzdbl;
    private final zzoj zzdbm;
    private final zzari zzdbn;
    private final long zzdbo;
    @Nullable
    private zzaqp zzdbp;
    private boolean zzdbq;
    private boolean zzdbr;
    private boolean zzdbs;
    private boolean zzdbt;
    private long zzdbu;
    private long zzdbv;
    private String zzdbw;
    private Bitmap zzdbx;
    private ImageView zzdby;
    private boolean zzdbz;

    public static void zza(zzarg zzarg2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzarg2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzarg zzarg2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzarg2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzarg zzarg2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzarg2.zza("onVideoEvent", hashMap);
    }

    public zzaqr(Context context, zzarg zzarg2, int n, boolean bl, zzoj zzoj2, zzarf zzarf2) {
        super(context);
        zznl zznl2;
        this.zzdbk = zzarg2;
        this.zzdbm = zzoj2;
        this.zzdbl = new FrameLayout(context);
        this.addView((View)this.zzdbl, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)zzarg2.zzbi());
        this.zzdbp = zzarg2.zzbi().zzxk.zza(context, zzarg2, n, bl, zzoj2, zzarf2);
        if (this.zzdbp != null) {
            this.zzdbl.addView((View)this.zzdbp, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zznl2 = zznw.zzazg;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                this.zzur();
            }
        }
        this.zzdby = new ImageView(context);
        zznl2 = zznw.zzazk;
        this.zzdbo = (Long)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzazi;
        this.zzdbt = (Boolean)zzkd.zzjd().zzd(zznl2);
        if (this.zzdbm != null) {
            this.zzdbm.zze("spinner_used", this.zzdbt ? "1" : "0");
        }
        this.zzdbn = new zzari(this);
        if (this.zzdbp != null) {
            this.zzdbp.zza(this);
        }
        if (this.zzdbp == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzdbl.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzds(String string2) {
        this.zzdbw = string2;
    }

    public final void zza(float f, float f2) {
        if (this.zzdbp != null) {
            this.zzdbp.zza(f, f2);
        }
    }

    public final void zzuo() {
        if (this.zzdbp == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzdbw)) {
            this.zzdbp.setVideoPath(this.zzdbw);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzdbp == null) {
            return;
        }
        this.zzdbp.pause();
    }

    public final void play() {
        if (this.zzdbp == null) {
            return;
        }
        this.zzdbp.play();
    }

    public final void seekTo(int n) {
        if (this.zzdbp == null) {
            return;
        }
        this.zzdbp.seekTo(n);
    }

    public final void zzup() {
        if (this.zzdbp == null) {
            return;
        }
        zzaqp zzaqp2 = this.zzdbp;
        zzaqp2.zzdbj.setMuted(true);
        zzaqp2.zzuh();
    }

    public final void zzuq() {
        if (this.zzdbp == null) {
            return;
        }
        zzaqp zzaqp2 = this.zzdbp;
        zzaqp2.zzdbj.setMuted(false);
        zzaqp2.zzuh();
    }

    public final void setVolume(float f) {
        if (this.zzdbp == null) {
            return;
        }
        float f2 = f;
        zzaqp zzaqp2 = this.zzdbp;
        zzaqp2.zzdbj.setVolume(f2);
        zzaqp2.zzuh();
    }

    @TargetApi(value=14)
    public final void zzf(MotionEvent motionEvent) {
        if (this.zzdbp == null) {
            return;
        }
        this.zzdbp.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzur() {
        if (this.zzdbp == null) {
            return;
        }
        Context context = this.zzdbp.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzdbp.zzud());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzdbl.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzdbl.bringChildToFront((View)textView);
    }

    @Override
    public final void zzui() {
        this.zzdbn.resume();
        zzalo.zzcvi.post((Runnable)new zzaqu(this));
    }

    @Override
    public final void zzuj() {
        if (this.zzdbp == null) {
            return;
        }
        if (this.zzdbv == 0L) {
            float f = (float)this.zzdbp.getDuration() / 1000.0f;
            int n = this.zzdbp.getVideoWidth();
            int n2 = this.zzdbp.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzuk() {
        zzaqr zzaqr2 = this;
        if (zzaqr2.zzdbk.zzvc() != null && !zzaqr2.zzdbr) {
            WindowManager.LayoutParams layoutParams = zzaqr2.zzdbk.zzvc().getWindow().getAttributes();
            boolean bl = zzaqr2.zzdbs = (layoutParams.flags & 0x80) != 0;
            if (!zzaqr2.zzdbs) {
                zzaqr2.zzdbk.zzvc().getWindow().addFlags(128);
                zzaqr2.zzdbr = true;
            }
        }
        this.zzdbq = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzuu();
        this.zzdbq = false;
    }

    @Override
    public final void zzul() {
        this.zza("ended", new String[0]);
        this.zzuu();
    }

    @Override
    public final void zzg(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzum() {
        zzaqr zzaqr2 = this;
        if (zzaqr2.zzdbz && zzaqr2.zzdbx != null && !zzaqr2.zzut()) {
            zzaqr2.zzdby.setImageBitmap(zzaqr2.zzdbx);
            zzaqr2.zzdby.invalidate();
            zzaqr2.zzdbl.addView((View)zzaqr2.zzdby, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaqr2.zzdbl.bringChildToFront((View)zzaqr2.zzdby);
        }
        this.zzdbn.pause();
        this.zzdbv = this.zzdbu;
        zzalo.zzcvi.post((Runnable)new zzaqv(this));
    }

    public final void destroy() {
        this.zzdbn.pause();
        if (this.zzdbp != null) {
            this.zzdbp.stop();
        }
        this.zzuu();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzdbn.pause();
            if (this.zzdbp != null) {
                zzaqp zzaqp2;
                zzaqp zzaqp3 = zzaqp2 = this.zzdbp;
                zzaqp3.getClass();
                zzapn.zzczw.execute(zzaqs.zza(zzaqp3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzus() {
        if (this.zzdbp == null) {
            return;
        }
        long l = this.zzdbp.getCurrentPosition();
        if (this.zzdbu != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzdbu = l;
        }
    }

    @Override
    public final void zzun() {
        zzaqr zzaqr2;
        if (this.zzdbq && (zzaqr2 = this).zzut()) {
            zzaqr2.zzdbl.removeView((View)zzaqr2.zzdby);
        }
        zzaqr2 = this;
        if (zzaqr2.zzdbx != null) {
            long l = zzbv.zzer().elapsedRealtime();
            if (zzaqr2.zzdbp.getBitmap(zzaqr2.zzdbx) != null) {
                zzaqr2.zzdbz = true;
            }
            long l2 = zzbv.zzer().elapsedRealtime() - l;
            if (zzalg.zzse()) {
                zzalg.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaqr2.zzdbo) {
                zzalg.zzdp((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaqr2.zzdbt = false;
                zzaqr2.zzdbx = null;
                if (zzaqr2.zzdbm != null) {
                    zzaqr2.zzdbm.zze("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzf(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaqr zzaqr2 = this;
        if (zzaqr2.zzdbt) {
            zznl zznl2 = zznw.zzazj;
            n4 = Math.max(n4 / (Integer)zzkd.zzjd().zzd(zznl2), 1);
            zznl2 = zznw.zzazj;
            n3 = Math.max(n3 / (Integer)zzkd.zzjd().zzd(zznl2), 1);
            if (zzaqr2.zzdbx == null || zzaqr2.zzdbx.getWidth() != n4 || zzaqr2.zzdbx.getHeight() != n3) {
                zzaqr2.zzdbx = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaqr2.zzdbz = false;
            }
        }
    }

    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzdbn.resume();
        } else {
            this.zzdbn.pause();
            this.zzdbv = this.zzdbu;
        }
        zzalo.zzcvi.post((Runnable)new zzaqt(this, bl));
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zzdbn.resume();
            bl = true;
        } else {
            this.zzdbn.pause();
            this.zzdbv = this.zzdbu;
            bl = false;
        }
        zzalo.zzcvi.post((Runnable)new zzaqw(this, bl));
    }

    private final boolean zzut() {
        return this.zzdby.getParent() != null;
    }

    private final void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzdbk.zza("onVideoEvent", hashMap);
    }

    private final void zzuu() {
        if (this.zzdbk.zzvc() == null) {
            return;
        }
        if (this.zzdbr && !this.zzdbs) {
            this.zzdbk.zzvc().getWindow().clearFlags(128);
            this.zzdbr = false;
        }
    }

    final /* synthetic */ void zzah(boolean bl) {
        this.zza("windowFocusChanged", "hasWindowFocus", String.valueOf(bl));
    }

    static /* synthetic */ void zza(zzaqr zzaqr2, String string2, String[] stringArray) {
        zzaqr2.zza(string2, stringArray);
    }
}

