/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.webkit.ValueCallback;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzaud;
import com.google.android.gms.internal.ads.zzaue;
import com.google.android.gms.internal.ads.zzauf;
import com.google.android.gms.internal.ads.zzauh;
import com.google.android.gms.internal.ads.zzauj;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzaer
@ParametersAreNonnullByDefault
public class zzaug
extends zzaud
implements zzauj {
    private final zzaue zzdjb;
    @GuardedBy(value="this")
    private boolean zzbkw;
    @GuardedBy(value="this")
    private boolean zzdjc;

    public zzaug(Context context, zzaue zzaue2) {
        super(context);
        zzbv.zzeo().zzrr();
        this.zzdjb = zzaue2;
        super.setWebViewClient((WebViewClient)zzaue2);
    }

    public final synchronized boolean isDestroyed() {
        return this.zzbkw;
    }

    @GuardedBy(value="this")
    protected void zzao(boolean bl) {
    }

    public synchronized void destroy() {
        if (this.zzbkw) {
            return;
        }
        this.zzbkw = true;
        this.zzdjb.zza(this);
        this.zzao(false);
        zzalg.v("Initiating WebView self destruct sequence in 3...");
        zzalg.v("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzbv.zzeo().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzalg.zzd((String)"#007 Could not call remote method.", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    @Override
    public final synchronized void zza(zzauf zzauf2) {
        zzalg.v("Blank page loaded, 1...");
        this.zzwb();
    }

    @VisibleForTesting
    protected synchronized void zzwb() {
        zzalg.v("Destroying WebView!");
        this.zzrs();
        zzapn.zzczw.execute(new zzauh(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            zzaug zzaug2 = this;
            synchronized (zzaug2) {
                if (!this.isDestroyed()) {
                    this.zzao(true);
                }
                this.zzrs();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private final synchronized void zzrs() {
        if (!this.zzdjc) {
            this.zzdjc = true;
            zzbv.zzeo().zzrs();
        }
    }

    @TargetApi(value=19)
    public synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzalg.zzdp((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzalg.zzdp((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzalg.zzdp((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzalg.zzdp((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.isDestroyed() && super.onTouchEvent(motionEvent);
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        super.onPause();
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        super.onResume();
    }

    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        super.stopLoading();
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    final /* synthetic */ void zzxp() {
        super.destroy();
    }
}

