/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzavn;
import com.google.android.gms.internal.ads.zzavt;
import com.google.android.gms.internal.ads.zzavu;
import com.google.android.gms.internal.ads.zzavz;
import com.google.android.gms.internal.ads.zzawa;
import com.google.android.gms.internal.ads.zzawc;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzayy;
import com.google.android.gms.internal.ads.zzaza;
import com.google.android.gms.internal.ads.zzaze;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbel;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzawb {
    private static final Logger logger = Logger.getLogger(zzawb.class.getName());
    private static final ConcurrentMap<String, zzavt> zzdle = new ConcurrentHashMap<String, zzavt>();
    private static final ConcurrentMap<String, Boolean> zzdlf = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzavn> zzdlg = new ConcurrentHashMap<String, zzavn>();

    public static synchronized <P> void zza(String string2, zzavn<P> zzavn2) throws GeneralSecurityException {
        if (zzdlg.containsKey(string2.toLowerCase())) {
            zzavn zzavn3 = (zzavn)zzdlg.get(string2.toLowerCase());
            if (!zzavn2.getClass().equals(zzavn3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzdlg.put(string2.toLowerCase(), zzavn2);
    }

    public static <P> zzavn<P> zzed(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzavn zzavn2 = (zzavn)zzdlg.get(string2.toLowerCase());
        if (zzavn2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.register().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.register().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.register().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzavn2;
    }

    public static synchronized <P> void zza(zzavt<P> zzavt2) throws GeneralSecurityException {
        zzawb.zza(zzavt2, true);
    }

    public static synchronized <P> void zza(zzavt<P> zzavt2, boolean bl) throws GeneralSecurityException {
        if (zzavt2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String string2 = zzavt2.getKeyType();
        if (zzdle.containsKey(string2)) {
            zzavt<P> zzavt3 = zzawb.zzee(string2);
            boolean bl2 = (Boolean)zzdlf.get(string2);
            if (!zzavt2.getClass().equals(zzavt3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzavt3.getClass().getName(), zzavt2.getClass().getName()));
            }
        }
        zzdle.put(string2, zzavt2);
        zzdlf.put(string2, bl);
    }

    private static <P> zzavt<P> zzee(String string2) throws GeneralSecurityException {
        zzavt zzavt2 = (zzavt)zzdle.get(string2);
        if (zzavt2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        return zzavt2;
    }

    public static synchronized <P> zzayv zza(zzaza zzaza2) throws GeneralSecurityException {
        zzavt<P> zzavt2 = zzawb.zzee(zzaza2.zzaaq());
        if (((Boolean)zzdlf.get(zzaza2.zzaaq())).booleanValue()) {
            return zzavt2.zzc(zzaza2.zzaar());
        }
        String string2 = String.valueOf(zzaza2.zzaaq());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized <P> zzbel zzb(zzaza zzaza2) throws GeneralSecurityException {
        zzavt<P> zzavt2 = zzawb.zzee(zzaza2.zzaaq());
        if (((Boolean)zzdlf.get(zzaza2.zzaaq())).booleanValue()) {
            return zzavt2.zzb(zzaza2.zzaar());
        }
        String string2 = String.valueOf(zzaza2.zzaaq());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized <P> zzbel zza(String string2, zzbel zzbel2) throws GeneralSecurityException {
        zzavt<P> zzavt2 = zzawb.zzee(string2);
        if (((Boolean)zzdlf.get(string2)).booleanValue()) {
            return zzavt2.zzb(zzbel2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zzb(String string2, zzbel zzbel2) throws GeneralSecurityException {
        return zzawb.zzee(string2).zza(zzbel2);
    }

    private static <P> P zza(String string2, zzbbu zzbbu2) throws GeneralSecurityException {
        return zzawb.zzee(string2).zza(zzbbu2);
    }

    public static <P> P zza(String string2, byte[] byArray) throws GeneralSecurityException {
        return zzawb.zza(string2, zzbbu.zzo((byte[])byArray));
    }

    public static <P> zzavz<P> zza(zzavu zzavu2, zzavt<P> zzavt2) throws GeneralSecurityException {
        zzawc.zzc(zzavu2.zzxz());
        zzavz zzavz2 = new zzavz();
        for (zzaze.zzb zzb2 : zzavu2.zzxz().zzabf()) {
            if (zzb2.zzabk() != zzayy.zzdos) continue;
            P p = zzawb.zza(zzb2.zzabj().zzaaq(), zzb2.zzabj().zzaar());
            zzawa zzawa2 = zzavz2.zza(p, zzb2);
            if (zzb2.zzabl() != zzavu2.zzxz().zzabe()) continue;
            zzavz2.zza(zzawa2);
        }
        return zzavz2;
    }
}

