/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzavx;
import com.google.android.gms.internal.ads.zzbal;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzbaw
implements zzavx {
    private Mac zzdrx;
    private final int zzdry;
    private final String zzdrz;
    private final Key zzdsa;

    public zzbaw(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzdrz = string2;
        this.zzdry = n;
        this.zzdsa = key;
        this.zzdrx = zzbal.zzdro.zzep(string2);
        this.zzdrx.init(key);
    }

    @Override
    public final byte[] zzg(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzdrx.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzbal.zzdro.zzep(this.zzdrz);
            mac.init(this.zzdsa);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzdry];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzdry);
        return byArray2;
    }
}

