/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzabb;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzjk;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzpy;
import com.google.android.gms.internal.ads.zzxx;
import com.google.android.gms.internal.ads.zzxy;
import com.google.android.gms.internal.ads.zzya;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyf;
import com.google.android.gms.internal.ads.zzyn;
import com.google.android.gms.internal.ads.zzyq;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzyw;
import com.google.android.gms.internal.ads.zzzk;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
public final class zzyb
implements zzyf {
    private final String zzbwp;
    private final zzyn zzwr;
    private final long zzbwq;
    private final zzxy zzbwr;
    private final zzxx zzbws;
    private zzjk zzabf;
    private final zzjo zzabl;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzaop zzys;
    private final boolean zzafd;
    private final zzpy zzyo;
    private final List<String> zzbwt;
    private final List<String> zzbwu;
    private final List<String> zzbwv;
    private final boolean zzbww;
    private final boolean zzbwx;
    @GuardedBy(value="mLock")
    private zzyq zzbwy;
    @GuardedBy(value="mLock")
    private int zzbwz = -2;
    private zzyw zzbxa;

    public zzyb(Context context, String string2, zzyn zzyn2, zzxy zzxy2, zzxx zzxx2, zzjk zzjk2, zzjo zzjo2, zzaop zzaop2, boolean bl, boolean bl2, zzpy zzpy2, List<String> list, List<String> list2, List<String> list3, boolean bl3) {
        this.mContext = context;
        this.zzwr = zzyn2;
        this.zzbws = zzxx2;
        this.zzbwp = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zznq() : string2;
        this.zzbwr = zzxy2;
        this.zzbwq = zzxx2.zzbvs != -1L ? zzxx2.zzbvs : (zzxy2.zzbvs != -1L ? zzxy2.zzbvs : 10000L);
        this.zzabf = zzjk2;
        this.zzabl = zzjo2;
        this.zzys = zzaop2;
        this.zzafd = bl;
        this.zzbww = bl2;
        this.zzyo = zzpy2;
        this.zzbwt = list;
        this.zzbwu = list2;
        this.zzbwv = list3;
        this.zzbwx = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzbwy != null) {
                    this.zzbwy.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzalg.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzbwz = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zznq() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzbws.zzbvc)) {
                if (this.zzwr.zzbr(this.zzbws.zzbvc)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzalg.zzdp((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbwz = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzyw zzyw2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbwz = 0;
            this.zzbxa = zzyw2;
            this.mLock.notify();
            return;
        }
    }

    @VisibleForTesting
    private static zzyq zza(MediationAdapter mediationAdapter) {
        return new zzzk(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzye zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzya zzya2 = new zzya();
            zzalo.zzcvi.post((Runnable)new zzyc(this, zzya2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzbwq;
            zzyb zzyb2 = this;
            while (zzyb2.zzbwz == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzyb zzyb3 = zzyb2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzalg.zzdo((String)"Timed out waiting for adapter.");
                    zzyb3.zzbwz = 3;
                    continue;
                }
                try {
                    zzyb3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzyb3.zzbwz = 5;
                }
            }
            long l14 = zzbv.zzer().elapsedRealtime() - l3;
            return new zzye(this.zzbws, this.zzbwy, this.zzbwp, zzya2, this.zzbwz, this.zznr(), l14);
        }
    }

    @GuardedBy(value="mLock")
    private final zzyw zznr() {
        if (this.zzbwz != 0 || !this.zznt()) {
            return null;
        }
        try {
            if (this.zzaf(4) && this.zzbxa != null && this.zzbxa.zznv() != 0) {
                return this.zzbxa;
            }
        }
        catch (RemoteException remoteException) {
            zzalg.zzdp((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zznu();
        return new zzyd(n);
    }

    @GuardedBy(value="mLock")
    private final zzyq zzns() {
        String string2 = String.valueOf(this.zzbwp);
        zzalg.zzdo((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzafd && !this.zzbws.zzno()) {
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbwp)) {
                return zzyb.zza((MediationAdapter)new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzbwp)) {
                return zzyb.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzbwp)) {
                return new zzzk((MediationAdapter)new zzabb());
            }
        }
        try {
            return this.zzwr.zzbq(this.zzbwp);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzbwp);
            zzalg.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    @GuardedBy(value="mLock")
    private final void zza(zzya zzya2) {
        String string2 = this.zzbn(this.zzbws.zzbvi);
        try {
            if (this.zzys.zzczb < 4100000) {
                if (this.zzabl.zzaur) {
                    this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabf, string2, (zzyt)zzya2);
                    return;
                }
                this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabl, this.zzabf, string2, (zzyt)zzya2);
                return;
            }
            if (this.zzafd || this.zzbws.zzno()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzbwt);
                if (this.zzbwu != null) {
                    for (String string3 : this.zzbwu) {
                        String string4 = ":false";
                        if (this.zzbwv != null && this.zzbwv.contains(string3)) {
                            string4 = ":true";
                        }
                        String string5 = string4;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("custom:").append(string3).append(string5).toString());
                    }
                }
                this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabf, string2, this.zzbws.zzbuy, (zzyt)zzya2, this.zzyo, arrayList);
                return;
            }
            if (this.zzabl.zzaur) {
                this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabf, string2, this.zzbws.zzbuy, (zzyt)zzya2);
                return;
            }
            if (this.zzbww) {
                if (this.zzbws.zzbvm != null) {
                    this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabf, string2, this.zzbws.zzbuy, (zzyt)zzya2, new zzpy(zzyb.zzbo(this.zzbws.zzbvq)), this.zzbws.zzbvp);
                    return;
                }
                this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabl, this.zzabf, string2, this.zzbws.zzbuy, (zzyt)zzya2);
                return;
            }
            this.zzbwy.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzabl, this.zzabf, string2, this.zzbws.zzbuy, (zzyt)zzya2);
            return;
        }
        catch (RemoteException remoteException) {
            zzalg.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzae(5);
            return;
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zzaf(int n) {
        Bundle bundle;
        try {
            bundle = this.zzafd ? this.zzbwy.zzob() : (this.zzabl.zzaur ? this.zzbwy.getInterstitialAdapterInfo() : this.zzbwy.zzoa());
        }
        catch (RemoteException remoteException) {
            zzalg.zzdp((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zznt() {
        return this.zzbwr.zzbwe != -1;
    }

    @GuardedBy(value="mLock")
    private final String zzbn(String string2) {
        if (string2 == null || !this.zznt() || this.zzaf(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzalg.zzdp((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    @GuardedBy(value="mLock")
    private final int zznu() {
        JSONObject jSONObject;
        if (this.zzbws.zzbvi == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzbws.zzbvi);
        }
        catch (JSONException jSONException) {
            zzalg.zzdp((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbwp)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzaf(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbo(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string4 = string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string4) ? 2 : ("portrait".equals(string4) ? 1 : ("any".equals(string4) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzyb zzyb2) {
        return zzyb2.mLock;
    }

    static /* synthetic */ int zzb(zzyb zzyb2) {
        return zzyb2.zzbwz;
    }

    static /* synthetic */ zzyq zza(zzyb zzyb2, zzyq zzyq2) {
        zzyb2.zzbwy = zzyq2;
        return zzyb2.zzbwy;
    }

    static /* synthetic */ zzyq zzc(zzyb zzyb2) {
        return zzyb2.zzns();
    }

    static /* synthetic */ zzyq zzd(zzyb zzyb2) {
        return zzyb2.zzbwy;
    }

    static /* synthetic */ boolean zze(zzyb zzyb2) {
        return zzyb2.zznt();
    }

    static /* synthetic */ boolean zza(zzyb zzyb2, int n) {
        return zzyb2.zzaf(1);
    }

    static /* synthetic */ String zzf(zzyb zzyb2) {
        return zzyb2.zzbwp;
    }

    static /* synthetic */ void zza(zzyb zzyb2, zzya zzya2) {
        zzyb2.zza(zzya2);
    }
}

