/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzalj;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawl;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbao;
import com.google.android.gms.internal.ads.zzbar;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzyt;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@zzard
@ParametersAreNonnullByDefault
public final class zzd {
    private Context zzlj;
    private long zzbqy = 0L;

    public final void zza(Context context, zzbai zzbai2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzbai2, true, null, string2, null, runnable);
    }

    public final void zza(Context context, zzbai zzbai2, String string2, zzawl zzawl2) {
        String string3 = zzawl2 != null ? zzawl2.zzut() : null;
        this.zza(context, zzbai2, false, zzawl2, string3, string2, null);
    }

    @VisibleForTesting
    private final void zza(Context context, zzbai zzbai2, boolean bl, @Nullable zzawl zzawl2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzk.zzln().elapsedRealtime() - this.zzbqy < 5000L) {
            zzawz.zzep((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzbqy = zzk.zzln().elapsedRealtime();
        zzawl zzawl3 = zzawl2;
        if (zzawl3 == null) {
            bl2 = true;
        } else {
            long l = zzawl3.zzuq();
            zzacj zzacj2 = zzacu.zzcsy;
            bl2 = zzk.zzln().currentTimeMillis() - l > (Long)zzyt.zzpe().zzd(zzacj2) || !zzawl3.zzur();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzawz.zzep((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzawz.zzep((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.zzlj = context2 != null ? context2 : context;
        zzalj<JSONObject, JSONObject> zzalj2 = zzk.zzlt().zzb(this.zzlj, zzbai2).zza("google.afma.config.fetchAppSettings", zzalo.zzddi, zzalo.zzddi);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzbbh<JSONObject> zzbbh2 = zzalj2.zzi(jSONObject);
            zzbbh zzbbh3 = zzbar.zza(zzbbh2, zze.zzbqz, zzbbm.zzeaf);
            if (runnable != null) {
                zzbbh2.zza(runnable, zzbbm.zzeaf);
            }
            zzbao.zza(zzbbh3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

