/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzag;
import com.google.android.gms.internal.ads.zzao;
import com.google.android.gms.internal.ads.zzap;
import com.google.android.gms.internal.ads.zzb;
import com.google.android.gms.internal.ads.zzc;
import com.google.android.gms.internal.ads.zzl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class zzan
implements zzb {
    private final Map<String, zzao> zzbx = new LinkedHashMap<String, zzao>(16, 0.75f, true);
    private long zzby = 0L;
    private final File zzbz;
    private final int zzca;

    public zzan(File file, int n) {
        this.zzbz = file;
        this.zzca = n;
    }

    public zzan(File file) {
        this(file, 0x500000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized zzc zza(String string2) {
        zzao zzao2 = this.zzbx.get(string2);
        if (zzao2 == null) {
            return null;
        }
        File file = this.zze(string2);
        try (zzap zzap2 = new zzap(new BufferedInputStream(zzan.zza(file)), file.length());){
            byte[] byArray;
            zzao zzao3 = zzao.zzc(zzap2);
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)zzao3.zzcc)) {
                zzag.d("%s: key=%s, found=%s", file.getAbsolutePath(), string2, zzao3.zzcc);
                this.removeEntry(string2);
                return null;
            }
            byte[] byArray2 = byArray = zzan.zza(zzap2, zzap2.zzo());
            zzao zzao4 = zzao2;
            zzc zzc2 = new zzc();
            new zzc().data = byArray2;
            zzc2.zza = zzao4.zza;
            zzc2.zzb = zzao4.zzb;
            zzc2.zzc = zzao4.zzc;
            zzc2.zzd = zzao4.zzd;
            zzc2.zze = zzao4.zze;
            List<zzl> list = zzao4.zzg;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (zzl zzl2 : list) {
                treeMap.put(zzl2.getName(), zzl2.getValue());
            }
            zzc2.zzf = treeMap;
            zzc2.zzg = Collections.unmodifiableList(zzao4.zzg);
            zzc zzc3 = zzc2;
            return zzc3;
        }
        catch (IOException iOException) {
            zzag.d("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            return null;
        }
    }

    @Override
    public final synchronized void zza() {
        if (!this.zzbz.exists()) {
            if (!this.zzbz.mkdirs()) {
                zzag.e("Unable to create cache dir %s", this.zzbz.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzbz.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            try {
                long l = file.length();
                try (zzap zzap2 = new zzap(new BufferedInputStream(zzan.zza(file)), l);){
                    zzao zzao2 = zzao.zzc(zzap2);
                    zzao.zzc(zzap2).zzcb = l;
                    this.zza(zzao2.zzcc, zzao2);
                    continue;
                }
            }
            catch (IOException iOException) {
                file.delete();
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzc zzc2) {
        if (this.zzby + (long)zzc2.data.length > (long)this.zzca && (float)zzc2.data.length > (float)this.zzca * 0.9f) {
            return;
        }
        File file = this.zze(string2);
        try {
            Object object = file;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            zzao zzao2 = new zzao(string2, zzc2);
            if (!zzao2.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzag.d("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzc2.data);
            bufferedOutputStream.close();
            zzao2.zzcb = file.length();
            this.zza(string2, zzao2);
            object = this;
            if (((zzan)object).zzby >= (long)((zzan)object).zzca) {
                if (zzag.DEBUG) {
                    zzag.v("Pruning old cache entries.", new Object[0]);
                }
                long l = ((zzan)object).zzby;
                int n = 0;
                long l2 = SystemClock.elapsedRealtime();
                Iterator<Map.Entry<String, zzao>> iterator = ((zzan)object).zzbx.entrySet().iterator();
                while (iterator.hasNext()) {
                    zzao zzao3 = iterator.next().getValue();
                    if (super.zze(zzao3.zzcc).delete()) {
                        ((zzan)object).zzby -= zzao3.zzcb;
                    } else {
                        zzag.d("Could not delete cache entry for key=%s, filename=%s", zzao3.zzcc, zzan.zzd(zzao3.zzcc));
                    }
                    iterator.remove();
                    ++n;
                    if (!((float)((zzan)object).zzby < (float)((zzan)object).zzca * 0.9f)) continue;
                }
                if (zzag.DEBUG) {
                    zzag.v("pruned %d files, %d bytes, %d ms", n, ((zzan)object).zzby - l, SystemClock.elapsedRealtime() - l2);
                }
            }
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzag.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzag.d("Could not delete cache entry for key=%s, filename=%s", string2, zzan.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzbz, zzan.zzd(string2));
    }

    private final void zza(String string2, zzao zzao2) {
        if (!this.zzbx.containsKey(string2)) {
            this.zzby += zzao2.zzcb;
        } else {
            zzao zzao3 = this.zzbx.get(string2);
            this.zzby += zzao2.zzcb - zzao3.zzcb;
        }
        this.zzbx.put(string2, zzao2);
    }

    private final void removeEntry(String string2) {
        zzao zzao2 = this.zzbx.remove(string2);
        if (zzao2 != null) {
            this.zzby -= zzao2.zzcb;
        }
    }

    @VisibleForTesting
    private static byte[] zza(zzap zzap2, long l) throws IOException {
        long l2 = zzap2.zzo();
        if (l < 0L || l > l2 || (long)((int)l) != l) {
            throw new IOException(new StringBuilder(73).append("streamToBytes length=").append(l).append(", maxLength=").append(l2).toString());
        }
        byte[] byArray = new byte[(int)l];
        new DataInputStream(zzap2).readFully(byArray);
        return byArray;
    }

    @VisibleForTesting
    private static InputStream zza(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzan.zza(inputStream) | zzan.zza(inputStream) << 8 | zzan.zza(inputStream) << 16 | zzan.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzan.zza(inputStream) & 0xFFL | ((long)zzan.zza(inputStream) & 0xFFL) << 8 | ((long)zzan.zza(inputStream) & 0xFFL) << 16 | ((long)zzan.zza(inputStream) & 0xFFL) << 24 | ((long)zzan.zza(inputStream) & 0xFFL) << 32 | ((long)zzan.zza(inputStream) & 0xFFL) << 40 | ((long)zzan.zza(inputStream) & 0xFFL) << 48 | ((long)zzan.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzan.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zza(zzap zzap2) throws IOException {
        long l = zzan.zzc(zzap2);
        byte[] byArray = zzan.zza(zzap2, l);
        return new String(byArray, "UTF-8");
    }

    static List<zzl> zzb(zzap zzap2) throws IOException {
        int n = zzan.zzb((InputStream)zzap2);
        if (n < 0) {
            throw new IOException(new StringBuilder(31).append("readHeaderList size=").append(n).toString());
        }
        ArrayList<zzl> arrayList = n == 0 ? Collections.emptyList() : new ArrayList<zzl>();
        for (int i = 0; i < n; ++i) {
            String string2 = zzan.zza(zzap2).intern();
            String string3 = zzan.zza(zzap2).intern();
            arrayList.add(new zzl(string2, string3));
        }
        return arrayList;
    }
}

