/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzapp;
import com.google.android.gms.internal.ads.zzapq;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbgz;
import java.util.Map;

@zzard
public final class zzapo
extends zzaqb {
    private final Map<String, String> zzcxs;
    private final Context zzlj;
    private String zzdhr;
    private long zzdhs;
    private long zzdht;
    private String zzdhu;
    private String zzdhv;

    public zzapo(zzbgz zzbgz2, Map<String, String> map) {
        super(zzbgz2, "createCalendarEvent");
        this.zzcxs = map;
        this.zzlj = zzbgz2.zzyd();
        zzapo zzapo2 = this;
        zzapo2.zzdhr = zzapo2.zzdf("description");
        zzapo2.zzdhu = zzapo2.zzdf("summary");
        zzapo2.zzdhs = zzapo2.zzdg("start_ticks");
        zzapo2.zzdht = zzapo2.zzdg("end_ticks");
        zzapo2.zzdhv = zzapo2.zzdf("location");
    }

    private final String zzdf(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzcxs.get(string2))) {
            return "";
        }
        return this.zzcxs.get(string2);
    }

    private final long zzdg(String string2) {
        String string3 = this.zzcxs.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.zzlj == null) {
            this.zzdh("Activity context is not available.");
            return;
        }
        zzk.zzlg();
        if (!zzaxi.zzao(this.zzlj).zzql()) {
            this.zzdh("This feature is not available on the device.");
            return;
        }
        zzk.zzlg();
        AlertDialog.Builder builder = zzaxi.zzan(this.zzlj);
        Resources resources = zzk.zzlk().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzapp(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzapq(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzdhr);
        intent.putExtra("eventLocation", this.zzdhv);
        intent.putExtra("description", this.zzdhu);
        if (this.zzdhs > -1L) {
            intent.putExtra("beginTime", this.zzdhs);
        }
        if (this.zzdht > -1L) {
            intent.putExtra("endTime", this.zzdht);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzapo zzapo2) {
        return zzapo2.zzlj;
    }
}

