/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzarv;
import com.google.android.gms.internal.ads.zzarw;
import com.google.android.gms.internal.ads.zzawz;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzard
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LargeParcelTeleporterCreator")
public final class zzaru
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaru> CREATOR = new zzarw();
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zzdoo;
    private Parcelable zzdop;
    private boolean zzdoq;

    @SafeParcelable.Constructor
    public zzaru(@SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor) {
        this.zzdoo = parcelFileDescriptor;
        this.zzdop = null;
        this.zzdoq = true;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzdoq) {
            byte[] byArray;
            if (this.zzdoo == null) {
                zzawz.zzen((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzdoo));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzawz.zzc((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzdop = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzdoq = false;
        }
        return (T)((SafeParcelable)this.zzdop);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzts();
        Parcel parcel2 = parcel;
        zzaru zzaru2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzaru2.zzdoo, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzts() {
        if (this.zzdoo == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzdop.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzdoo = this.zzi(byArray);
        }
        return this.zzdoo;
    }

    private final <T> ParcelFileDescriptor zzi(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzarv zzarv2 = new zzarv(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzarv2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzawz.zzc((String)"Error transporting the ad response", (Throwable)iOException);
            zzk.zzlk().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            IOUtils.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

