/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzayj;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzyt;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
public final class zzayi {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String zzdwn = "";
    @GuardedBy(value="lock")
    private String zzdwo = "";
    @GuardedBy(value="lock")
    private boolean zzdwp = false;
    @VisibleForTesting
    private String zzdwq = "";

    public final void zze(Context context, String string2, String string3) {
        if (!this.zzf(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzdwq)) {
            zzawz.zzdp((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
            return;
        }
        if ("1".equals(this.zzdwq)) {
            zzawz.zzdp((String)"The app is not linked for creative preview.");
            this.zzi(context, string2, string3);
            return;
        }
        if ("0".equals(this.zzdwq)) {
            zzawz.zzdp((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public final void zza(Context context, String string2, String string3, @Nullable String string4) {
        boolean bl = this.zzwo();
        if (this.zzg(context, string2, string3)) {
            if (!bl && !TextUtils.isEmpty((CharSequence)string4)) {
                this.zzc(context, string3, string4, string2);
            }
            zzawz.zzdp((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzi(context, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzf(Context context, String string2, String string3) {
        String string4;
        Object object = zzacu.zzcuc;
        String string5 = zzayi.zzh(context, this.zzd(context, (String)zzyt.zzpe().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzawz.zzdp((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzdwq = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzawz.zzd((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        String string6 = string4;
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdwo = string6;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzg(Context context, String string2, String string3) {
        String string4;
        Object object = zzacu.zzcud;
        String string5 = zzayi.zzh(context, this.zzd(context, (String)zzyt.zzpe().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzawz.zzdp((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            string4 = new JSONObject(string5).optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzawz.zzd((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdwp = bl;
        }
        return bl;
    }

    @VisibleForTesting
    private static String zzh(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzk.zzlg().zzq(context, string3));
        zzbbh<String> zzbbh2 = new zzayu(context).zzc(string2, hashMap);
        try {
            zzacj zzacj2 = zzacu.zzcuf;
            return (String)zzbbh2.get(((Integer)zzyt.zzpe().zzd(zzacj2)).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzawz.zzc((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzbbh2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzawz.zzc((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzbbh2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzawz.zzc((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private final void zzi(Context context, String string2, String string3) {
        zzk.zzlg();
        zzacj zzacj2 = zzacu.zzcub;
        zzaxi.zza(context, this.zzd(context, (String)zzyt.zzpe().zzd(zzacj2), string2, string3));
    }

    public final boolean zzb(Context context, String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string3) || !zzk.zzlq().zzwo()) {
            return false;
        }
        zzawz.zzdp((String)"Sending troubleshooting signals to the server.");
        this.zzc(context, string2, string3, string4);
        return true;
    }

    private final void zzc(Context context, String string2, String string3, String string4) {
        zzacj zzacj2 = zzacu.zzcue;
        Uri.Builder builder = this.zzd(context, (String)zzyt.zzpe().zzd(zzacj2), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzk.zzlg();
        zzaxi.zzb(context, string2, builder.build().toString());
    }

    private final Uri zzd(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzbb(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzbb(Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzdwn)) {
                zzk.zzlg();
                this.zzdwn = zzaxi.zzr(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzdwn)) {
                    zzk.zzlg();
                    this.zzdwn = zzaxi.zzwb();
                    zzk.zzlg();
                    zzaxi.zzc(context, "debug_signals_id.txt", this.zzdwn);
                }
            }
            return this.zzdwn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzwn() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdwo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzwo() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdwp;
        }
    }

    @VisibleForTesting
    private final void zza(Context context, String string2, boolean bl, boolean bl2) {
        if (!(context instanceof Activity)) {
            zzawz.zzeo((String)"Can not create dialog without Activity Context");
            return;
        }
        zzaxi.zzdvv.post((Runnable)new zzayj(this, context, string2, bl, bl2));
    }
}

