/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbdb;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzdbh;
import javax.annotation.concurrent.GuardedBy;

@zzard
final class zzbda
implements SensorEventListener {
    private final SensorManager zzecv;
    private final Object zzecw;
    private final Display zzecx;
    private final float[] zzecy;
    private final float[] zzecz;
    @GuardedBy(value="sensorThreadLock")
    private float[] zzeda;
    private Handler zzedb;
    private zzbdc zzedc;

    zzbda(Context context) {
        this.zzecv = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzecx = windowManager.getDefaultDisplay();
        this.zzecy = new float[9];
        this.zzecz = new float[9];
        this.zzecw = new Object();
    }

    final void start() {
        if (this.zzedb != null) {
            return;
        }
        Sensor sensor = this.zzecv.getDefaultSensor(11);
        if (sensor == null) {
            zzawz.zzen((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzedb = new zzdbh(handlerThread.getLooper());
        if (!this.zzecv.registerListener((SensorEventListener)this, sensor, 0, this.zzedb)) {
            zzawz.zzen((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzedb == null) {
            return;
        }
        this.zzecv.unregisterListener((SensorEventListener)this);
        this.zzedb.post((Runnable)new zzbdb(this));
        this.zzedb = null;
    }

    final void zza(zzbdc zzbdc2) {
        this.zzedc = zzbdc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzbda zzbda2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzbda2.zzecw;
            synchronized (object) {
                if (zzbda2.zzeda == null) {
                    zzbda2.zzeda = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzbda2.zzecy, (float[])fArray);
            switch (zzbda2.zzecx.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzbda2.zzecy, (int)2, (int)129, (float[])zzbda2.zzecz);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzbda2.zzecy, (int)129, (int)130, (float[])zzbda2.zzecz);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzbda2.zzecy, (int)130, (int)1, (float[])zzbda2.zzecz);
                    break;
                }
                default: {
                    System.arraycopy(zzbda2.zzecy, 0, zzbda2.zzecz, 0, 9);
                }
            }
            zzbda2.zzl(1, 3);
            zzbda2.zzl(2, 6);
            zzbda2.zzl(5, 7);
            Object object2 = zzbda2.zzecw;
            synchronized (object2) {
                System.arraycopy(zzbda2.zzecz, 0, zzbda2.zzeda, 0, 9);
            }
            if (zzbda2.zzedc != null) {
                zzbda2.zzedc.zztk();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzecw;
        synchronized (object) {
            if (this.zzeda == null) {
                return false;
            }
            System.arraycopy(this.zzeda, 0, fArray, 0, this.zzeda.length);
            return true;
        }
    }

    private final void zzl(int n, int n2) {
        float f = this.zzecz[n];
        this.zzecz[n] = this.zzecz[n2];
        this.zzecz[n2] = f;
    }
}

