/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbdk;
import com.google.android.gms.internal.ads.zzbdr;
import com.google.android.gms.internal.ads.zzbds;
import com.google.android.gms.internal.ads.zzbdt;
import com.google.android.gms.internal.ads.zzbdw;
import com.google.android.gms.internal.ads.zzbdx;
import com.google.android.gms.internal.ads.zzbdy;
import com.google.android.gms.internal.ads.zzbdz;
import com.google.android.gms.internal.ads.zzbea;
import com.google.android.gms.internal.ads.zzbeb;
import com.google.android.gms.internal.ads.zzbec;
import com.google.android.gms.internal.ads.zzbed;
import com.google.android.gms.internal.ads.zzbee;
import com.google.android.gms.internal.ads.zzbef;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbeh;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgg;
import com.google.android.gms.internal.ads.zzbgl;
import com.google.android.gms.internal.ads.zzge;
import com.google.android.gms.internal.ads.zzgf;
import com.google.android.gms.internal.ads.zzgh;
import com.google.android.gms.internal.ads.zzgl;
import com.google.android.gms.internal.ads.zzgn;
import com.google.android.gms.internal.ads.zzgq;
import com.google.android.gms.internal.ads.zzhd;
import com.google.android.gms.internal.ads.zzhh;
import com.google.android.gms.internal.ads.zzhn;
import com.google.android.gms.internal.ads.zzid;
import com.google.android.gms.internal.ads.zzig;
import com.google.android.gms.internal.ads.zziv;
import com.google.android.gms.internal.ads.zzjg;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjt;
import com.google.android.gms.internal.ads.zzyt;
import java.nio.ByteBuffer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.dataflow.qual.SideEffectFree;

@zzard
@ParametersAreNonnullByDefault
@TargetApi(value=16)
public final class zzbdq
extends zzbco
implements TextureView.SurfaceTextureListener {
    private float zzefn;
    private final zzbdf zzebt;
    private final Context zzlj;
    private final int zzefo;
    private final zzbdg zzeaw;
    private final boolean zzeax;
    private final zzbde zzefp;
    private zzbcn zzebk;
    @Nullable
    private Surface zzaez;
    @Nullable
    private zzbdk zzefq;
    @Nullable
    private zzge zzefe;
    @Nullable
    private zzhd zzeff;
    @Nullable
    private zzgn zzefg;
    private String zzefr;
    private boolean zzefs;
    private int zzeft = 1;
    @Nullable
    private zzbdd zzebh;
    private boolean zzebi;
    private boolean zzefu;
    private boolean zzefv;
    private int zzebc;
    private int zzebd;
    private float zzaft;
    private int zzebf;
    private int zzebg;
    private final zzgh zzefw = new zzbee(this);
    private final zzhh zzefx = new zzbef(this);
    private final zzgq zzefy = new zzbeg(this);

    public zzbdq(Context context, zzbdg zzbdg2, zzbdf zzbdf2, int n, boolean bl, boolean bl2, zzbde zzbde2) {
        super(context);
        this.zzlj = context;
        this.zzeax = bl2;
        this.zzebt = zzbdf2;
        this.zzefo = n;
        this.zzeaw = zzbdg2;
        this.zzebi = bl;
        this.zzefp = zzbde2;
        this.setSurfaceTextureListener(this);
        this.zzeaw.zzb(this);
    }

    @EnsuresNonNullIf(expression={"mPlayer"}, result=true)
    private final boolean zzyv() {
        return this.zzefe != null && !this.zzefs;
    }

    @EnsuresNonNullIf(expression={"mPlayer"}, result=true)
    private final boolean zzyw() {
        return this.zzyv() && this.zzeft != 1;
    }

    private final void zzyx() {
        if (this.zzefe != null) {
            return;
        }
        if (this.zzefr != null && this.zzaez != null) {
            zzbdq zzbdq2 = this;
            zzbdk zzbdk2 = null;
            if (zzbdq2.zzefr.startsWith("cache:")) {
                zzbft zzbft2 = zzbdq2.zzebt.zzet(zzbdq2.zzefr);
                if (zzbft2 != null && zzbft2 instanceof zzbgl) {
                    zzbgl zzbgl2 = (zzbgl)zzbft2;
                    zzbgl2.zzzx();
                    zzbdk2 = zzbgl2.zzzy();
                    zzbdk2.zza(zzbdq2.zzefw, zzbdq2.zzefx, zzbdq2.zzefy);
                } else if (zzbft2 instanceof zzbgg) {
                    zzig zzig2;
                    zzjp zzjp2;
                    Object object;
                    zzid zzid2;
                    zzbgg zzbgg2 = (zzbgg)zzbft2;
                    ByteBuffer byteBuffer = zzbgg2.getByteBuffer();
                    String string2 = zzbgg2.getUrl();
                    boolean bl = zzbgg2.zzzv();
                    zzbdk2 = new zzbdk();
                    boolean bl2 = bl;
                    ByteBuffer byteBuffer2 = byteBuffer;
                    String string3 = string2;
                    zzbdq zzbdq3 = zzbdq2;
                    zzid zzid3 = zzid2 = "video/webm".equals(null) ? new zzjg() : new zziv();
                    if (bl2 && byteBuffer2.limit() > 0) {
                        object = new byte[byteBuffer2.limit()];
                        byteBuffer2.get((byte[])object);
                        zzjp2 = new zzjo((byte[])object);
                        zzig2 = new zzig(Uri.parse((String)string3), zzjp2, zzid2, 2, zzbdq3.zzefp.zzeee);
                    } else {
                        object = zzk.zzlg().zzq(zzbdq3.zzebt.getContext(), zzbdq3.zzebt.zzyh().zzbsx);
                        zzjp2 = new zzjt(zzbdq3.zzebt.getContext(), (String)object);
                        zzacj zzacj2 = zzacu.zzctr;
                        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                            zzjp2 = new zzbeh(zzbdq3.zzlj, zzjp2, new zzbds(zzbdq3));
                        }
                        if (byteBuffer2.limit() > 0) {
                            byte[] byArray = new byte[byteBuffer2.limit()];
                            byteBuffer2.get(byArray);
                            zzjp zzjp3 = zzjp2;
                            zzjo zzjo2 = new zzjo(byArray);
                            zzjp2 = new zzbej(zzjo2, byArray.length, zzjp3);
                        }
                        zzig2 = new zzig(Uri.parse((String)string3), zzjp2, zzid2, 2, zzbdq3.zzefp.zzeee);
                    }
                    zzig zzig3 = zzig2;
                    zzbdk2.zza(zzbdq2.zzefw, zzbdq2.zzefx, zzbdq2.zzefy);
                    if (!zzbdk2.zza(zzig3)) {
                        zzbdq2.zzn("AdExoPlayerHelper Error", "Prepare from ByteBuffer failed.");
                    }
                } else {
                    String string4 = String.valueOf(zzbdq2.zzefr);
                    zzawz.zzep((String)(string4.length() != 0 ? "Source is MD5 but not found in cache. Source: ".concat(string4) : new String("Source is MD5 but not found in cache. Source: ")));
                }
            } else {
                zzhn zzhn2;
                zzbdq zzbdq4 = zzbdq2;
                if (zzbdq4.zzefo == 1) {
                    zzhn2 = new zzgl(zzbdq4.zzebt.getContext(), Uri.parse((String)zzbdq4.zzefr), null, 2);
                } else {
                    Preconditions.checkArgument((zzbdq4.zzefo == 2 ? 1 : 0) != 0);
                    String string5 = zzk.zzlg().zzq(zzbdq4.zzebt.getContext(), zzbdq4.zzebt.zzyh().zzbsx);
                    zzjp zzjp4 = new zzjt(zzbdq4.zzebt.getContext(), string5);
                    zzacj zzacj3 = zzacu.zzctr;
                    if (((Boolean)zzyt.zzpe().zzd(zzacj3)).booleanValue()) {
                        zzjp4 = new zzbeh(zzbdq4.zzlj, zzjp4, new zzbdr(zzbdq4));
                    }
                    zzid zzid4 = "video/webm".equals(null) ? new zzjg() : new zziv();
                    zzhn2 = new zzig(Uri.parse((String)zzbdq4.zzefr), zzjp4, zzid4, 2, zzbdq4.zzefp.zzeee);
                }
                zzgl zzgl2 = zzhn2;
                zzbdk2 = new zzbdk();
                zzbdk2.zza(zzbdq2.zzefw, zzbdq2.zzefx, zzbdq2.zzefy);
                if (!zzbdk2.zza(zzgl2)) {
                    zzbdq2.zzn("AdExoPlayerHelper Error", "Prepare failed.");
                }
            }
            this.zzefq = zzbdk2;
            if (this.zzefq == null) {
                String string6 = String.valueOf(this.zzefr);
                zzawz.zzep((String)(string6.length() != 0 ? "AdExoPlayerHelper is null. Source: ".concat(string6) : new String("AdExoPlayerHelper is null. Source: ")));
                return;
            }
            this.zzefe = this.zzefq.zzys();
            this.zzeff = this.zzefq.zzyt();
            this.zzefg = this.zzefq.zzyu();
            if (this.zzefe != null) {
                this.zza(this.zzaez, false);
                this.zzeft = this.zzefe.getPlaybackState();
                if (this.zzeft == 4) {
                    this.zzyy();
                }
            }
        }
    }

    @SideEffectFree
    private final void zza(@Nullable Surface surface, boolean bl) {
        if (this.zzefe != null && this.zzeff != null) {
            if (bl) {
                this.zzefe.zzb(this.zzeff, 1, surface);
                return;
            }
            this.zzefe.zza((zzgf)this.zzeff, 1, surface);
            return;
        }
        zzawz.zzep((String)"Trying to set surface before player and renderers are initalized.");
    }

    @SideEffectFree
    private final void zza(float f, boolean bl) {
        if (this.zzefe != null && this.zzefg != null) {
            if (bl) {
                this.zzefe.zzb(this.zzefg, 1, Float.valueOf(f));
                return;
            }
            this.zzefe.zza((zzgf)this.zzefg, 1, Float.valueOf(f));
            return;
        }
        zzawz.zzep((String)"Trying to set volume before player and renderers are initalized.");
    }

    @Override
    public final void zzxk() {
        this.zza(this.zzebs.getVolume(), false);
    }

    private final void zzb(int n, int n2, float f) {
        float f2;
        float f3 = f2 = n2 == 0 ? 1.0f : (float)n * f / (float)n2;
        if (this.zzefn != f2) {
            this.zzefn = f2;
            this.requestLayout();
        }
    }

    private final void zzyy() {
        if (this.zzefu) {
            return;
        }
        this.zzefu = true;
        zzawz.zzds("Video is ready.");
        zzaxi.zzdvv.post((Runnable)new zzbdw(this));
        ((zzbco)this).zzxk();
        this.zzeaw.zzhd();
        if (this.zzefv) {
            ((zzbco)this).play();
        }
    }

    private final void zzyk() {
        zzawz.zzds("Video ended.");
        if (this.zzefp.zzeec) {
            this.zzza();
        }
        this.zzeaw.zzym();
        this.zzebs.zzym();
        zzaxi.zzdvv.post((Runnable)new zzbdx(this));
    }

    private final void zzn(String string2, @Nullable String string3) {
        zzawz.zzep((String)new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error received: ").append(string2).append(" : ").append(string3).toString());
        this.zzefs = true;
        if (this.zzefp.zzeec) {
            this.zzza();
        }
        zzaxi.zzdvv.post((Runnable)new zzbdy(this, string2, string3));
    }

    @Override
    public final String zzxg() {
        String string2 = this.zzefo == 1 ? "/Framework" : (this.zzefo == 2 ? new StringBuilder(12 + String.valueOf(null).length()).append("/Extractor(").append((String)null).append(")").toString() : "/Unknown");
        String string3 = this.zzebi ? " spherical" : "";
        return new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ExoPlayer/1").append(string2).append(string3).toString();
    }

    @Override
    public final void zza(zzbcn zzbcn2) {
        this.zzebk = zzbcn2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzefr = string2;
            this.zzyx();
            return;
        }
        zzawz.zzep((String)"Path is null.");
    }

    @Override
    public final void play() {
        if (this.zzyw()) {
            if (this.zzefp.zzeec) {
                this.zzyz();
            }
            this.zzefe.zzd(true);
            this.zzeaw.zzyl();
            this.zzebs.zzyl();
            this.zzebr.zzxm();
            zzaxi.zzdvv.post((Runnable)new zzbdz(this));
            return;
        }
        this.zzefv = true;
    }

    @Override
    public final void stop() {
        if (this.zzyv()) {
            this.zzefe.stop();
            zzbdq zzbdq2 = this;
            if (zzbdq2.zzefe != null) {
                zzbdq2.zza(null, true);
                if (zzbdq2.zzefq != null) {
                    zzbdq2.zzefq.zzyr();
                    zzbdq2.zzefq = null;
                }
                zzbdq2.zzefe = null;
                zzbdq2.zzeff = null;
                zzbdq2.zzefg = null;
                zzbdq2.zzeft = 1;
                zzbdq2.zzefs = false;
                zzbdq2.zzefu = false;
                zzbdq2.zzefv = false;
            }
        }
        this.zzeaw.zzym();
        this.zzebs.zzym();
        this.zzeaw.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzyw()) {
            if (this.zzefp.zzeec) {
                this.zzza();
            }
            this.zzefe.zzd(false);
            this.zzeaw.zzym();
            this.zzebs.zzym();
            zzaxi.zzdvv.post((Runnable)new zzbea(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzyw()) {
            this.zzefe.seekTo(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebh != null) {
            this.zzebh.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzyw()) {
            return (int)this.zzefe.zzdn();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzyw()) {
            return (int)this.zzefe.getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzebc;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzebd;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzefn != 0.0f && this.zzebh == null) {
            float f;
            float f2 = (float)n3 / (float)n4;
            float f3 = this.zzefn / f2 - 1.0f;
            if (f > 0.01f) {
                n4 = (int)((float)n3 / this.zzefn);
            } else if (f3 < -0.01f) {
                n3 = (int)((float)n4 * this.zzefn);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebh != null) {
            this.zzebh.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebf > 0 && this.zzebf != n3 || this.zzebg > 0 && this.zzebg != n4) {
                zzbdq zzbdq2 = this;
                if (zzbdq2.zzeax && zzbdq2.zzyv() && zzbdq2.zzefe.zzdn() > 0L && !zzbdq2.zzefe.zzdm()) {
                    zzbdq2.zza(0.0f, true);
                    zzbdq2.zzefe.zzd(true);
                    long l = zzbdq2.zzefe.zzdn();
                    long l2 = zzk.zzln().currentTimeMillis();
                    while (zzbdq2.zzyv() && zzbdq2.zzefe.zzdn() == l && zzk.zzln().currentTimeMillis() - l2 <= 250L) {
                    }
                    if (zzbdq2.zzyv()) {
                        zzbdq2.zzefe.zzd(false);
                    }
                    ((zzbco)zzbdq2).zzxk();
                }
            }
            this.zzebf = n3;
            this.zzebg = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebi) {
            this.zzebh = new zzbdd(this.getContext());
            this.zzebh.zza(surfaceTexture, n, n2);
            this.zzebh.start();
            SurfaceTexture surfaceTexture2 = this.zzebh.zzxy();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzebh.zzxx();
                this.zzebh = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzaez = new Surface(surfaceTexture3);
        if (this.zzefe == null) {
            this.zzyx();
        } else {
            this.zza(this.zzaez, true);
            if (!this.zzefp.zzeec) {
                this.zzyz();
            }
        }
        float f = 1.0f;
        if (this.zzebc != 0 && this.zzebd != 0) {
            n = this.zzebc;
            n2 = this.zzebd;
            f = this.zzaft;
        }
        this.zzb(n, n2, f);
        zzaxi.zzdvv.post((Runnable)new zzbeb(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebh != null) {
            this.zzebh.zzm(n, n2);
        }
        zzaxi.zzdvv.post((Runnable)new zzbec(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzawz.zzds("Surface destroyed");
        ((zzbco)this).pause();
        if (this.zzebh != null) {
            this.zzebh.zzxx();
            this.zzebh = null;
        }
        if (this.zzefe != null) {
            this.zzza();
            if (this.zzaez != null) {
                this.zzaez.release();
            }
            this.zzaez = null;
            this.zza(null, true);
        }
        zzaxi.zzdvv.post((Runnable)new zzbed(this));
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeaw.zzc(this);
        this.zzebr.zza(surfaceTexture, this.zzebk);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzawz.zzds(new StringBuilder(57).append("AdExoPlayerView1 window visibility changed to ").append(n).toString());
        zzaxi.zzdvv.post((Runnable)new zzbdt(this, n));
        super.onWindowVisibilityChanged(n);
    }

    private final void zzyz() {
        if (this.zzefe != null) {
            this.zzefe.zzc(0, true);
        }
    }

    private final void zzza() {
        if (this.zzefe != null) {
            this.zzefe.zzc(0, false);
        }
    }

    final /* synthetic */ void zzdd(int n) {
        if (this.zzebk != null) {
            this.zzebk.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzzb() {
        if (this.zzebk != null) {
            this.zzebk.zzxo();
        }
    }

    final /* synthetic */ void zzn(int n, int n2) {
        if (this.zzebk != null) {
            this.zzebk.zzk(n, n2);
        }
    }

    final /* synthetic */ void zzzc() {
        if (this.zzebk != null) {
            this.zzebk.zzxl();
        }
    }

    final /* synthetic */ void zzzd() {
        if (this.zzebk != null) {
            this.zzebk.onPaused();
        }
    }

    final /* synthetic */ void zzze() {
        if (this.zzebk != null) {
            this.zzebk.zzxm();
        }
    }

    final /* synthetic */ void zzo(String string2, String string3) {
        if (this.zzebk != null) {
            this.zzebk.zzl(string2, string3);
        }
    }

    final /* synthetic */ void zzzf() {
        if (this.zzebk != null) {
            this.zzebk.zzxn();
        }
    }

    final /* synthetic */ void zzzg() {
        if (this.zzebk != null) {
            this.zzebk.zzhd();
        }
    }

    final /* synthetic */ void zzb(boolean bl, long l) {
        this.zzebt.zza(bl, l);
    }

    final /* synthetic */ void zzc(boolean bl, long l) {
        this.zzebt.zza(bl, l);
    }

    static /* synthetic */ int zza(zzbdq zzbdq2) {
        return zzbdq2.zzeft;
    }

    static /* synthetic */ int zza(zzbdq zzbdq2, int n) {
        zzbdq2.zzeft = n;
        return zzbdq2.zzeft;
    }

    static /* synthetic */ void zzb(zzbdq zzbdq2) {
        zzbdq2.zzyy();
    }

    static /* synthetic */ void zzc(zzbdq zzbdq2) {
        zzbdq2.zzyk();
    }

    static /* synthetic */ void zza(zzbdq zzbdq2, String string2, String string3) {
        zzbdq2.zzn(string2, string3);
    }

    static /* synthetic */ int zzb(zzbdq zzbdq2, int n) {
        zzbdq2.zzebc = n;
        return zzbdq2.zzebc;
    }

    static /* synthetic */ int zzc(zzbdq zzbdq2, int n) {
        zzbdq2.zzebd = n;
        return zzbdq2.zzebd;
    }

    static /* synthetic */ float zza(zzbdq zzbdq2, float f) {
        zzbdq2.zzaft = f;
        return zzbdq2.zzaft;
    }

    static /* synthetic */ int zzd(zzbdq zzbdq2) {
        return zzbdq2.zzebc;
    }

    static /* synthetic */ int zze(zzbdq zzbdq2) {
        return zzbdq2.zzebd;
    }

    static /* synthetic */ float zzf(zzbdq zzbdq2) {
        return zzbdq2.zzaft;
    }

    static /* synthetic */ void zza(zzbdq zzbdq2, int n, int n2, float f) {
        zzbdq2.zzb(n, n2, f);
    }
}

