/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbew;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzrx;
import com.google.android.gms.internal.ads.zzry;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzsc;
import com.google.android.gms.internal.ads.zzsd;
import com.google.android.gms.internal.ads.zzsj;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsy;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@zzard
final class zzbev
implements zzrv {
    private static final Pattern zzapl = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzapm = new AtomicReference();
    private SSLSocketFactory zzegl = new zzbew(this);
    private final int zzapo;
    private final int zzapp;
    private final String zzapq;
    private final zzsd zzbmm;
    private final zzsj<? super zzbev> zzbmn;
    private zzry zzbmo;
    private HttpURLConnection zzapu;
    private InputStream zzapv;
    private boolean zzapd;
    private long zzapw;
    private long zzapx;
    private long zzapy;
    private long zzce;
    private int zzegm;
    private Set<Socket> zzegn = new HashSet<Socket>();

    zzbev(String string2, zzsj<? super zzbev> zzsj2, int n, int n2, int n3) {
        this.zzapq = zzsk.checkNotEmpty(string2);
        this.zzbmn = zzsj2;
        this.zzbmm = new zzsd();
        this.zzapo = n;
        this.zzapp = n2;
        this.zzegm = n3;
    }

    @Override
    public final Uri getUri() {
        if (this.zzapu == null) {
            return null;
        }
        return Uri.parse((String)this.zzapu.getURL().toString());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final long zza(zzry var1_1) throws zzsb {
        this.zzbmo = var1_1;
        this.zzce = 0L;
        this.zzapy = 0L;
        try {
            block20: {
                var6_2 = var1_1;
                var5_3 = this;
                var7_4 = new URL(var6_2.uri.toString());
                var8_5 = var6_2.zzbmd;
                var9_6 = var6_2.zzahv;
                var11_7 = var6_2.zzcd;
                var13_8 = var6_2.zzbk(1);
                var14_9 = 0;
                while (var14_9++ <= 20) {
                    var25_20 = var13_8;
                    var23_19 = var11_7;
                    var21_18 = var9_6;
                    var20_16 /* !! */  = var8_5;
                    var19_15 = var7_4;
                    var18_14 = var5_3;
                    var26_21 = (HttpURLConnection)var19_15.openConnection();
                    if (var26_21 instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)var26_21).setSSLSocketFactory(var18_14.zzegl);
                    }
                    var26_21.setConnectTimeout(var18_14.zzapo);
                    var26_21.setReadTimeout(var18_14.zzapp);
                    for (Object var28_23 : var18_14.zzbmm.zzjw().entrySet()) {
                        var26_21.setRequestProperty(var28_23.getKey(), var28_23.getValue());
                    }
                    if (var21_18 != 0L || var23_19 != -1L) {
                        var27_22 = new StringBuilder(27).append("bytes=").append(var21_18).append("-").toString();
                        if (var23_19 != -1L) {
                            var28_23 = String.valueOf(var27_22);
                            var29_24 = var21_18 + var23_19 - 1L;
                            var27_22 = new StringBuilder(20 + String.valueOf(var28_23).length()).append((String)var28_23).append(var29_24).toString();
                        }
                        var26_21.setRequestProperty("Range", (String)var27_22);
                    }
                    var26_21.setRequestProperty("User-Agent", var18_14.zzapq);
                    if (!var25_20) {
                        var26_21.setRequestProperty("Accept-Encoding", "identity");
                    }
                    var26_21.setInstanceFollowRedirects(false);
                    var26_21.setDoOutput(var20_16 /* !! */  != null);
                    if (var20_16 /* !! */  == null) ** GOTO lbl-1000
                    var26_21.setRequestMethod("POST");
                    if (var20_16 /* !! */ .length != 0) {
                        var26_21.setFixedLengthStreamingMode(var20_16 /* !! */ .length);
                        var26_21.connect();
                        var27_22 = var26_21.getOutputStream();
                        var27_22.write(var20_16 /* !! */ );
                        var27_22.close();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var26_21.connect();
                    }
                    var15_10 = var26_21;
                    var16_12 = var15_10.getResponseCode();
                    if (var16_12 == 300 || var16_12 == 301 || var16_12 == 302 || var16_12 == 303 || var8_5 == null && (var16_12 == 307 || var16_12 == 308)) {
                        var8_5 = null;
                        var17_13 = var15_10.getHeaderField("Location");
                        var15_10.disconnect();
                        var19_15 = var17_13;
                        var18_14 = var7_4;
                        if (var19_15 == null) {
                            throw new ProtocolException("Null location redirect");
                        }
                        v0 = new URL((URL)var18_14, (String)var19_15);
                        var20_16 /* !! */  = (byte[])v0;
                        var21_17 = v0.getProtocol();
                        if (!"https".equals(var21_17) && !"http".equals(var21_17)) {
                            v1 = String.valueOf(var21_17);
                            throw new ProtocolException(v1.length() != 0 ? "Unsupported protocol redirect: ".concat(v1) : new String("Unsupported protocol redirect: "));
                        }
                        var7_4 = var20_16 /* !! */ ;
                        continue;
                    }
                    break block20;
                }
                var15_11 = var14_9;
                throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(var15_11).toString());
            }
            this.zzapu = var15_10;
        }
        catch (IOException var2_25) {
            v2 = String.valueOf(var1_1.uri.toString());
            throw new zzsb(v2.length() != 0 ? "Unable to connect to ".concat(v2) : new String("Unable to connect to "), var2_25, var1_1, 1);
        }
        try {
            var2_26 = this.zzapu.getResponseCode();
        }
        catch (IOException var3_27) {
            this.zzjv();
            v3 = String.valueOf(var1_1.uri.toString());
            throw new zzsb(v3.length() != 0 ? "Unable to connect to ".concat(v3) : new String("Unable to connect to "), var3_27, var1_1, 1);
        }
        if (var2_26 < 200 || var2_26 > 299) {
            var3_28 = this.zzapu.getHeaderFields();
            this.zzjv();
            var4_31 = new zzsc(var2_26, var3_28, var1_1);
            if (var2_26 == 416) {
                var4_31.initCause(new zzrx(0));
            }
            throw var4_31;
        }
        v4 = this.zzapw = var2_26 == 200 && var1_1.zzahv != 0L ? var1_1.zzahv : 0L;
        this.zzapx = !var1_1.zzbk(1) ? (var1_1.zzcd != -1L ? var1_1.zzcd : ((var3_29 = zzbev.zzc(this.zzapu)) != -1L ? var3_29 - this.zzapw : -1L)) : var1_1.zzcd;
        try {
            this.zzapv = this.zzapu.getInputStream();
        }
        catch (IOException var3_30) {
            this.zzjv();
            throw new zzsb(var3_30, var1_1, 1);
        }
        this.zzapd = true;
        if (this.zzbmn != null) {
            this.zzbmn.zza(this, var1_1);
        }
        return this.zzapx;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzsb {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zzbev zzbev2 = this;
            if (zzbev2.zzapy != zzbev2.zzapw) {
                byArray2 = zzapm.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zzbev2.zzapy != zzbev2.zzapw) {
                    n5 = (int)Math.min(zzbev2.zzapw - zzbev2.zzapy, (long)byArray2.length);
                    n4 = zzbev2.zzapv.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zzbev2.zzapy += (long)n4;
                    if (zzbev2.zzbmn == null) continue;
                    zzbev2.zzbmn.zzc(zzbev2, n4);
                }
                zzapm.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zzbev2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zzbev2.zzapx != -1L) {
                long l = zzbev2.zzapx - zzbev2.zzce;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zzbev2.zzapv.read(byArray2, n5, n4)) == -1) {
                if (zzbev2.zzapx != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zzbev2.zzce += (long)n3;
            if (zzbev2.zzbmn != null) {
                zzbev2.zzbmn.zzc(zzbev2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzsb(iOException, this.zzbmo, 2);
        }
    }

    @Override
    public final void close() throws zzsb {
        try {
            if (this.zzapv != null) {
                block13: {
                    Object object = this;
                    long l = ((zzbev)object).zzapx == -1L ? ((zzbev)object).zzapx : ((zzbev)object).zzapx - ((zzbev)object).zzce;
                    object = this.zzapu;
                    if (zzsy.SDK_INT == 19 || zzsy.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block13;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzapv.close();
                }
                catch (IOException iOException) {
                    throw new zzsb(iOException, this.zzbmo, 3);
                }
            }
            return;
        }
        finally {
            this.zzapv = null;
            this.zzjv();
            if (this.zzapd) {
                this.zzapd = false;
                if (this.zzbmn != null) {
                    this.zzbmn.zze(this);
                }
            }
            this.zzegn.clear();
        }
    }

    final void setReceiveBufferSize(int n) {
        this.zzegm = n;
        for (Socket socket : this.zzegn) {
            if (socket.isClosed()) continue;
            try {
                socket.setReceiveBufferSize(this.zzegm);
            }
            catch (SocketException socketException) {
                zzawz.zzd((String)"Failed to update receive buffer size.", (Throwable)socketException);
            }
        }
    }

    private final void zza(Socket socket) {
        this.zzegn.add(socket);
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                zzawz.zzen((String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzapl.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    zzawz.zzep((String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzawz.zzen((String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzjv() {
        if (this.zzapu != null) {
            try {
                this.zzapu.disconnect();
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzapu = null;
        }
    }

    static /* synthetic */ int zza(zzbev zzbev2) {
        return zzbev2.zzegm;
    }

    static /* synthetic */ void zza(zzbev zzbev2, Socket socket) {
        zzbev2.zza(socket);
    }
}

