/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.internal.ads.zzaho;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzazr;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzbcq;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzyt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
public final class zzbfo
implements zzaho<zzbdf> {
    private boolean zzehp;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzyt.zzpa();
                n2 = zzazt.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzawz.zzep((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzbcq zzbcq2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        String string6 = map.get("socketReceiveBufferSize");
        try {
            int n;
            if (string2 != null) {
                n = Integer.parseInt(string2);
                zzbcq2.zzcy(n);
            }
            if (string3 != null) {
                n = Integer.parseInt(string3);
                zzbcq2.zzcz(n);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
                zzbcq2.zzda(n);
            }
            if (string5 != null) {
                n = Integer.parseInt(string5);
                zzbcq2.zzdb(n);
            }
            if (string6 != null) {
                n = Integer.parseInt(string6);
                zzbcq2.zzdc(n);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzawz.zzep((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        zzbcq zzbcq2;
        Object object2;
        Object object3;
        Map map2 = map;
        zzbdf zzbdf2 = (zzbdf)object;
        zzbfo zzbfo2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzawz.zzep((String)"Action missing from video GMSG.");
            return;
        }
        if (zzawz.isLoggable((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzawz.zzdp((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzawz.zzep((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzbdf2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzawz.zzep((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzawz.zzep((String)"No MIME types specified for decoder properties inspection.");
                zzbcq.zza(zzbdf2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzawz.zzep((String)"Video decoder properties available on API versions >= 16.");
                zzbcq.zza(zzbdf2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzazr.zzeh(string3.trim()));
            }
            zzbcq.zza(zzbdf2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzbdf2.zzya();
        if (object3 == null) {
            zzawz.zzep((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzbdf2.getContext();
            int n2 = zzbfo.zza(context, map2, "x", 0);
            int n3 = zzbfo.zza(context, map2, "y", 0);
            int n4 = zzbfo.zza(context, map2, "w", -1);
            int n5 = zzbfo.zza(context, map2, "h", -1);
            n4 = Math.min(n4, zzbdf2.zzyj() - n2);
            n5 = Math.min(n5, zzbdf2.zzyi() - n3);
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzbcw)object3).zzxw() == null) {
                zzbde zzbde2 = new zzbde((String)map2.get("flags"));
                ((zzbcw)object3).zza(n2, n3, n4, n5, n, bl3, zzbde2);
                zzbcq zzbcq3 = ((zzbcw)object3).zzxw();
                if (zzbcq3 != null) {
                    zzbfo.zza(zzbcq3, map2);
                }
                return;
            }
            ((zzbcw)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzbhq zzbhq2 = zzbdf2.zzyb();
        if (zzbhq2 != null) {
            if ("timeupdate".equals(string2)) {
                String string4 = (String)map2.get("currentTime");
                if (string4 == null) {
                    zzawz.zzep((String)"currentTime parameter missing from timeupdate video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzbhq2.zze(f);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzawz.zzep((String)(string5.length() != 0 ? "Could not parse currentTime parameter from timeupdate video GMSG: ".concat(string5) : new String("Could not parse currentTime parameter from timeupdate video GMSG: ")));
                    return;
                }
            }
            if ("skip".equals(string2)) {
                zzbhq2.zzabs();
                return;
            }
        }
        if ((zzbcq2 = ((zzbcw)object3).zzxw()) == null) {
            zzbcq.zzb(zzbdf2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzbdf2.getContext();
            int n = zzbfo.zza(context, map2, "x", 0);
            int n6 = zzbfo.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzbcq2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string6 = (String)map2.get("time");
            if (string6 == null) {
                zzawz.zzep((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string6) * 1000.0f);
                zzbcq2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzawz.zzep((String)(string7.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string7) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzbcq2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzbcq2.zzfr();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzbfo.zza(zzbcq2, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzbcq2.zzxq();
                return;
            }
            zzbcq2.zzxr();
            return;
        }
        if ("pause".equals(string2)) {
            zzbcq2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzbcq2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzbcq2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            String string8 = (String)map2.get("src");
            String[] stringArray = new String[]{string8};
            String string9 = (String)map2.get("demuxed");
            if (string9 != null) {
                try {
                    JSONArray jSONArray = new JSONArray(string9);
                    stringArray = new String[jSONArray.length()];
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        stringArray[i] = jSONArray.getString(i);
                    }
                }
                catch (JSONException jSONException) {
                    String string10 = String.valueOf(string9);
                    zzawz.zzep((String)(string10.length() != 0 ? "Malformed demuxed URL list for playback: ".concat(string10) : new String("Malformed demuxed URL list for playback: ")));
                    stringArray = new String[]{string8};
                }
            }
            zzbcq2.zzc(string8, stringArray);
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzbdf2.getContext();
            int n = zzbfo.zza(context, map2, "dx", 0);
            int n7 = zzbfo.zza(context, map2, "dy", 0);
            zzbcq2.zza(n, n7);
            if (!zzbfo2.zzehp) {
                zzbdf2.zztm();
                zzbfo2.zzehp = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string11 = (String)map2.get("volume");
            if (string11 == null) {
                zzawz.zzep((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string11);
                zzbcq2.setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string12 = String.valueOf(string11);
                zzawz.zzep((String)(string12.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string12) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzbcq2.zzxs();
            return;
        }
        String string13 = String.valueOf(string2);
        zzawz.zzep((String)(string13.length() != 0 ? "Unknown video action: ".concat(string13) : new String("Unknown video action: ")));
    }
}

